/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.complex;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.structuredTypes.Set;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class SetAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;
    private String typeDefinition;
    private int numberOfPossibleValues;
    public static boolean m_isEqualLength = true;
    int m_Length = -1;

    public SetAttrType(String name) {
        super(name);
    }

    public SetAttrType(String name, String typeDefinition) {
        super(name);
        typeDefinition = typeDefinition.toUpperCase();
        this.setTypeDefinition(typeDefinition);
        if (typeDefinition.contains("NOMINAL[")) {
            int start = typeDefinition.indexOf("NOMINAL[");
            int end = typeDefinition.indexOf("]", start);
            String nominalDefinition = typeDefinition.substring(start, end);
            StringTokenizer st = new StringTokenizer(nominalDefinition, ",");
            this.numberOfPossibleValues = st.countTokens();
        }
    }

    public SetAttrType(String name, String typeDefinition, int numberOfPossibleValues) {
        this(name, typeDefinition);
        this.setNumberOfPossibleValues(numberOfPossibleValues);
    }

    @Override
    public ClusAttrType cloneType() {
        SetAttrType tsat = new SetAttrType(this.m_Name);
        return tsat;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.Set;
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Object;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    public Set getSet(DataTuple tuple) {
        return (Set)tuple.getObjVal(this.m_ArrayIndex);
    }

    public void setSet(DataTuple tuple, Set value) {
        tuple.setObjectVal(value, this.m_ArrayIndex);
    }

    @Override
    public String getString(DataTuple tuple) {
        Set ts_data = (Set)tuple.getObjVal(this.getArrayIndex());
        return ts_data.toString();
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    public boolean isEqualLength() {
        return m_isEqualLength;
    }

    @Override
    public void writeARFFType(PrintWriter wrt) throws ClusException {
        wrt.print("Set");
    }

    @Override
    public void setTypeDefinition(String typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    @Override
    public String getTypeDefinition() {
        return this.typeDefinition;
    }

    public void setNumberOfPossibleValues(int numberOfPossibleValues) {
        this.numberOfPossibleValues = numberOfPossibleValues;
    }

    public int getNumberOfPossibleValues() {
        return this.numberOfPossibleValues;
    }

    public class MySerializable
    extends ClusSerializable {
        public String getString(DataTuple tuple) {
            Set ts_data = (Set)tuple.getObjVal(0);
            Object[] data = ts_data.getValues();
            String str = "[";
            for (int k = 0; k < data.length; ++k) {
                str.concat(String.valueOf(data[k]));
                if (k >= data.length - 1) continue;
                str.concat(", ");
            }
            str.concat("]");
            return str;
        }

        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            String str = data.readSet();
            if (str == null) {
                return false;
            }
            Set value = new Set(str, SetAttrType.this.getTypeDefinition());
            tuple.setObjectVal(value, SetAttrType.this.getArrayIndex());
            return true;
        }
    }
}

