/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.kNN.distance.valentin.BasicDistance;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.cols.attribute.ClusAttribute;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.data.type.complex.TupleAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.TupleDistance;
import si.ijs.kt.clus.distance.complex.tuples.EuclideanDistance;
import si.ijs.kt.clus.distance.complex.tuples.MinkowskiDistance;
import si.ijs.kt.clus.distance.primitive.timeseries.DTWTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.QDMTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.TSCTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.TimeSeriesDist;
import si.ijs.kt.clus.ext.structuredTypes.Tuple;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public abstract class ClusAttrType
implements Serializable,
Comparable<ClusAttrType> {
    public static final long serialVersionUID = 1L;
    protected String m_Name;
    protected int m_Index;
    protected int m_ArrayIndex;
    private int m_DatasetIndex;
    protected int m_NbMissing;
    protected ClusSchema m_Schema;
    protected Status m_Status = Status.Normal;
    protected boolean m_IsDescriptive;
    protected boolean m_IsClustering;
    private BasicDistance dist;
    private String typeDefinition;
    private ClusAttrType[] innerTypes;

    public ClusAttrType(String name) {
        this.m_Name = name;
        this.m_Index = -1;
        this.m_ArrayIndex = -1;
    }

    public ClusAttrType(String name, String typeDefinition) {
        this(name);
        this.setTypeDefinition(typeDefinition);
    }

    public void setSchema(ClusSchema schema) {
        this.m_Schema = schema;
    }

    public ClusSchema getSchema() {
        return this.m_Schema;
    }

    public Settings getSettings() {
        return this.m_Schema.getSettings();
    }

    public abstract ClusAttrType cloneType();

    public void cloneType(ClusAttrType type) {
        type.m_NbMissing = this.m_NbMissing;
        type.m_Status = this.m_Status;
        type.m_IsDescriptive = this.m_IsDescriptive;
        type.m_IsClustering = this.m_IsClustering;
    }

    public void copyArrayIndex(ClusAttrType type) {
        this.m_ArrayIndex = type.m_ArrayIndex;
    }

    public abstract AttributeType getAttributeType();

    public abstract ValueType getValueType();

    public abstract String getTypeName();

    public int intHasMissing() {
        return this.m_NbMissing > 0 ? 1 : 0;
    }

    public boolean hasMissing() {
        return this.m_NbMissing > 0;
    }

    public int getNbMissing() {
        return this.m_NbMissing;
    }

    public void incNbMissing() {
        ++this.m_NbMissing;
    }

    public void setNbMissing(int nb) {
        this.m_NbMissing = nb;
    }

    public void setToMissing(DataTuple t) {
        throw new RuntimeException("clus.data.type.ClusAttrType.setToMissing(DataTuple) is not implemented!");
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public int getIndex() {
        return this.m_Index;
    }

    public void setIndex(int idx) {
        this.m_Index = idx;
    }

    public final int getArrayIndex() {
        return this.m_ArrayIndex;
    }

    public void setArrayIndex(int idx) {
        this.m_ArrayIndex = idx;
    }

    public int getDatasetIndex() {
        return this.m_DatasetIndex;
    }

    public void setDatasetIndex(int i) {
        this.m_DatasetIndex = i;
    }

    public Status getStatus() {
        return this.m_Status;
    }

    public void setStatus(Status status) {
        this.m_Status = status;
    }

    public boolean isTarget() {
        return this.m_Status.equals((Object)Status.Target);
    }

    public boolean isDisabled() {
        return this.m_Status.equals((Object)Status.Disabled);
    }

    public boolean isKey() {
        return this.m_Status.equals((Object)Status.Key);
    }

    public boolean isGIS() {
        return this.m_Status.equals((Object)Status.GIS);
    }

    public boolean isClustering() {
        return this.m_IsClustering;
    }

    public void setClustering(boolean clust) {
        this.m_IsClustering = clust;
    }

    public void setDescriptive(boolean descr) {
        this.m_IsDescriptive = descr;
    }

    public boolean isDescriptive() {
        return this.m_IsDescriptive;
    }

    public int getMaxNbStats() {
        return 0;
    }

    public void setReader(boolean start_stop) {
    }

    public ClusAttrType getType() {
        return this;
    }

    public void setNbRows(int nbrows) {
    }

    public int getNominal(DataTuple tuple) {
        return -1;
    }

    public double getNumeric(DataTuple tuple) {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isMissing(DataTuple tuple) {
        System.err.println("Calling clus.data.type.ClusAttrType.isMissing(DataTuple) which is not implemented.");
        return true;
    }

    public void updatePredictWriterSchema(ClusSchema schema) {
        schema.addAttrType(this.cloneType());
    }

    public String getPredictionWriterString(DataTuple tuple) {
        return this.getString(tuple);
    }

    public String getString(DataTuple tuple) {
        return "err";
    }

    public int compareValue(DataTuple t1, DataTuple t2) {
        throw new RuntimeException("si.ijs.kt.clus.data.type.ClusAttrType.compareValue(DataTuple, DataTuple) not implemented!");
    }

    public void getPreprocs(DataPreprocs pps, boolean single) {
    }

    public ClusSerializable createRowSerializable() throws ClusException {
        throw new ClusException("Attribute " + this.getName() + " does not support row data");
    }

    public ClusAttribute createTargetAttr(ColTarget target) throws ClusException {
        throw new ClusException("Attribute " + this.getName() + " can not be target: incompatible type");
    }

    public String toString() {
        return this.getName();
    }

    public void initializeBeforeLoadingData() throws IOException, ClusException {
    }

    public void initializeFrom(ClusAttrType other_type) {
    }

    public void writeARFFType(PrintWriter wrt) throws ClusException {
        throw new ClusException("Type: " + this.getClass().getName() + " can't be written to a .arff file");
    }

    public double getBasicDistance(DataTuple t1, DataTuple t2) {
        return this.dist.getDistance(this, t1, t2);
    }

    public void setBasicDistance(BasicDistance bdist) {
        this.dist = bdist;
    }

    @Override
    public int compareTo(ClusAttrType c) {
        if (c.m_Index > this.m_Index) {
            return 1;
        }
        if (c.m_Index < this.m_Index) {
            return -1;
        }
        return 0;
    }

    public boolean isSparse() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isNominal() {
        return false;
    }

    public boolean isClasses() {
        return false;
    }

    public boolean isTimeSeries() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public static Object createDataObject(String object, ClusAttrType attrType) {
        if (attrType instanceof TupleAttrType) {
            object = object.substring(1);
            object = object.substring(0, object.length() - 1);
            char[] td = object.toCharArray();
            int cnt = 0;
            StringBuilder innerObject = new StringBuilder();
            ArrayList<String> innerObjects = new ArrayList<String>();
            for (int i = 0; i < td.length; ++i) {
                if (td[i] == '[') {
                    ++cnt;
                    innerObject.append(td[i]);
                    continue;
                }
                if (td[i] == ']') {
                    --cnt;
                    innerObject.append(td[i]);
                    continue;
                }
                if (td[i] == ',') {
                    if (cnt == 0) {
                        innerObjects.add(innerObject.toString());
                        innerObject = new StringBuilder();
                        continue;
                    }
                    innerObject.append(td[i]);
                    continue;
                }
                if (td[i] == ' ') continue;
                innerObject.append(td[i]);
            }
            innerObjects.add(innerObject.toString());
            Object[] innerTupleObjects = new Object[innerObjects.size()];
            ClusAttrType[] innerTypes = attrType.getInnerTypes();
            int i = 0;
            for (String iType : innerObjects) {
                innerTupleObjects[i] = ClusAttrType.createDataObject(iType, innerTypes[i]);
                ++i;
            }
            return new Tuple(innerTupleObjects);
        }
        if (attrType instanceof TimeSeriesAttrType) {
            if (object.trim().equalsIgnoreCase("?")) {
                return null;
            }
            return new TimeSeries(object);
        }
        if (attrType instanceof NumericAttrType) {
            return new Double(object);
        }
        return null;
    }

    public static ClusAttrType createClusAttrType(String typeDef, String name) {
        String typeDefinition = typeDef.toUpperCase();
        if ((typeDefinition = typeDefinition.trim()).startsWith("TUPLE[")) {
            typeDefinition = typeDefinition.substring(6);
            typeDefinition = typeDefinition.substring(0, typeDefinition.length() - 1);
            char[] td = typeDefinition.toCharArray();
            int cnt = 0;
            StringBuffer innerType = new StringBuffer();
            ArrayList<String> innerTypes = new ArrayList<String>();
            for (int i = 0; i < td.length; ++i) {
                if (td[i] == '[') {
                    ++cnt;
                    innerType.append(td[i]);
                    continue;
                }
                if (td[i] == ']') {
                    --cnt;
                    innerType.append(td[i]);
                    continue;
                }
                if (td[i] == ',') {
                    if (cnt == 0) {
                        innerTypes.add(innerType.toString());
                        innerType = new StringBuffer();
                        continue;
                    }
                    innerType.append(td[i]);
                    continue;
                }
                if (td[i] == ' ') continue;
                innerType.append(td[i]);
            }
            innerTypes.add(innerType.toString());
            ClusAttrType[] innerClussAttrTypes = new ClusAttrType[innerTypes.size()];
            int i = 0;
            for (String iType : innerTypes) {
                innerClussAttrTypes[i++] = ClusAttrType.createClusAttrType(iType, "inner");
            }
            return new TupleAttrType(name, typeDef, innerClussAttrTypes);
        }
        if (typeDefinition.startsWith("TIMESERIES")) {
            return new TimeSeriesAttrType(name, "TIMESERIES");
        }
        if (typeDefinition.equalsIgnoreCase("NUMERIC")) {
            return new NumericAttrType(name);
        }
        return null;
    }

    public static ClusDistance createDistance(ClusAttrType type, Settings settings) {
        if (type instanceof TupleAttrType) {
            TupleAttrType tupleType = (TupleAttrType)type;
            ClusAttrType[] innertypes = tupleType.getInnerTypes();
            ClusDistance[] innerDistances = new ClusDistance[innertypes.length];
            int i = 0;
            for (ClusAttrType iType : innertypes) {
                innerDistances[i++] = ClusAttrType.createDistance(iType, settings);
            }
            TupleDistance tupleDist = null;
            switch (settings.getTree().getTupleDistance()) {
                case Euclidean: {
                    tupleDist = new EuclideanDistance((TupleAttrType)type, innerDistances);
                    break;
                }
                case Minkowski: {
                    tupleDist = new MinkowskiDistance(3, innerDistances);
                }
            }
            return tupleDist;
        }
        if (type instanceof TimeSeriesAttrType) {
            TimeSeriesDist tsDistance = null;
            switch (settings.getTree().getTSDistance()) {
                case DTW: {
                    tsDistance = new DTWTimeSeriesDist((TimeSeriesAttrType)type);
                    break;
                }
                case QDM: {
                    tsDistance = new QDMTimeSeriesDist((TimeSeriesAttrType)type);
                    break;
                }
                case TSC: {
                    tsDistance = new TSCTimeSeriesDist((TimeSeriesAttrType)type);
                }
            }
            return tsDistance;
        }
        return null;
    }

    public ClusAttrType[] getInnerTypes() {
        return this.innerTypes;
    }

    public void setInnerTypes(ClusAttrType[] innerTypes) {
        this.innerTypes = innerTypes;
    }

    public String getTypeDefinition() {
        return this.typeDefinition;
    }

    public void setTypeDefinition(String typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    public JsonObject getAttributeJSON() {
        JsonObject elm = new JsonObject();
        elm.addProperty("attributeName", this.getName());
        if (this instanceof NumericAttrType) {
            elm.addProperty("attributeType", "numeric");
        } else if (this instanceof NominalAttrType) {
            elm.addProperty("attributeType", "nominal");
        } else if (this instanceof TimeSeriesAttrType) {
            elm.addProperty("attributeType", "timeseries");
        } else if (this instanceof TupleAttrType) {
            elm.addProperty("attributeType", "tuple");
        } else if (this instanceof SetAttrType) {
            elm.addProperty("attributeType", "set");
        }
        return elm;
    }

    public static enum Status {
        Disabled,
        Target,
        ClusterNoTarget,
        Normal,
        Key,
        GIS;

    }

    public static enum AttributeType {
        Nominal("Nominal"),
        Numeric("Numeric"),
        Classes("Classes"),
        Index("Index"),
        String("String"),
        Integer("Integer"),
        TimeSeries("TimeSeries"),
        Set("Set"),
        Tuple("Tuple");

        private String typeName;

        private AttributeType(String typeName) {
            this.typeName = typeName;
        }

        public String getName() {
            return this.typeName;
        }
    }

    public static enum ValueType {
        None(0),
        Int(1),
        Double(2),
        Object(3),
        BitwiseInt(4);

        private int index;

        private ValueType(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum AttributeUseType {
        All(0),
        Descriptive(1),
        Clustering(2),
        Target(3),
        Key(4),
        GIS(5);

        private int index;

        private AttributeUseType(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

