/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.rows;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.SparseNumericAttrType;

public class SparseDataTuple
extends DataTuple {
    public static final long serialVersionUID = 1L;
    protected HashMap<Integer, Double> m_Map = new HashMap();

    public SparseDataTuple(ClusSchema schema) {
        super(schema);
    }

    public SparseDataTuple() {
    }

    public void setDoubleValueSparse(Double val, Integer index) {
        if (Math.abs(val) > 1.0E-9) {
            this.m_Map.put(index, val);
        } else if (this.m_Map.containsKey(index)) {
            this.m_Map.remove(index);
        }
    }

    public double getDoubleValueSparse(int index) {
        Double value = this.m_Map.get(new Integer(index));
        return value != null ? value : 0.0;
    }

    public double getDoubleValueSparse(Integer index) {
        Double value = this.m_Map.get(index);
        return value != null ? value : 0.0;
    }

    public Integer[] getAttributeIndices() {
        return this.m_Map.keySet().toArray(new Integer[0]);
    }

    public Set<Integer> getAttributeIndicesSet() {
        return this.m_Map.keySet();
    }

    public void addExampleToAttributes() {
        Integer[] indices = this.getAttributeIndices();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            SparseNumericAttrType attr = (SparseNumericAttrType)this.getSchema().getAttrType(index);
            attr.addExample(this);
        }
    }

    @Override
    public final SparseDataTuple cloneTuple() {
        SparseDataTuple res = new SparseDataTuple();
        this.cloneTuple(res);
        res.m_Map = this.m_Map;
        for (Integer i : this.m_Map.keySet()) {
            res.m_Map.put(i, this.m_Map.get(i));
        }
        return res;
    }

    @Override
    public SparseDataTuple deepCloneTuple() {
        SparseDataTuple res = new SparseDataTuple();
        if (this.m_Ints != null) {
            res.m_Ints = new int[this.m_Ints.length];
            System.arraycopy(this.m_Ints, 0, res.m_Ints, 0, this.m_Ints.length);
        }
        if (this.m_Doubles != null) {
            res.m_Doubles = new double[this.m_Doubles.length];
            System.arraycopy(this.m_Doubles, 0, res.m_Doubles, 0, this.m_Doubles.length);
        }
        if (this.m_Objects != null) {
            res.m_Objects = new Object[this.m_Objects.length];
            System.arraycopy(this.m_Objects, 0, res.m_Objects, 0, this.m_Objects.length);
        }
        res.m_Weight = this.m_Weight;
        res.m_Index = this.m_Index;
        res.m_Folds = this.m_Folds;
        res.m_Schema = this.m_Schema;
        for (Integer i : this.m_Map.keySet()) {
            res.m_Map.put(i, this.m_Map.get(i));
        }
        return res;
    }

    @Override
    public void writeTuple(PrintWriter wrt) {
        int nidx;
        ClusSchema schema = this.getSchema();
        int aidx = 0;
        wrt.print("{");
        for (Integer idx : this.m_Map.keySet()) {
            ClusAttrType type = schema.getAttrType(idx);
            if (type.isDisabled()) continue;
            if (aidx != 0) {
                wrt.print(",");
            }
            nidx = idx + 1;
            wrt.print(nidx + " " + type.getString(this));
            ++aidx;
        }
        ClusAttrType[] type = schema.getNonSparseAttributes();
        for (int i = 0; i < type.length; ++i) {
            if (type[i].isDisabled()) continue;
            if (aidx != 0) {
                wrt.print(",");
            }
            nidx = type[i].getIndex() + 1;
            wrt.print(nidx + " " + type[i].getString(this));
            ++aidx;
        }
        wrt.println("}");
    }

    @Override
    public boolean isSparse() {
        return true;
    }
}

