/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.rows;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.MemoryTupleIterator;
import si.ijs.kt.clus.data.rows.RowDataSortHelper;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.model.test.ClusRuleConstraintInduceTest;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.model.test.SoftTest;
import si.ijs.kt.clus.selection.ClusSelection;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.ClusRandomNonstatic;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.compound.DoubleObject;
import si.ijs.kt.clus.util.jeans.util.sort.MSortable;
import si.ijs.kt.clus.util.jeans.util.sort.MSorter;

public class RowData
extends ClusData
implements MSortable,
Serializable {
    private static final long serialVersionUID = 1L;
    public int m_Index;
    public ClusSchema m_Schema;
    private DataTuple[] m_Data;
    private HashMap<NumericAttrType, Integer[]> m_SortedInstances = new HashMap();

    public RowData(ClusSchema schema) {
        this.m_Schema = schema;
    }

    public RowData(ClusSchema schema, int size) {
        this.m_Schema = schema;
        this.resizeEmpty(size);
    }

    public RowData(RowData data) {
        this(data.m_Data, data.getNbRows());
        this.m_Schema = data.m_Schema;
        this.setIndices();
        this.checkData(false);
    }

    public RowData(Object[] data, int size) {
        this.m_Data = new DataTuple[size];
        System.arraycopy(data, 0, this.m_Data, 0, size);
        this.setNbRows(size);
        this.setIndices();
        this.checkData(false);
    }

    public RowData(ArrayList list, ClusSchema schema) {
        this(list, schema, false);
    }

    public RowData(ArrayList list, ClusSchema schema, boolean isTest) {
        this.m_Schema = schema;
        this.setFromList(list);
        this.setIndices();
        this.checkData(isTest);
    }

    private void setIndices() {
        for (int i = 0; i < this.m_Data.length; ++i) {
            this.m_Data[i].setDatasetIndex(i);
        }
    }

    public DataTuple[] getData() {
        return this.m_Data;
    }

    public void setFromList(ArrayList list) {
        this.m_Data = new DataTuple[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.m_Data[i] = (DataTuple)list.get(i);
        }
        this.setNbRows(list.size());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getNbRows(); ++i) {
            sb.append(prefix);
            sb.append(this.getTuple(i).toString() + "\n");
        }
        return sb.toString();
    }

    public String printIDs(String prefix) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < this.m_Schema.getKeyAttribute().length; ++j) {
            ClusAttrType key = this.m_Schema.getKeyAttribute()[j];
            sb.append(key.getName() + ": ");
            for (int i = 0; i < this.getNbRows(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(key.getString(this.getTuple(i)));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getSummary() {
        return this.getSummary("");
    }

    public String getSummary(String prefix) {
        int i;
        StringBuffer sb = new StringBuffer();
        DataTuple temp = this.getTuple(0);
        int nda = temp.getSchema().getNbNumericDescriptiveAttributes();
        double[] avg = new double[nda];
        double[] min = new double[nda];
        double[] max = new double[nda];
        double[] stddev = new double[nda];
        Arrays.fill(avg, 0.0);
        Arrays.fill(stddev, 0.0);
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        int nbrows = this.getNbRows();
        for (i = 0; i < nbrows; ++i) {
            temp = this.getTuple(i);
            ClusSchema schema = temp.getSchema();
            int j = 0;
            while (j < schema.getNbNumericDescriptiveAttributes()) {
                NumericAttrType type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive)[j];
                double tmpvalue = ((ClusAttrType)type).getNumeric(temp);
                if (tmpvalue > max[j]) {
                    max[j] = tmpvalue;
                }
                if (tmpvalue < min[j]) {
                    min[j] = tmpvalue;
                }
                int n = j;
                avg[n] = avg[n] + tmpvalue;
                int n2 = j++;
                stddev[n2] = stddev[n2] + tmpvalue * tmpvalue;
            }
        }
        for (i = 0; i < nda; ++i) {
            int n = i;
            avg[n] = avg[n] / (double)nbrows;
            stddev[i] = (stddev[i] - (double)nbrows * avg[i] * avg[i]) / (double)nbrows;
            stddev[i] = Math.sqrt(stddev[i]);
            min[i] = (double)Math.round(min[i] * 100.0) / 100.0;
            max[i] = (double)Math.round(max[i] * 100.0) / 100.0;
            avg[i] = (double)Math.round(avg[i] * 100.0) / 100.0;
            stddev[i] = (double)Math.round(stddev[i] * 100.0) / 100.0;
        }
        sb.append(prefix + "Min: " + Arrays.toString(min) + System.lineSeparator());
        sb.append(prefix + "Max: " + Arrays.toString(max) + System.lineSeparator());
        sb.append(prefix + "Avg: " + Arrays.toString(avg) + System.lineSeparator());
        sb.append(prefix + "StdDev: " + Arrays.toString(stddev) + System.lineSeparator());
        return sb.toString();
    }

    public JsonObject getSummaryJSON() {
        NumericAttrType type;
        int j;
        JsonObject summary = new JsonObject();
        DataTuple temp = null;
        try {
            temp = this.getTuple(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return summary;
        }
        int nda = temp.getSchema().getNbNumericDescriptiveAttributes();
        int nta = temp.getSchema().getNbNumericTargetAttributes();
        double[] avg = new double[nda + nta];
        double[] min = new double[nda + nta];
        double[] max = new double[nda + nta];
        double[] stddev = new double[nda + nta];
        int[] missing_values = new int[nda + nta];
        Arrays.fill(avg, 0.0);
        Arrays.fill(stddev, 0.0);
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        int nbrows = this.getNbRows();
        Arrays.fill(missing_values, 0);
        for (int i = 0; i < nbrows; ++i) {
            double tmpvalue;
            NumericAttrType type2;
            int j2;
            temp = this.getTuple(i);
            ClusSchema schema = temp.getSchema();
            for (j2 = 0; j2 < schema.getNbNumericDescriptiveAttributes(); ++j2) {
                type2 = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive)[j2];
                tmpvalue = ((ClusAttrType)type2).getNumeric(temp);
                if (tmpvalue != Double.POSITIVE_INFINITY) {
                    if (tmpvalue > max[j2]) {
                        max[j2] = tmpvalue;
                    }
                    if (tmpvalue < min[j2]) {
                        min[j2] = tmpvalue;
                    }
                    int n = j2;
                    avg[n] = avg[n] + tmpvalue;
                    int n2 = j2;
                    stddev[n2] = stddev[n2] + tmpvalue * tmpvalue;
                    continue;
                }
                int n = j2;
                missing_values[n] = missing_values[n] + 1;
            }
            for (j2 = nda; j2 < nda + nta; ++j2) {
                type2 = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[j2 - nda];
                tmpvalue = ((ClusAttrType)type2).getNumeric(temp);
                if (tmpvalue != Double.POSITIVE_INFINITY) {
                    if (tmpvalue > max[j2]) {
                        max[j2] = tmpvalue;
                    }
                    if (tmpvalue < min[j2]) {
                        min[j2] = tmpvalue;
                    }
                    int n = j2;
                    avg[n] = avg[n] + tmpvalue;
                    int n3 = j2;
                    stddev[n3] = stddev[n3] + tmpvalue * tmpvalue;
                    continue;
                }
                int n = j2;
                missing_values[n] = missing_values[n] + 1;
            }
        }
        JsonArray minArray = new JsonArray();
        JsonArray maxArray = new JsonArray();
        JsonArray avgArray = new JsonArray();
        JsonArray stddevArray = new JsonArray();
        for (int i = 0; i < nda + nta; ++i) {
            int n = i;
            avg[n] = avg[n] / (double)(nbrows - missing_values[i]);
            stddev[i] = (stddev[i] - (double)(nbrows - missing_values[i]) * avg[i] * avg[i]) / (double)(nbrows - missing_values[i]);
            stddev[i] = Math.sqrt(stddev[i]);
            min[i] = (double)Math.round(min[i] * 100.0) / 100.0;
            max[i] = (double)Math.round(max[i] * 100.0) / 100.0;
            avg[i] = (double)Math.round(avg[i] * 100.0) / 100.0;
            stddev[i] = (double)Math.round(stddev[i] * 100.0) / 100.0;
            avgArray.add(avg[i]);
            maxArray.add(max[i]);
            minArray.add(min[i]);
            stddevArray.add(stddev[i]);
        }
        JsonArray namesArray = new JsonArray();
        ClusSchema schema = temp.getSchema();
        for (j = 0; j < schema.getNbNumericDescriptiveAttributes(); ++j) {
            type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive)[j];
            namesArray.add(type.getName());
        }
        for (j = nda; j < nda + nta; ++j) {
            type = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target)[j - nda];
            namesArray.add(type.getName());
        }
        summary.add("min", minArray);
        summary.add("max", maxArray);
        summary.add("avg", avgArray);
        summary.add("stddev", stddevArray);
        summary.add("names", namesArray);
        return summary;
    }

    public ArrayList<DataTuple> toArrayList() {
        ArrayList<DataTuple> array = new ArrayList<DataTuple>();
        this.addTo(array);
        return array;
    }

    public void addTo(ArrayList<DataTuple> array) {
        for (int i = 0; i < this.getNbRows(); ++i) {
            array.add(this.getTuple(i));
        }
    }

    public DataTuple createTuple() {
        return new DataTuple(this.m_Schema);
    }

    public static RowData readData(String fname, ClusSchema schema) throws ClusException, IOException {
        schema.addIndices(0);
        ClusReader reader = new ClusReader(fname, schema.getSettings());
        RowData data = schema.createNormalView().readData(reader, schema);
        reader.close();
        return data;
    }

    @Override
    public ClusData cloneData() {
        RowData res = new RowData(this.m_Schema, this.m_NbRows);
        System.arraycopy(this.m_Data, 0, res.m_Data, 0, this.m_NbRows);
        return res;
    }

    public RowData shallowCloneData() {
        RowData res = new RowData(this.m_Schema, this.m_NbRows);
        for (int i = 0; i < this.m_NbRows; ++i) {
            res.setTuple(this.m_Data[i].cloneTuple(), i);
        }
        return res;
    }

    public RowData deepCloneData() {
        RowData res = new RowData(this.m_Schema, this.m_NbRows);
        for (int i = 0; i < this.m_NbRows; ++i) {
            res.setTuple(this.m_Data[i].deepCloneTuple(), i);
        }
        return res;
    }

    public final ClusSchema getSchema() {
        return this.m_Schema;
    }

    public void setSchema(ClusSchema schema) {
        this.m_Schema = schema;
    }

    public void sortSparse(NumericAttrType at, RowDataSortHelper helper) throws ClusException {
        int i;
        int nbmiss = 0;
        int nbzero = 0;
        int nbother = 0;
        helper.resize(this.m_NbRows + 1);
        DataTuple[] missing = helper.missing;
        DataTuple[] zero = helper.zero;
        DoubleObject[] other = helper.other;
        for (int i2 = 0; i2 < this.m_NbRows; ++i2) {
            double data = at.getNumeric(this.m_Data[i2]);
            if (data == 0.0) {
                zero[nbzero++] = this.m_Data[i2];
                continue;
            }
            if (data == Double.POSITIVE_INFINITY) {
                missing[nbmiss++] = this.m_Data[i2];
                continue;
            }
            if (data > 0.0) {
                other[nbother++].set(data, this.m_Data[i2]);
                continue;
            }
            throw new ClusException("Sparse attribute has negative value!");
        }
        MSorter.quickSort(helper, 0, nbother);
        int pos = 0;
        for (i = 0; i < nbmiss; ++i) {
            this.m_Data[pos++] = missing[i];
        }
        for (i = 0; i < nbother; ++i) {
            this.m_Data[pos++] = (DataTuple)other[i].getObject();
        }
        for (i = 0; i < nbzero; ++i) {
            this.m_Data[pos++] = zero[i];
        }
    }

    public void sort(NumericAttrType at) {
        this.m_Index = at.getArrayIndex();
        MSorter.quickSort(this, 0, this.m_NbRows);
    }

    public void sortLabeledFirst() {
        for (int i = 0; i < this.m_Data.length; ++i) {
            if (!this.m_Data[i].isUnlabeled()) continue;
            boolean swapPerformed = false;
            for (int j = i + 1; j < this.m_Data.length; ++j) {
                if (this.m_Data[j].isUnlabeled()) continue;
                this.swap(i, j);
                swapPerformed = true;
                break;
            }
            if (swapPerformed) continue;
            return;
        }
    }

    @Override
    public double getDouble(int i) {
        return this.m_Data[i].getDoubleVal(this.m_Index);
    }

    public boolean compare(int i, int j) {
        return this.m_Data[i].getDoubleVal(this.m_Index) < this.m_Data[j].getDoubleVal(this.m_Index);
    }

    @Override
    public void swap(int i, int j) {
        DataTuple temp = this.m_Data[i];
        this.m_Data[i] = this.m_Data[j];
        this.m_Data[j] = temp;
    }

    public Integer[] smartSort(NumericAttrType at) {
        if (this.m_SortedInstances.containsKey(at) && this.m_SortedInstances.get(at).length == this.m_Data.length) {
            return this.m_SortedInstances.get(at);
        }
        if (at.isSparse()) {
            return this.smartSortSparse(at);
        }
        return this.smartSortNonSparse(at);
    }

    public Integer[] smartSortNonSparse(NumericAttrType at) {
        int attrInd = at.getArrayIndex();
        Integer[] indices = new Integer[this.m_Data.length];
        final double[] featureVector = new double[this.m_Data.length];
        for (int i = 0; i < this.m_Data.length; ++i) {
            indices[i] = i;
            featureVector[i] = this.m_Data[i].getDoubleVal(attrInd);
        }
        Arrays.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(featureVector[o2], featureVector[o1]);
            }
        });
        this.m_SortedInstances.put(at, indices);
        return indices;
    }

    public Integer[] smartSortSparse(NumericAttrType at) {
        int i;
        ArrayList<Integer> missing = new ArrayList<Integer>();
        ArrayList<Integer> zero = new ArrayList<Integer>();
        ArrayList<Integer> other = new ArrayList<Integer>();
        int nbPos = 0;
        for (int i2 = 0; i2 < this.m_NbRows; ++i2) {
            double featureValue = at.getNumeric(this.m_Data[i2]);
            if (featureValue == 0.0) {
                zero.add(i2);
                continue;
            }
            if (featureValue == Double.POSITIVE_INFINITY) {
                missing.add(i2);
                continue;
            }
            if (featureValue > 0.0) {
                ++nbPos;
            }
            other.add(i2);
        }
        final double[] featureVector = new double[other.size()];
        Integer[] temp = new Integer[other.size()];
        for (int i3 = 0; i3 < featureVector.length; ++i3) {
            featureVector[i3] = at.getNumeric(this.m_Data[(Integer)other.get(i3)]);
            temp[i3] = i3;
        }
        Arrays.sort(temp, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(featureVector[o2], featureVector[o1]);
            }
        });
        Integer[] indices = new Integer[this.m_Data.length];
        int nbMiss = missing.size();
        int nbOther = other.size();
        int nbZero = zero.size();
        int position = 0;
        for (i = 0; i < nbMiss; ++i) {
            indices[position++] = (Integer)missing.get(i);
        }
        for (i = 0; i < nbPos; ++i) {
            indices[position++] = (Integer)other.get(temp[i]);
        }
        for (i = 0; i < nbZero; ++i) {
            indices[position++] = (Integer)zero.get(i);
        }
        for (i = nbPos; i < nbOther; ++i) {
            indices[position++] = (Integer)other.get(temp[i]);
        }
        this.m_SortedInstances.put(at, indices);
        return indices;
    }

    public DataTuple findTupleByKey(String key_value) {
        ClusAttrType[] key = this.getSchema().getAllAttrUse(ClusAttrType.AttributeUseType.Key);
        if (key.length > 0) {
            ClusAttrType key_attr = key[0];
            for (int i = 0; i < this.getNbRows(); ++i) {
                DataTuple tuple = this.getTuple(i);
                if (!key_attr.getString(tuple).equals(key_value)) continue;
                return tuple;
            }
        }
        return null;
    }

    @Override
    public ClusData selectFrom(ClusSelection sel, ClusRandomNonstatic rnd) {
        int nbsel = sel.getNbSelected();
        RowData res = new RowData(this.m_Schema, nbsel);
        if (sel.supportsReplacement()) {
            for (int i = 0; i < nbsel; ++i) {
                res.setTuple(this.m_Data[sel.getIndex(rnd)], i);
            }
        } else {
            int s_subset = 0;
            for (int i = 0; i < this.m_NbRows; ++i) {
                if (!sel.isSelected(i)) continue;
                res.setTuple(this.m_Data[i], s_subset++);
            }
        }
        return res;
    }

    @Override
    public ClusData select(ClusSelection sel) {
        int s_data = 0;
        int s_subset = 0;
        DataTuple[] old = this.m_Data;
        int nbsel = sel.getNbSelected();
        this.m_Data = new DataTuple[this.m_NbRows - nbsel];
        RowData res = new RowData(this.m_Schema, nbsel);
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (sel.isSelected(i)) {
                res.setTuple(old[i], s_subset++);
                continue;
            }
            this.setTuple(old[i], s_data++);
        }
        this.m_NbRows -= nbsel;
        return res;
    }

    public void update(ClusSelection sel) {
        int s_data = 0;
        DataTuple[] old = this.m_Data;
        int nbsel = sel.getNbSelected();
        this.m_Data = new DataTuple[nbsel];
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (!sel.isSelected(i)) continue;
            DataTuple nt = old[i].multiplyWeight(sel.getWeight(i));
            this.setTuple(nt, s_data++);
        }
        this.m_NbRows = nbsel;
    }

    public final double getSumWeights() {
        double sum = 0.0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            sum += this.m_Data[i].getWeight();
        }
        return sum;
    }

    public final boolean containsFold(DataTuple tuple, int[] folds) {
        for (int i = 0; i < folds.length; ++i) {
            if (tuple.m_Folds[folds[i]] <= 0) continue;
            return true;
        }
        return false;
    }

    public final void optimize2(int[] folds) {
        int nbsel = 0;
        int s_data = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (!this.containsFold(this.m_Data[i], folds)) continue;
            ++nbsel;
        }
        DataTuple[] old = this.m_Data;
        this.m_Data = new DataTuple[nbsel];
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (!this.containsFold(old[i], folds)) continue;
            this.setTuple(old[i], s_data++);
        }
        this.m_NbRows = nbsel;
    }

    @Override
    public void insert(ClusData data, ClusSelection sel) {
        int s_data = 0;
        int s_subset = 0;
        DataTuple[] old = this.m_Data;
        RowData other = (RowData)data;
        this.resizeEmpty(this.m_NbRows + sel.getNbSelected());
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (sel.isSelected(i)) {
                this.setTuple(other.getTuple(s_subset++), i);
                continue;
            }
            this.setTuple(old[s_data++], i);
        }
    }

    public final RowData getFoldData(int fold) {
        int idx = 0;
        int nbsel = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (this.m_Data[i].getIndex() == fold) continue;
            ++nbsel;
        }
        RowData res = new RowData(this.m_Schema, nbsel);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            if (tuple.getIndex() == fold) continue;
            res.setTuple(tuple, idx++);
        }
        return res;
    }

    public final RowData getFoldData2(int fold) {
        int idx = 0;
        int nbsel = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (this.m_Data[i].m_Folds[fold] == 0) continue;
            ++nbsel;
        }
        RowData res = new RowData(this.m_Schema, nbsel);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            int factor = this.m_Data[i].m_Folds[fold];
            if (factor == 0) continue;
            DataTuple t2 = factor == 1 ? tuple : tuple.changeWeight(tuple.getWeight() * (double)factor);
            res.setTuple(t2, idx++);
        }
        return res;
    }

    public final RowData getOVFoldData(int fold) {
        int idx = 0;
        int nbsel = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            int efold = this.m_Data[i].m_Index;
            if (efold != -1) {
                if (efold == fold) continue;
                ++nbsel;
                continue;
            }
            if (Arrays.binarySearch(this.m_Data[i].m_Folds, fold) < 0) continue;
            ++nbsel;
        }
        RowData res = new RowData(this.m_Schema, nbsel);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            int efold = tuple.m_Index;
            if (efold != -1) {
                if (efold == fold) continue;
                res.setTuple(tuple, idx++);
                continue;
            }
            if (Arrays.binarySearch(this.m_Data[i].m_Folds, fold) < 0) continue;
            res.setTuple(tuple, idx++);
        }
        return res;
    }

    public void checkData(boolean isForTest) {
        boolean[] denseAndSparse = new boolean[2];
        int indDense = 0;
        int indSparse = 1;
        for (DataTuple tuple : this.m_Data) {
            int ind = tuple.isSparse() ? indSparse : indDense;
            denseAndSparse[ind] = true;
            if (!denseAndSparse[1 - ind]) continue;
            throw new RuntimeException("Dense and Sparse tuples present in the data.");
        }
        if (denseAndSparse[indSparse]) {
            for (DataTuple tuple : this.m_Data) {
                for (int val : tuple.getInts()) {
                    if (val != -123) continue;
                    throw new RuntimeException("Not all nominal attributes specified in sparse data.");
                }
            }
        }
        if (!isForTest && denseAndSparse[indSparse]) {
            for (DataTuple tuple : this.m_Data) {
                SparseDataTuple sdt = (SparseDataTuple)tuple;
                for (Integer i : sdt.getAttributeIndices()) {
                    if (!(sdt.getDoubleValueSparse(i) < 0.0)) continue;
                    throw new RuntimeException("Sparse attribute with negative value!");
                }
            }
        }
    }

    public final boolean isSparse() {
        if (this.m_Data.length > 0) {
            return this.m_Data[0].isSparse();
        }
        throw new RuntimeException("The dataset is empty, thus sparse and dense at the same time.");
    }

    public final DataTuple getTuple(int i) {
        return this.m_Data[i];
    }

    public final void setTuple(DataTuple tuple, int i) {
        this.m_Data[i] = tuple;
    }

    public final int getNbUnlabeled() {
        int nbUnlabeled = 0;
        for (int i = 0; i < this.m_Data.length; ++i) {
            if (!this.m_Data[i].isUnlabeled()) continue;
            ++nbUnlabeled;
        }
        return nbUnlabeled;
    }

    public HashMap<Integer, ArrayList<Integer>> getMissingTargets() {
        HashMap<Integer, ArrayList<Integer>> missing = new HashMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < this.m_Data.length; ++i) {
            ArrayList<Integer> missingTargets = this.m_Data[i].getMissingTargets();
            if (missingTargets.size() <= 0) continue;
            missing.put(i, missingTargets);
        }
        return missing;
    }

    public final RowData applyWeighted(NodeTest test, int branch) {
        int nb = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            int pred = test.predictWeighted(this.m_Data[i]);
            if (pred != branch && pred != -1) continue;
            ++nb;
        }
        int idx = 0;
        RowData res = new RowData(this.m_Schema, nb);
        double prop = test.getProportion(branch);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            int pred = test.predictWeighted(tuple);
            if (pred == branch) {
                res.setTuple(tuple, idx++);
                continue;
            }
            if (pred != -1) continue;
            DataTuple ntuple = tuple.multiplyWeight(prop);
            res.setTuple(ntuple, idx++);
        }
        return res;
    }

    public final RowData applyAllAlternativeTests(NodeTest orig, NodeTest[] tests, NodeTest[] opposites, int branch) {
        ArrayList<DataTuple> al = new ArrayList<DataTuple>();
        for (int i = 0; i < this.m_NbRows; ++i) {
            int t;
            int pred;
            int[] counts = new int[2];
            int n = pred = orig.predictWeighted(this.m_Data[i]);
            counts[n] = counts[n] + 1;
            for (t = 0; t < tests.length; ++t) {
                int n2 = pred = tests[t].predictWeighted(this.m_Data[i]);
                counts[n2] = counts[n2] + 1;
            }
            for (t = 0; t < opposites.length; ++t) {
                pred = opposites[t].predictWeighted(this.m_Data[i]);
                int n3 = (pred + 1) % 2;
                counts[n3] = counts[n3] + 1;
            }
            int totalcounts = counts[0] + counts[1];
            int finalpred = (double)counts[0] >= 0.5 * (double)totalcounts ? 0 : 1;
            if (finalpred != branch) continue;
            al.add(this.m_Data[i]);
        }
        RowData res = new RowData(al, this.m_Schema);
        return res;
    }

    public final RowData apply(NodeTest test, int branch) {
        int nb = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            int pred = test.predictWeighted(this.m_Data[i]);
            if (pred != branch) continue;
            ++nb;
        }
        int idx = 0;
        RowData res = new RowData(this.m_Schema, nb);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            int pred = test.predictWeighted(tuple);
            if (pred != branch) continue;
            res.setTuple(tuple, idx++);
        }
        return res;
    }

    public final RowData applyConstraint(ClusRuleConstraintInduceTest test, int branch) {
        boolean order = test.isSmallerThanTest();
        if (order) {
            return this.applyConstraintTrue(test, branch);
        }
        return this.applyConstraintFalse(test, branch);
    }

    private RowData applyConstraintTrue(ClusRuleConstraintInduceTest test, int branch) {
        int nb = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            int pred = test.predictWeighted(this.m_Data[i]);
            if (pred == branch) continue;
            ++nb;
        }
        int idx = 0;
        RowData res = new RowData(this.m_Schema, nb);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            int pred = test.predictWeighted(tuple);
            if (pred == branch) continue;
            res.setTuple(tuple, idx++);
        }
        return res;
    }

    private RowData applyConstraintFalse(ClusRuleConstraintInduceTest test, int branch) {
        int nb = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            int pred = test.predictWeighted(this.m_Data[i]);
            if (pred != branch) continue;
            ++nb;
        }
        int idx = 0;
        RowData res = new RowData(this.m_Schema, nb);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            int pred = test.predictWeighted(tuple);
            if (pred != branch) continue;
            res.setTuple(tuple, idx++);
        }
        return res;
    }

    public final RowData applySoft(SoftTest test, int branch) {
        int nb = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            nb += test.softPredictNb(this.m_Data[i], branch);
        }
        int idx = 0;
        RowData res = new RowData(this.m_Schema, nb);
        for (int i = 0; i < this.m_NbRows; ++i) {
            idx = test.softPredict(res, this.m_Data[i], idx, branch);
        }
        return res;
    }

    public final RowData applySoft2(SoftTest test, int branch) {
        int nb = 0;
        for (int i = 0; i < this.m_NbRows; ++i) {
            nb += test.softPredictNb2(this.m_Data[i], branch);
        }
        int idx = 0;
        RowData res = new RowData(this.m_Schema, nb);
        for (int i = 0; i < this.m_NbRows; ++i) {
            idx = test.softPredict2(res, this.m_Data[i], idx, branch);
        }
        return res;
    }

    @Override
    public void resize(int nbrows) {
        this.m_Data = new DataTuple[nbrows];
        for (int i = 0; i < nbrows; ++i) {
            this.m_Data[i] = new DataTuple(this.m_Schema);
        }
        this.m_NbRows = nbrows;
    }

    public void resizeEmpty(int nbrows) {
        this.m_Data = new DataTuple[nbrows];
        this.m_NbRows = nbrows;
    }

    public void showDebug(ClusSchema schema) {
        ClusLogger.info("Data: " + this.m_NbRows + " Size: " + this.m_Data.length);
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.getTuple(i);
            if (tuple == null) {
                ClusLogger.info("? ");
                continue;
            }
            ClusAttrType at = schema.getAttrType(0);
            ClusLogger.info(at.getString(tuple));
        }
        ClusLogger.info();
    }

    @Override
    public void attach(ClusNode node) {
    }

    public synchronized void calcTotalStatBitVector(ClusStatistic stat) throws ClusException {
        stat.setSDataSize(this.getNbRows());
        this.calcTotalStat(stat);
        stat.optimizePreCalc(this);
    }

    @Override
    public void calcTotalStat(ClusStatistic stat) {
        for (int i = 0; i < this.m_NbRows; ++i) {
            stat.updateWeighted(this.m_Data[i], i);
        }
    }

    public final void calcPosAndMissStat(NodeTest test, int branch, ClusStatistic pos, ClusStatistic miss) {
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            int pred = test.predictWeighted(tuple);
            if (pred == branch) {
                pos.updateWeighted(this.m_Data[i], i);
                continue;
            }
            if (pred != -1) continue;
            miss.updateWeighted(this.m_Data[i], i);
        }
    }

    public final boolean isSoft() {
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            if (tuple.m_Index != -1) continue;
            return true;
        }
        return false;
    }

    public final void calcXValTotalStat(ClusStatistic[] tot) {
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            tot[tuple.getIndex()].updateWeighted(tuple, i);
        }
    }

    public final void calcXValTotalStat(ClusStatistic[] tot, ClusStatistic[] extra) {
        int i;
        for (i = 0; i < extra.length; ++i) {
            extra[i].reset();
        }
        for (i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            if (tuple.m_Index != -1) {
                tot[tuple.m_Index].updateWeighted(tuple, i);
                continue;
            }
            int[] folds = tuple.m_Folds;
            for (int j = 0; j < folds.length; ++j) {
                extra[folds[j]].updateWeighted(tuple, i);
            }
        }
    }

    @Override
    public void calcError(ClusNode node, ClusErrorList par) throws ClusException {
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.getTuple(i);
            ClusStatistic stat = node.predictWeighted(tuple);
            par.addExample(tuple, stat);
        }
    }

    @Override
    public void preprocess(int pass, DataPreprocs pps) throws ClusException {
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data[i];
            pps.preproc(pass, tuple);
        }
    }

    public final void showTable() {
        int i;
        for (i = 0; i < this.m_Schema.getNbAttributes(); ++i) {
            ClusAttrType type = this.m_Schema.getAttrType(i);
            if (i != 0) {
                System.out.print(",");
            }
            System.out.print(type.getName());
        }
        ClusLogger.info();
        for (i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.getTuple(i);
            for (int j = 0; j < this.m_Schema.getNbAttributes(); ++j) {
                ClusAttrType type = this.m_Schema.getAttrType(j);
                if (j != 0) {
                    System.out.print(",");
                }
                System.out.print(type.getString(tuple));
            }
            ClusLogger.info();
        }
    }

    @Override
    public double[] getNumeric(int idx) {
        return this.m_Data[idx].m_Doubles;
    }

    @Override
    public int[] getNominal(int idx) {
        return this.m_Data[idx].m_Ints;
    }

    public MemoryTupleIterator getIterator() {
        return new MemoryTupleIterator(this);
    }

    public synchronized void addIndices() {
        for (int i = 0; i < this.m_NbRows; ++i) {
            this.m_Data[i].setIndex(i);
        }
    }

    public boolean equals(RowData d) {
        if (d.getNbRows() != this.getNbRows()) {
            return false;
        }
        if (!this.m_Schema.equals(this.m_Schema)) {
            return false;
        }
        for (int i = 0; i < this.getNbRows(); ++i) {
            if (d.getTuple(i).equals(this.getTuple(i))) continue;
            return false;
        }
        return false;
    }

    public void add(DataTuple tuple) {
        this.setNbRows(this.getNbRows() + 1);
        DataTuple[] newdata = this.m_Data != null ? Arrays.copyOf(this.m_Data, this.getNbRows()) : new DataTuple[this.getNbRows()];
        newdata[this.getNbRows() - 1] = tuple.cloneTuple();
        this.m_Data = newdata;
    }

    public void addAll(RowData data1, RowData data2) {
        int i;
        int size = data1.getNbRows() + data2.getNbRows();
        this.setNbRows(size);
        this.m_Data = new DataTuple[size];
        for (i = 0; i < data1.getNbRows(); ++i) {
            this.m_Data[i] = data1.getTuple(i).cloneTuple();
        }
        for (i = 0; i < data2.getNbRows(); ++i) {
            data2.getTuple(i).cloneTuple();
            this.m_Data[i + data1.getNbRows()] = data2.getTuple(i).cloneTuple();
        }
    }

    public void add(RowData data1) {
        int i;
        DataTuple[] oldData = this.m_Data;
        int size = this.getNbRows() + data1.getNbRows();
        this.setNbRows(size);
        this.m_Data = new DataTuple[size];
        for (i = 0; i < oldData.length; ++i) {
            this.m_Data[i] = oldData[i].cloneTuple();
        }
        for (i = 0; i < data1.getNbRows(); ++i) {
            data1.getTuple(i).cloneTuple();
            this.m_Data[i + oldData.length] = data1.getTuple(i).cloneTuple();
        }
    }

    public RowData sample(int N, ClusRandomNonstatic rnd) {
        if (N < 0) {
            throw new IllegalArgumentException("N should be larger than or equal to zero");
        }
        int nbRows = this.getNbRows();
        if (N == 0) {
            return new RowData(this);
        }
        ArrayList<DataTuple> res = new ArrayList<DataTuple>();
        if (rnd == null) {
            ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.StaticRandom);
            for (int size = 0; size < N; ++size) {
                int i = ClusRandom.nextInt(6, nbRows);
                res.add(this.getTuple(i));
            }
        } else {
            for (int size = 0; size < N; ++size) {
                int i = rnd.nextInt(1, nbRows);
                res.add(this.getTuple(i));
            }
        }
        return new RowData(res, this.getSchema().cloneSchema());
    }

    public RowData sampleWeighted(Random random) {
        return this.sampleWeighted(random, this.getNbRows());
    }

    public RowData sampleWeighted(Random random, int N) {
        double[] weight_acc = new double[this.getNbRows()];
        weight_acc[0] = this.getTuple(0).getWeight();
        for (int i = 1; i < this.getNbRows(); ++i) {
            DataTuple tuple = this.getTuple(i);
            weight_acc[i] = weight_acc[i - 1] + tuple.getWeight();
        }
        double tot_w = weight_acc[this.getNbRows() - 1];
        ArrayList<DataTuple> res = new ArrayList<DataTuple>();
        for (int i = 0; i < N; ++i) {
            double rnd = random.nextDouble() * tot_w;
            int loc = Arrays.binarySearch(weight_acc, rnd);
            if (loc < 0) {
                loc = -loc - 1;
            }
            DataTuple restuple = this.getTuple(loc).changeWeight(1.0);
            res.add(restuple);
        }
        return new RowData(res, this.getSchema());
    }
}

