/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.rows;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;

public class DataTuple
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected ClusSchema m_Schema;
    protected int[] m_Ints;
    public static final int DUMMY_INT = -123;
    protected double[] m_Doubles;
    protected Object[] m_Objects;
    public double m_Weight;
    public int m_Index;
    private int m_DatasetIndex = -1;
    private boolean m_IsTrain = false;
    private boolean m_IsTest = false;
    public int[] m_Folds;

    protected DataTuple() {
    }

    public DataTuple(ClusSchema schema) {
        int nb_obj;
        int nb_double;
        int nb_int = schema.getNbInts();
        if (nb_int > 0) {
            this.m_Ints = new int[nb_int];
            Arrays.fill(this.m_Ints, -123);
        }
        if ((nb_double = schema.getNbDoubles()) > 0) {
            this.m_Doubles = new double[nb_double];
        }
        if ((nb_obj = schema.getNbObjects()) > 0) {
            this.m_Objects = new Object[nb_obj];
        }
        this.m_Weight = 1.0;
        this.m_Schema = schema;
    }

    public DataTuple cloneTuple() {
        DataTuple res = new DataTuple();
        this.cloneTuple(res);
        return res;
    }

    public void cloneTuple(DataTuple res) {
        res.m_Ints = this.m_Ints;
        res.m_Doubles = this.m_Doubles;
        res.m_Objects = this.m_Objects;
        res.m_Weight = this.m_Weight;
        res.m_Index = this.m_Index;
        res.m_Folds = this.m_Folds;
        res.m_Schema = this.m_Schema;
        res.m_DatasetIndex = this.m_DatasetIndex;
        res.m_IsTrain = this.m_IsTrain;
        res.m_IsTest = this.m_IsTest;
    }

    public double euclDistance(DataTuple other) {
        double result = 0.0;
        for (int i = 0; i < this.m_Doubles.length; ++i) {
            double t = this.getDoubleVal(i) - other.getDoubleVal(i);
            t *= t;
            result += t;
        }
        return Math.sqrt(result);
    }

    public DataTuple deepCloneTuple() {
        DataTuple res = new DataTuple();
        if (this.m_Ints != null) {
            res.m_Ints = new int[this.m_Ints.length];
            System.arraycopy(this.m_Ints, 0, res.m_Ints, 0, this.m_Ints.length);
        }
        if (this.m_Doubles != null) {
            res.m_Doubles = new double[this.m_Doubles.length];
            System.arraycopy(this.m_Doubles, 0, res.m_Doubles, 0, this.m_Doubles.length);
        }
        if (this.m_Objects != null) {
            res.m_Objects = new Object[this.m_Objects.length];
            System.arraycopy(this.m_Objects, 0, res.m_Objects, 0, this.m_Objects.length);
        }
        res.m_Weight = this.m_Weight;
        res.m_Index = this.m_Index;
        res.m_Folds = this.m_Folds;
        res.m_Schema = this.m_Schema;
        return res;
    }

    public final DataTuple changeWeight(double weight) {
        DataTuple res = this.cloneTuple();
        res.m_Weight = weight;
        return res;
    }

    public final DataTuple multiplyWeight(double factor) {
        DataTuple res = this.cloneTuple();
        res.m_Weight = this.m_Weight * factor;
        return res;
    }

    public final int getClassification() {
        throw new RuntimeException("Should not be used");
    }

    public final int getNbMissingTargets() {
        ClusAttrType[] targets = this.m_Schema.getTargetAttributes();
        int missingNb = 0;
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].isMissing(this)) continue;
            ++missingNb;
        }
        return missingNb;
    }

    public final ArrayList<Integer> getMissingTargets() {
        ClusAttrType[] targets = this.m_Schema.getTargetAttributes();
        ArrayList<Integer> missing = new ArrayList<Integer>();
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].isMissing(this)) continue;
            missing.add(i);
        }
        return missing;
    }

    public final boolean isUnlabeled() {
        return this.getNbMissingTargets() == this.m_Schema.getTargetAttributes().length;
    }

    public final void makeUnlabeled() {
        ClusAttrType[] targets = this.m_Schema.getTargetAttributes();
        for (int i = 0; i < targets.length; ++i) {
            targets[i].setToMissing(this);
        }
    }

    public final boolean isPartiallyLabeled() {
        return this.getNbMissingTargets() > 0;
    }

    public final boolean hasNumMissing(int idx) {
        return this.m_Doubles[idx] == Double.POSITIVE_INFINITY;
    }

    public final int[] getInts() {
        return this.m_Ints == null ? new int[]{} : this.m_Ints;
    }

    public final double[] getDoubles() {
        return this.m_Doubles == null ? new double[]{} : this.m_Doubles;
    }

    public final Object[] getObjects() {
        return this.m_Objects == null ? new Object[]{} : this.m_Objects;
    }

    public final ClusSchema getSchema() {
        return this.m_Schema;
    }

    public final double getDoubleVal(int idx) {
        return this.m_Doubles[idx];
    }

    public final int getIntVal(int idx) {
        return this.m_Ints[idx];
    }

    public final Object getObjVal(int idx) {
        return this.m_Objects[idx];
    }

    public final void setIntVal(int value, int idx) {
        this.m_Ints[idx] = value;
    }

    public final void setDoubleVal(double value, int idx) {
        this.m_Doubles[idx] = value;
    }

    public final void setObjectVal(Object value, int idx) {
        this.m_Objects[idx] = value;
    }

    public final void setIndex(int idx) {
        this.m_Index = idx;
    }

    public final int getIndex() {
        return this.m_Index;
    }

    public final void setDatasetIndex(int idx) {
        this.m_DatasetIndex = idx;
    }

    public final int getDatasetIndex() {
        return this.m_DatasetIndex;
    }

    public final boolean isTraining() {
        return this.m_IsTrain;
    }

    public final boolean isTesting() {
        return this.m_IsTest;
    }

    public final void setTraining(boolean value) {
        this.m_IsTrain = value;
    }

    public final void setTesting(boolean value) {
        this.m_IsTest = value;
    }

    public final double getWeight() {
        return this.m_Weight;
    }

    public final void setWeight(double weight) {
        this.m_Weight = weight;
    }

    public final void setSchema(ClusSchema schema) {
        this.m_Schema = schema;
    }

    public void writeTuple(PrintWriter wrt) {
        int aidx = 0;
        ClusSchema schema = this.getSchema();
        for (int i = 0; i < schema.getNbAttributes(); ++i) {
            ClusAttrType type = schema.getAttrType(i);
            if (type.isDisabled()) continue;
            if (aidx != 0) {
                wrt.print(",");
            }
            wrt.print(type.getString(this));
            ++aidx;
        }
        wrt.println();
    }

    public void writeDescriptive(PrintWriter wrt) {
        int aidx = 0;
        ClusSchema schema = this.getSchema();
        for (int i = 0; i < schema.getNbAttributes(); ++i) {
            ClusAttrType type = schema.getAttrType(i);
            if (type.isDisabled() || !type.isDescriptive()) continue;
            if (aidx != 0) {
                wrt.print(",");
            }
            wrt.print(type.getString(this));
            ++aidx;
        }
        wrt.println();
    }

    public void writeTarget(PrintWriter wrt) {
        int aidx = 0;
        ClusSchema schema = this.getSchema();
        for (int i = 0; i < schema.getNbAttributes(); ++i) {
            ClusAttrType type = schema.getAttrType(i);
            if (type.isDisabled() || !type.isTarget()) continue;
            if (aidx != 0) {
                wrt.print(",");
            }
            wrt.print(type.getString(this));
            ++aidx;
        }
        wrt.println();
    }

    public String toString() {
        int aidx = 0;
        StringBuffer buf = new StringBuffer();
        ClusSchema schema = this.getSchema();
        if (schema != null) {
            for (int i = 0; i < schema.getNbAttributes(); ++i) {
                ClusAttrType type = schema.getAttrType(i);
                if (type.isDisabled()) continue;
                if (aidx != 0) {
                    buf.append(",");
                }
                buf.append(type.getString(this));
                ++aidx;
            }
        } else {
            for (int i = 0; i < this.m_Objects.length; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(this.m_Objects[i].toString());
            }
        }
        return buf.toString();
    }

    public boolean isSparse() {
        return false;
    }
}

