/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.cols.attribute;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.cols.attribute.ClusAttribute;
import si.ijs.kt.clus.data.cols.attribute.NumericAttrBase;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.selection.ClusSelection;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.jeans.util.sort.DoubleIndexSorter;

public class NumericAttribute
extends NumericAttrBase {
    public int DEBUG = 0;
    public double[] m_Data;
    public int[] m_Index;
    protected int m_NbRows;

    public NumericAttribute(NumericAttrType type) {
        super(type);
    }

    @Override
    public void resize(int rows) {
        this.m_NbRows = rows;
        this.m_Data = new double[rows];
    }

    @Override
    public ClusAttribute select(ClusSelection sel, int nbsel) {
        int s_data = 0;
        int s_subset = 0;
        double[] data = this.m_Data;
        this.m_Data = new double[this.m_NbRows - nbsel];
        double[] subset = new double[nbsel];
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (sel.isSelected(i)) {
                subset[s_subset++] = data[i];
                continue;
            }
            this.m_Data[s_data++] = data[i];
        }
        this.m_NbRows -= nbsel;
        NumericAttribute s_attr = new NumericAttribute(this.m_Type);
        s_attr.m_Data = subset;
        s_attr.m_NbRows = nbsel;
        return s_attr;
    }

    @Override
    public void insert(ClusAttribute attr, ClusSelection sel, int nb_new) {
        int s_data = 0;
        int s_subset = 0;
        double[] data = this.m_Data;
        this.m_Data = new double[nb_new];
        double[] subset = ((NumericAttribute)attr).m_Data;
        for (int i = 0; i < nb_new; ++i) {
            this.m_Data[i] = sel.isSelected(i) ? subset[s_subset++] : data[s_data++];
        }
        this.m_NbRows = nb_new;
    }

    @Override
    public void prepare() {
        DoubleIndexSorter sorter = DoubleIndexSorter.getInstance();
        sorter.setData(this.m_Data);
        sorter.sort();
        this.m_Index = sorter.getIndex();
        if (this.DEBUG == 1) {
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream("debug/attr-" + this.getName())));
                for (int i = 0; i < this.m_Data.length; ++i) {
                    writer.println(this.m_Data[i] + "\t" + this.m_Index[i]);
                }
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void unprepare() {
        this.m_Data = DoubleIndexSorter.unsort(this.m_Data, this.m_Index);
        this.m_Index = null;
    }

    @Override
    public void findBestTest(MyArray leaves, ColTarget target, ClusStatManager smanager) {
        int i;
        int nb = leaves.size();
        for (int i2 = 0; i2 < nb; ++i2) {
        }
        if (this.m_Type.hasMissing()) {
            for (int first = 0; first < this.m_NbRows && this.m_Data[first] == Double.POSITIVE_INFINITY; ++first) {
            }
            for (i = 0; i < nb; ++i) {
            }
        } else {
            for (i = 0; i < nb; ++i) {
            }
        }
        for (i = first; i < this.m_NbRows; ++i) {
        }
    }

    @Override
    public void split(ColTarget target) {
        for (int i = 0; i < this.m_NbRows; ++i) {
        }
    }

    public boolean read(ClusReader data, int row) throws IOException {
        if (!data.readNoSpace()) {
            return false;
        }
        this.m_Data[row] = data.getFloat();
        double val = this.m_Data[row];
        if (val == Double.POSITIVE_INFINITY) {
            this.m_Type.incNbMissing();
        }
        return true;
    }
}

