/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.cols.attribute;

import java.io.IOException;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.cols.attribute.ClusAttribute;
import si.ijs.kt.clus.data.cols.attribute.NominalAttrBase;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.selection.ClusSelection;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class NominalAttribute
extends NominalAttrBase {
    public int[] m_Data;
    protected int m_NbRows;
    protected static final boolean DEBUG = true;

    public NominalAttribute(NominalAttrType type) {
        super(type);
    }

    @Override
    public void resize(int rows) {
        this.m_NbRows = rows;
        this.m_Data = new int[rows];
    }

    @Override
    public ClusAttribute select(ClusSelection sel, int nbsel) {
        int s_data = 0;
        int s_subset = 0;
        int[] data = this.m_Data;
        this.m_Data = new int[this.m_NbRows - nbsel];
        int[] subset = new int[nbsel];
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (sel.isSelected(i)) {
                subset[s_subset++] = data[i];
                continue;
            }
            this.m_Data[s_data++] = data[i];
        }
        this.m_NbRows -= nbsel;
        NominalAttribute s_attr = new NominalAttribute(this.m_Type);
        s_attr.m_Data = subset;
        s_attr.m_NbRows = nbsel;
        return s_attr;
    }

    @Override
    public void insert(ClusAttribute attr, ClusSelection sel, int nb_new) {
        int s_data = 0;
        int s_subset = 0;
        int[] data = this.m_Data;
        this.m_Data = new int[nb_new];
        int[] subset = ((NominalAttribute)attr).m_Data;
        for (int i = 0; i < nb_new; ++i) {
            this.m_Data[i] = sel.isSelected(i) ? subset[s_subset++] : data[s_data++];
        }
        this.m_NbRows = nb_new;
    }

    @Override
    public void findBestTest(MyArray leaves, ColTarget target, ClusStatManager smanager) {
        int nb = leaves.size();
        for (int i = 0; i < nb; ++i) {
        }
        this.findSplit(leaves, smanager);
    }

    public void findSplit(MyArray leaves, ClusStatManager smanager) {
    }

    @Override
    public void split(ColTarget target) {
    }

    public boolean read(ClusReader data, int row) throws IOException {
        String value = data.readString();
        if (value == null) {
            return false;
        }
        if (value.equals("?")) {
            this.m_Type.incNbMissing();
            this.m_Data[row] = this.m_Type.getNbValues();
        } else {
            Integer i = this.m_Type.getValueIndex(value);
            if (i != null) {
                this.m_Data[row] = i;
            } else {
                throw new IOException("Illegal value '" + value + "' for attribute " + this.getName() + " at row " + (row + 1));
            }
        }
        return true;
    }
}

