/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.cols;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.selection.ClusSelection;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ColTarget {
    public int m_NbNumeric;
    public int m_NbNominal;
    public int m_NbRows;
    public double[][] m_Numeric;
    public int[][] m_Nominal;
    public ClusNode[] m_Node;

    public ColTarget(ClusSchema schema) {
    }

    public ClusNode[] getNodes() {
        return this.m_Node;
    }

    public int getNbAttributes() {
        return this.m_NbNumeric + this.m_NbNominal;
    }

    public int getNbNum() {
        return this.m_NbNumeric;
    }

    public int getNbNom() {
        return this.m_NbNominal;
    }

    public int getNbRows() {
        return this.m_NbRows;
    }

    public void setNbRows(int nb) {
        this.m_NbRows = nb;
    }

    public void setData(double[][] num, int[][] nom, int nbrows) {
        this.m_Numeric = num;
        this.m_Nominal = nom;
        this.m_NbRows = nbrows;
    }

    public void resize(int nbrows) {
        this.m_NbRows = nbrows;
        if (this.m_NbNumeric != 0) {
            this.m_Numeric = new double[this.m_NbRows][this.m_NbNumeric];
        }
        if (this.m_NbNominal != 0) {
            this.m_Nominal = new int[this.m_NbRows][this.m_NbNominal];
        }
    }

    public ColTarget select(ClusSelection sel, int nbsel) {
        double[][] numsubset = this.selectNumeric(sel, nbsel);
        int[][] nomsubset = this.selectNominal(sel, nbsel);
        this.setNbRows(this.m_NbRows - nbsel);
        ColTarget s_targ = null;
        s_targ.setData(numsubset, nomsubset, nbsel);
        return s_targ;
    }

    public double[][] selectNumeric(ClusSelection sel, int nbsel) {
        if (this.m_Numeric == null) {
            return null;
        }
        int s_data = 0;
        int s_subset = 0;
        double[][] data = this.m_Numeric;
        this.m_Numeric = new double[this.m_NbRows - nbsel][];
        double[][] subset = new double[nbsel][];
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (sel.isSelected(i)) {
                subset[s_subset++] = data[i];
                continue;
            }
            this.m_Numeric[s_data++] = data[i];
        }
        return subset;
    }

    public int[][] selectNominal(ClusSelection sel, int nbsel) {
        if (this.m_Nominal == null) {
            return null;
        }
        int s_data = 0;
        int s_subset = 0;
        int[][] data = this.m_Nominal;
        this.m_Nominal = new int[this.m_NbRows - nbsel][];
        int[][] subset = new int[nbsel][];
        for (int i = 0; i < this.m_NbRows; ++i) {
            if (sel.isSelected(i)) {
                subset[s_subset++] = data[i];
                continue;
            }
            this.m_Nominal[s_data++] = data[i];
        }
        return subset;
    }

    public void insert(ColTarget target, ClusSelection sel, int nb_new) {
        this.insertNumeric(target, sel, nb_new);
        this.insertNominal(target, sel, nb_new);
        this.m_NbRows = nb_new;
    }

    public void insertNumeric(ColTarget target, ClusSelection sel, int nb_new) {
        if (this.m_Numeric == null) {
            return;
        }
        int s_data = 0;
        int s_subset = 0;
        double[][] data = this.m_Numeric;
        this.m_Numeric = new double[nb_new][];
        double[][] subset = target.m_Numeric;
        for (int i = 0; i < nb_new; ++i) {
            this.m_Numeric[i] = sel.isSelected(i) ? subset[s_subset++] : data[s_data++];
        }
    }

    public void insertNominal(ColTarget target, ClusSelection sel, int nb_new) {
        if (this.m_Nominal == null) {
            return;
        }
        int s_data = 0;
        int s_subset = 0;
        int[][] data = this.m_Nominal;
        this.m_Nominal = new int[nb_new][];
        int[][] subset = target.m_Nominal;
        for (int i = 0; i < nb_new; ++i) {
            this.m_Nominal[i] = sel.isSelected(i) ? subset[s_subset++] : data[s_data++];
        }
    }

    public void addToRoot(ClusNode info) {
        this.m_Node = new ClusNode[this.m_NbRows];
        for (int i = 0; i < this.m_NbRows; ++i) {
            this.m_Node[i] = info;
        }
    }

    public void normalize() {
    }

    public void calcTotalStat(ClusStatistic stat) {
        for (int i = 0; i < this.m_NbRows; ++i) {
            stat.update(this, i);
        }
    }

    public void setNumeric(int idx, int row, double data) {
        this.m_Numeric[row][idx] = data;
    }

    public void setNominal(int idx, int row, int data) {
        this.m_Nominal[row][idx] = data;
    }

    public double[] getNumeric(int i) {
        return this.m_Numeric[i];
    }

    public int[] getNominal(int i) {
        return this.m_Nominal[i];
    }
}

