/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.attweights;

import java.util.Arrays;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.format.ClusFormat;

public class ClusNormalizedAttributeWeights
extends ClusAttributeWeights {
    public static final long serialVersionUID = 1L;
    protected double[] m_NormalizationWeights;

    public ClusNormalizedAttributeWeights(ClusAttributeWeights norm) {
        super(norm.getNbAttributes());
        this.m_NormalizationWeights = norm.getWeights();
    }

    @Override
    public double getWeight(ClusAttrType atttype) {
        int idx = atttype.getIndex();
        return this.m_Weights[idx] * this.m_NormalizationWeights[idx];
    }

    @Override
    public double getWeight(int idx) {
        return this.m_Weights[idx] * this.m_NormalizationWeights[idx];
    }

    public double getComposeWeight(ClusAttrType atttype) {
        return this.m_Weights[atttype.getIndex()];
    }

    public double getNormalizationWeight(ClusAttrType atttype) {
        return this.m_NormalizationWeights[atttype.getIndex()];
    }

    public double[] getNormalizationWeights() {
        return this.m_NormalizationWeights;
    }

    public void setAllNormalizationWeights(double value) {
        Arrays.fill(this.m_NormalizationWeights, value);
    }

    @Override
    public String getName(ClusAttrType[] type) {
        int i;
        if (type == null) {
            return this.getName();
        }
        if (type.length > 50) {
            return "Weights (" + type.length + ")";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Weights C=[");
        for (i = 0; i < type.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(ClusFormat.THREE_AFTER_DOT.format(this.getComposeWeight(type[i])));
        }
        buf.append("], N=[");
        for (i = 0; i < type.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(ClusFormat.THREE_AFTER_DOT.format(this.getNormalizationWeight(type[i])));
        }
        buf.append("]");
        return buf.toString();
    }
}

