/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.attweights;

import java.io.Serializable;
import java.util.Arrays;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.util.format.ClusFormat;

public class ClusAttributeWeights
implements Serializable {
    public static final long serialVersionUID = 1L;
    public double[] m_Weights;
    private ClusROSModelInfo m_ROSModelInfo = null;

    public ClusAttributeWeights(int nbAttr) {
        this.m_Weights = new double[nbAttr];
    }

    public double getWeight(ClusAttrType atttype) {
        return this.m_Weights[atttype.getIndex()];
    }

    public double getWeight(int i) {
        return this.m_Weights[i];
    }

    public void setWeight(ClusAttrType atttype, double weight) {
        this.m_Weights[atttype.getIndex()] = weight;
    }

    public void setWeight(int attidx, double weight) {
        this.m_Weights[attidx] = weight;
    }

    public void setAllWeights(double value) {
        Arrays.fill(this.m_Weights, value);
    }

    public int getNbAttributes() {
        return this.m_Weights.length;
    }

    public double[] getWeights() {
        return this.m_Weights;
    }

    public void copyFrom(ClusAttributeWeights other) {
        System.arraycopy(other.getWeights(), 0, this.getWeights(), 0, this.getNbAttributes());
    }

    public String getName() {
        if (this.getNbAttributes() > 50) {
            return "Weights (" + this.getNbAttributes() + ")";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Weights [");
        for (int i = 0; i < this.getNbAttributes(); ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(ClusFormat.THREE_AFTER_DOT.format(this.getWeight(i)));
        }
        buf.append("]");
        return buf.toString();
    }

    public String getName(ClusAttrType[] type) {
        if (type == null) {
            return this.getName();
        }
        if (type.length > 10) {
            return "Weights (" + type.length + ")";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Weights [");
        for (int i = 0; i < type.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(ClusFormat.THREE_AFTER_DOT.format(this.getWeight(type[i])));
        }
        buf.append("]");
        return buf.toString();
    }

    public void setROSModelInfo(ClusROSModelInfo info) {
        this.m_ROSModelInfo = info;
    }

    public ClusROSModelInfo getROSModelInfo() {
        return this.m_ROSModelInfo;
    }
}

