/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.tdidt.processor;

import java.io.IOException;
import java.io.PrintWriter;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class NodeIDWriter
extends ClusModelProcessor {
    protected boolean m_Missing;
    protected String m_Fname;
    protected PrintWriter m_Writer;
    protected ClusSchema m_Schema;
    protected MyArray m_Attrs;
    protected boolean m_First;
    protected Settings m_Sett;

    public NodeIDWriter(String fname, boolean missing, Settings sett) {
        this.m_Fname = fname;
        this.m_Missing = missing;
        this.m_Sett = sett;
    }

    @Override
    public void initialize(ClusModel model, ClusSchema schema) throws IOException {
        ClusAttrType at;
        int i;
        this.m_Attrs = new MyArray();
        int nb = schema.getNbAttributes();
        for (i = 0; i < nb; ++i) {
            at = schema.getAttrType(i);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Key)) continue;
            this.m_Attrs.addElement(at);
        }
        if (this.m_Attrs.size() == 0) {
            for (i = 0; i < nb; ++i) {
                at = schema.getAttrType(i);
                if (!at.getStatus().equals((Object)ClusAttrType.Status.Target)) continue;
                this.m_Attrs.addElement(at);
            }
        }
        this.m_First = true;
        this.m_Writer = this.m_Sett.getGeneric().getFileAbsoluteWriter(this.m_Fname);
    }

    @Override
    public void terminate(ClusModel model) throws IOException {
        this.m_Writer.close();
    }

    @Override
    public boolean needsModelUpdate() {
        return true;
    }

    @Override
    public void modelUpdate(DataTuple tuple, ClusModel model) {
        ClusNode node = (ClusNode)model;
        if (this.m_First) {
            this.m_Writer.print("pred(");
            for (int j = 0; j < this.m_Attrs.size(); ++j) {
                ClusAttrType at = (ClusAttrType)this.m_Attrs.elementAt(j);
                this.m_Writer.print(at.getString(tuple));
            }
            this.m_First = false;
        }
        this.m_Writer.print(",");
        if (this.m_Missing) {
            this.m_Writer.print("(" + tuple.getWeight() + "," + node.getID() + ")");
        } else {
            this.m_Writer.print(node.getID());
        }
    }

    @Override
    public void modelDone() {
        this.m_Writer.println(").");
        this.m_First = true;
    }
}

