/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.tdidt.processor;

import java.io.IOException;
import java.io.PrintWriter;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.processor.BasicExampleCollector;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.StringAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.util.jeans.tree.LeafTreeIterator;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class NodeExampleCollector
extends BasicExampleCollector {
    protected String m_FName;
    protected MyArray m_Attrs;
    protected boolean m_Missing;
    protected Settings m_Sett;

    public NodeExampleCollector(String fname, boolean missing, Settings sett) {
        this.m_FName = fname;
        this.m_Missing = missing;
        this.m_Sett = sett;
    }

    @Override
    public void initialize(ClusModel model, ClusSchema schema) {
        ClusAttrType at;
        int i;
        this.m_Attrs = new MyArray();
        int nb = schema.getNbAttributes();
        for (i = 0; i < nb; ++i) {
            at = schema.getAttrType(i);
            if (!at.getStatus().equals((Object)ClusAttrType.Status.Key)) continue;
            this.m_Attrs.addElement(at);
        }
        if (this.m_Attrs.size() == 0) {
            for (i = 0; i < nb; ++i) {
                at = schema.getAttrType(i);
                if (!at.getStatus().equals((Object)ClusAttrType.Status.Target)) continue;
                this.m_Attrs.addElement(at);
            }
        }
        super.initialize(model, schema);
    }

    @Override
    public void terminate(ClusModel model) throws IOException {
        ClusNode root = (ClusNode)model;
        this.writeFile(root);
        root.clearVisitors();
    }

    public final void writeFile(ClusNode root) throws IOException {
        PrintWriter wrt = this.m_Sett.getGeneric().getFileAbsoluteWriter(this.m_FName);
        LeafTreeIterator iter = new LeafTreeIterator(root);
        while (iter.hasMoreNodes()) {
            ClusNode node = (ClusNode)iter.getNextNode();
            MyArray visitor = (MyArray)node.getVisitor();
            wrt.print("leaf(" + node.getID() + ",[");
            for (int i = 0; i < visitor.size(); ++i) {
                int attrsize;
                DataTuple tuple = (DataTuple)visitor.elementAt(i);
                if (i > 0) {
                    wrt.print(",");
                }
                if (this.m_Missing) {
                    wrt.print("(" + tuple.getWeight() + ",");
                }
                if ((attrsize = this.m_Attrs.size()) > 1) {
                    wrt.print("[");
                }
                for (int j = 0; j < this.m_Attrs.size(); ++j) {
                    try {
                        StringAttrType at = (StringAttrType)this.m_Attrs.elementAt(j);
                        wrt.print(at.getString(tuple));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (this.m_Attrs.size() > 1) {
                    wrt.print("]");
                }
                if (!this.m_Missing) continue;
                wrt.print(")");
            }
            wrt.println("]).");
        }
        wrt.close();
    }
}

