/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.tdidt;

import java.io.IOException;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduce;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.multiscore.MultiScore;
import si.ijs.kt.clus.ext.constraint.ClusConstraintFile;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class ConstraintDFInduce
extends DepthFirstInduce {
    protected boolean m_FillIn;
    protected String m_ConstrFile;

    public ConstraintDFInduce(ClusSchema schema, Settings sett, boolean fillin) throws ClusException, IOException {
        super(schema, sett);
        this.m_FillIn = fillin;
        this.m_ConstrFile = sett.getConstraints().getConstraintFile();
    }

    public ConstraintDFInduce(ClusInductionAlgorithm other) {
        super(other, (NominalSplit)null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fillInStatsAndTests(ClusNode node, RowData data) throws Exception {
        NodeTest test = node.getTest();
        if (test == null) {
            return;
        }
        if (!test.hasConstants()) {
            if (this.initSelectorAndStopCrit(node, data)) {
                node.makeLeaf();
                return;
            }
            ClusAttrType at = test.getType();
            if (at instanceof NominalAttrType) {
                this.getFindBestTest().findNominal((NominalAttrType)at, data, null);
            } else {
                this.getFindBestTest().findNumeric((NumericAttrType)at, data, null);
            }
            CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
            if (!best.hasBestTest()) {
                node.makeLeaf();
                return;
            }
            node.testToNode(best);
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Fill in Test: " + node.getTestString() + " -> " + best.getHeuristicValue());
            }
        } else {
            int i;
            DataTuple tuple;
            double tot_weight = 0.0;
            double unk_weight = 0.0;
            double tot_no_unk = 0.0;
            double[] branch_weight = new double[test.getNbChildren()];
            for (i = 0; i < data.getNbRows(); tot_weight += tuple.getWeight(), ++i) {
                tuple = data.getTuple(i);
                int pred = test.predictWeighted(tuple);
                if (pred == -1) {
                    unk_weight += tuple.getWeight();
                    continue;
                }
                int n = pred;
                branch_weight[n] = branch_weight[n] + tuple.getWeight();
                tot_no_unk += tuple.getWeight();
            }
            for (i = 0; i < test.getNbChildren(); ++i) {
                test.setProportion(i, branch_weight[i] / tot_no_unk);
            }
            test.setUnknownFreq(unk_weight / tot_weight);
        }
        NodeTest best_test = node.getTest();
        int j = 0;
        while (j < node.getNbChildren()) {
            ClusNode child = (ClusNode)node.getChild(j);
            RowData subset = data.applyWeighted(best_test, j);
            child.initTargetStat(this.m_StatManager, subset);
            child.initClusteringStat(this.m_StatManager, subset);
            this.fillInStatsAndTests(child, subset);
            ++j;
        }
        return;
    }

    public void induceRecursive(ClusNode node, RowData data) throws Exception {
        if (node.atBottomLevel()) {
            this.induce(node, data, null);
        } else {
            NodeTest test = node.getTest();
            for (int j = 0; j < node.getNbChildren(); ++j) {
                ClusNode child = (ClusNode)node.getChild(j);
                RowData subset = data.applyWeighted(test, j);
                this.induceRecursive(child, subset);
            }
        }
    }

    public ClusNode createRootNode(RowData data, ClusStatistic cstat, ClusStatistic tstat) throws Exception {
        ClusConstraintFile file = ClusConstraintFile.getInstance();
        ClusNode root = file.getClone(this.m_ConstrFile);
        root.setClusteringStat(cstat);
        root.setTargetStat(tstat);
        this.fillInStatsAndTests(root, data);
        return root;
    }

    public ClusNode fillInInTree(RowData data, ClusNode tree, ClusStatistic cstat, ClusStatistic tstat) throws Exception {
        ClusNode root = tree.cloneTreeWithVisitors();
        root.setClusteringStat(cstat);
        root.setTargetStat(tstat);
        this.fillInStatsAndTests(root, data);
        return root;
    }

    public ClusNode fillInInduce(ClusRun cr, ClusNode node, MultiScore score) throws Exception {
        RowData data = (RowData)cr.getTrainingSet();
        ClusStatistic cstat = this.createTotalClusteringStat(data);
        ClusStatistic tstat = this.createTotalTargetStat(data);
        this.initSelectorAndSplit(cstat);
        ClusNode root = this.fillInInTree(data, node, cstat, tstat);
        root.afterInduce(this.getStatManager());
        this.cleanSplit();
        return root;
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws Exception {
        ClusNode root;
        RowData data = (RowData)cr.getTrainingSet();
        ClusStatistic cstat = this.createTotalClusteringStat(data);
        ClusStatistic tstat = this.createTotalTargetStat(data);
        this.initSelectorAndSplit(cstat);
        this.m_Root = root = this.createRootNode(data, cstat, tstat);
        if (!this.m_FillIn) {
            this.induceRecursive(root, data);
        }
        root.afterInduce(this.getStatManager());
        this.cleanSplit();
        return root;
    }
}

