/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.tdidt;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.Global;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.selection.OOBSelection;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.UniqueNodeIdentifier;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.tree.MyNode;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.jeans.util.StringUtils;
import si.ijs.kt.clus.util.jeans.util.compound.IntObject;
import si.ijs.kt.clus.util.tuple.Pair;

public class ClusNode
extends MyNode
implements ClusModel {
    public static final long serialVersionUID = 1L;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int UNK = 2;
    public int m_ID;
    public NodeTest m_Test;
    public ClusStatistic m_ClusteringStat;
    public ClusStatistic m_TargetStat;
    public transient Object m_Visitor;
    public long m_Time;
    public NodeTest[] m_Alternatives;
    public NodeTest[] m_OppositeAlternatives;
    public String m_AlternativesString;
    public List<Integer> m_LeafTuples;
    private UniqueNodeIdentifier m_UniqueNodeIdentifier;
    private ClusROSModelInfo m_ROSModelInfo;
    private int m_SerializationIndex;
    private ArrayList<Integer> m_SerializationIndexChildren;
    private int m_AtDepth;
    private int m_NumSubmodels;

    public void setROSModelInfo(ClusROSModelInfo info) {
        this.m_ROSModelInfo = info;
    }

    public ClusROSModelInfo getROSModelInfo() {
        return this.m_ROSModelInfo;
    }

    private void setUniqueNodeIdentifier(int value) {
        this.m_UniqueNodeIdentifier = new UniqueNodeIdentifier(value);
    }

    private UniqueNodeIdentifier getUniqueNodeIdentifier() {
        return this.m_UniqueNodeIdentifier;
    }

    @Override
    public MyNode cloneNode() throws ClusException {
        ClusNode clone = new ClusNode();
        clone.m_Test = this.m_Test;
        clone.m_ClusteringStat = this.m_ClusteringStat;
        if (this.m_TargetStat == null) {
            clone.m_TargetStat = this.m_TargetStat;
        } else {
            clone.m_TargetStat = this.m_TargetStat.cloneStat();
            clone.m_TargetStat.copy(this.m_TargetStat);
            clone.m_TargetStat.calcMean();
        }
        clone.m_Alternatives = this.m_Alternatives;
        clone.m_OppositeAlternatives = this.m_OppositeAlternatives;
        clone.m_AlternativesString = this.m_AlternativesString;
        return clone;
    }

    private String getHorizontalLineText() {
        String corner = "+";
        String dash = "-";
        return corner + dash + dash;
    }

    private String getVerticalLineText() {
        return "|";
    }

    private String getSpaces(int howmany) {
        StringBuilder sb = new StringBuilder(howmany);
        for (int i = 0; i < howmany; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private String getSpacesNo() {
        return this.getSpaces(7);
    }

    public String getSpacesYes() {
        return this.getSpaces(6);
    }

    public String getSpacesUnk() {
        return this.getSpacesNo();
    }

    public ClusNode cloneNodeWithVisitor() throws ClusException {
        ClusNode clone = (ClusNode)this.cloneNode();
        clone.setVisitor(this.getVisitor());
        return clone;
    }

    public final ClusNode cloneTreeWithVisitors(ClusNode n1, ClusNode n2) throws ClusException {
        if (n1 == this) {
            return n2;
        }
        ClusNode clone = (ClusNode)this.cloneNode();
        clone.setVisitor(this.getVisitor());
        int arity = this.getNbChildren();
        clone.setNbChildren(arity);
        for (int i = 0; i < arity; ++i) {
            ClusNode node = (ClusNode)this.getChild(i);
            clone.setChild(node.cloneTreeWithVisitors(n1, n2), i);
        }
        return clone;
    }

    public final ClusNode cloneTreeWithVisitors() throws ClusException {
        ClusNode clone = (ClusNode)this.cloneNode();
        clone.setVisitor(this.getVisitor());
        int arity = this.getNbChildren();
        clone.setNbChildren(arity);
        for (int i = 0; i < arity; ++i) {
            ClusNode node = (ClusNode)this.getChild(i);
            clone.setChild(node.cloneTreeWithVisitors(), i);
        }
        return clone;
    }

    public void inverseTests() {
        if (this.getNbChildren() == 2) {
            this.setTest(this.getTest().getBranchTest(1));
            ClusNode ch1 = (ClusNode)this.getChild(0);
            ClusNode ch2 = (ClusNode)this.getChild(1);
            ch1.inverseTests();
            ch2.inverseTests();
            this.setChild(ch2, 0);
            this.setChild(ch1, 1);
        } else {
            for (int i = 0; i < this.getNbChildren(); ++i) {
                ClusNode node = (ClusNode)this.getChild(i);
                node.inverseTests();
            }
        }
    }

    public ClusNode[] getChildren() {
        ClusNode[] temp = new ClusNode[this.m_Children.size()];
        for (int i = 0; i < this.m_Children.size(); ++i) {
            temp[i] = (ClusNode)this.getChild(i);
        }
        return temp;
    }

    public double checkTotalWeight() {
        if (this.atBottomLevel()) {
            return this.getClusteringStat().getTotalWeight();
        }
        double sum = 0.0;
        for (int i = 0; i < this.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)this.getChild(i);
            sum += child.checkTotalWeight();
        }
        if (Math.abs(this.getClusteringStat().getTotalWeight() - sum) > 1.0E-6) {
            System.err.println("ClusNode::checkTotalWeight() error: " + this.getClusteringStat().getTotalWeight() + " <> " + sum);
        }
        return sum;
    }

    public final void setVisitor(Object visitor) {
        this.m_Visitor = visitor;
    }

    public final Object getVisitor() {
        return this.m_Visitor;
    }

    public final void clearVisitors() {
        this.m_Visitor = null;
        int arity = this.getNbChildren();
        for (int i = 0; i < arity; ++i) {
            ClusNode child = (ClusNode)this.getChild(i);
            child.clearVisitors();
        }
    }

    @Override
    public final int getID() {
        return this.m_ID;
    }

    public boolean equals(Object other) {
        ClusNode o = (ClusNode)other;
        if (this.m_Test != null && o.m_Test != null) {
            if (!this.m_Test.equals(o.m_Test)) {
                return false;
            }
        } else {
            if (this.m_Test != null || o.m_Test != null) {
                return false;
            }
            System.err.println("Warning: you are comparing two leaves. This always results in true.");
        }
        int nb_c = this.getNbChildren();
        for (int i = 0; i < nb_c; ++i) {
            if (this.getChild(i).equals(o.getChild(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1234;
        hashCode = this.m_Test != null ? (hashCode += this.m_Test.hashCode()) : (hashCode += 4567);
        int nb_c = this.getNbChildren();
        for (int i = 0; i < nb_c; ++i) {
            hashCode += this.getChild(i).hashCode();
        }
        return hashCode;
    }

    public final boolean hasBestTest() {
        return this.m_Test != null;
    }

    public final NodeTest getTest() {
        return this.m_Test;
    }

    public final void setTest(NodeTest test) {
        this.m_Test = test;
    }

    public final String getTestString() {
        return this.m_Test != null ? this.m_Test.getString() : "None";
    }

    public final void testToNode(CurrentBestTestAndHeuristic best) {
        this.setTest(best.updateTest());
    }

    @Override
    public int getModelSize() {
        return this.getNbNodes();
    }

    @Override
    public String getModelInfo() {
        int[] nodesLeavesDepth = this.computeNodesLeavesDepth();
        int n = nodesLeavesDepth[0];
        int l = nodesLeavesDepth[1];
        int d = nodesLeavesDepth[2];
        return String.format("Nodes = %d; Leaves = %d; Depth = %d", n, l, d);
    }

    public final boolean hasUnknownBranch() {
        return this.m_Test.hasUnknownBranch();
    }

    public NodeTest[] getAlternatives() {
        return this.m_Alternatives;
    }

    public NodeTest[] getOppositeAlternatives() {
        return this.m_OppositeAlternatives;
    }

    public final ClusStatistic getClusteringStat() {
        return this.m_ClusteringStat;
    }

    public final ClusStatistic getTargetStat() {
        return this.m_TargetStat;
    }

    public final ClusStatistic getSmartTargetStat() {
        ClusStatistic s = this.m_TargetStat;
        while (s.getTargetSumWeights() == 0.0 && s.getParentStat() != null) {
            s = s.getParentStat();
        }
        return s;
    }

    public final double getTotWeight() {
        return this.m_ClusteringStat.getTotalWeight();
    }

    public final double getUnknownFreq() {
        return this.m_Test.getUnknownFreq();
    }

    public final void setClusteringStat(ClusStatistic stat) {
        this.m_ClusteringStat = stat;
    }

    public final void setTargetStat(ClusStatistic stat) {
        this.m_TargetStat = stat;
    }

    public final void computePrediction() throws ClusException {
        if (this.getClusteringStat() != null) {
            this.getClusteringStat().calcMean();
        }
        if (this.getTargetStat() != null) {
            this.getTargetStat().calcMean();
        }
    }

    public final int updateArity() {
        int arity = this.m_Test.updateArity();
        this.setNbChildren(arity);
        return arity;
    }

    public final ClusNode afterInduce(ClusStatManager mgr) throws ClusException {
        if (mgr == null) {
            throw new RuntimeException("ClusStatManager = null.");
        }
        if (mgr.getSettings().getMLC().shouldRunThresholdOptimization()) {
            this.optimizeTresholds();
        } else {
            this.updateTree();
        }
        this.safePrune();
        return this;
    }

    private void optimizeTresholds() throws ClusException {
        double lower = 0.0;
        double upper = 1.0;
        double middle = lower + (upper - lower) / 2.0;
        int nbRelevantLabels = this.countTrueRelevant();
        int nbPredictedRelevantNow = -1;
        while (upper - lower > 5.0E-4) {
            middle = lower + (upper - lower) / 2.0;
            this.updateThresholds(middle);
            this.updateTree();
            nbPredictedRelevantNow = this.countPredictedRelevant();
            if (nbPredictedRelevantNow == nbRelevantLabels) break;
            if (nbPredictedRelevantNow < nbRelevantLabels) {
                upper = middle;
                continue;
            }
            lower = middle;
        }
        if (nbPredictedRelevantNow != nbRelevantLabels) {
            double defaultThreshold = 0.5;
            double[] candidates = new double[]{defaultThreshold, lower, upper};
            int optimalDiff = Integer.MAX_VALUE;
            double optimalThreshold = -10.0;
            for (double candidate : candidates) {
                this.updateThresholds(candidate);
                int currentCount = this.countPredictedRelevant();
                int currentDiff = Math.abs(currentCount - nbRelevantLabels);
                if (currentDiff >= optimalDiff) continue;
                optimalThreshold = candidate;
                optimalDiff = currentDiff;
            }
            this.updateThresholds(optimalThreshold);
            this.updateTree();
        }
    }

    public void updateThresholds(double threshold) {
        ClusStatistic targetStat;
        if (this.getTargetStat() instanceof ClassificationStat) {
            targetStat = (ClassificationStat)this.getTargetStat();
            ((ClassificationStat)targetStat).setThresholds(threshold);
        } else if (this.getTargetStat() instanceof WHTDStatistic) {
            targetStat = (WHTDStatistic)this.getTargetStat();
            ((WHTDStatistic)targetStat).setThresholds(threshold);
        } else {
            throw new RuntimeException("Unknown type of target statistics.");
        }
        if (this.m_Test != null) {
            int nbChildren = this.getNbChildren();
            for (int i = 0; i < nbChildren; ++i) {
                ClusNode info = (ClusNode)this.getChild(i);
                info.updateThresholds(threshold);
            }
        }
    }

    public int countTrueRelevant() {
        int nbRelevantLabels = 0;
        if (this.getTargetStat() instanceof ClassificationStat) {
            ClassificationStat targetStat = (ClassificationStat)this.getTargetStat();
            for (int target = 0; target < targetStat.m_ClassCounts.length; ++target) {
                nbRelevantLabels = (int)((double)nbRelevantLabels + targetStat.m_ClassCounts[target][0]);
            }
        } else if (this.getTargetStat() instanceof WHTDStatistic) {
            WHTDStatistic targetStat = (WHTDStatistic)this.getTargetStat();
            boolean[] evalClasses = targetStat.getHier().getEvalClassesVector();
            double[] sumValues = targetStat.getSumValues();
            for (int i = 0; i < evalClasses.length; ++i) {
                if (!evalClasses[i]) continue;
                nbRelevantLabels = (int)((double)nbRelevantLabels + sumValues[i]);
            }
        } else {
            throw new RuntimeException("Unknown type of target statistics.");
        }
        return nbRelevantLabels;
    }

    public int countPredictedRelevant() {
        int nbPredictedRelevant;
        block5: {
            block3: {
                block4: {
                    nbPredictedRelevant = 0;
                    if (this.m_Test != null) break block3;
                    if (!(this.getTargetStat() instanceof ClassificationStat)) break block4;
                    ClassificationStat targetStat = (ClassificationStat)this.getTargetStat();
                    for (int target = 0; target < targetStat.m_ClassCounts.length; ++target) {
                        if (!(targetStat.m_ClassCounts[target][0] / targetStat.m_SumWeights[target] >= targetStat.m_Thresholds[target])) continue;
                        nbPredictedRelevant += (int)targetStat.m_SumWeights[target];
                    }
                    break block5;
                }
                if (!(this.getTargetStat() instanceof WHTDStatistic)) break block5;
                WHTDStatistic targetStat = (WHTDStatistic)this.getTargetStat();
                boolean[] evalClasses = targetStat.getHier().getEvalClassesVector();
                double[] sumValues = targetStat.getSumValues();
                double sumWeight = targetStat.getSumWeight();
                double[] thresholds = targetStat.getThresholds();
                for (int i = 0; i < evalClasses.length; ++i) {
                    if (!evalClasses[i] || !(sumValues[i] / sumWeight >= thresholds[i])) continue;
                    nbPredictedRelevant = (int)((double)nbPredictedRelevant + sumWeight);
                }
                break block5;
            }
            int nbChildren = this.getNbChildren();
            for (int i = 0; i < nbChildren; ++i) {
                ClusNode info = (ClusNode)this.getChild(i);
                nbPredictedRelevant += info.countPredictedRelevant();
            }
        }
        return nbPredictedRelevant;
    }

    public final void cleanup() {
        if (this.m_ClusteringStat != null) {
            this.m_ClusteringStat.setSDataSize(0);
        }
        if (this.m_TargetStat != null) {
            this.m_TargetStat.setSDataSize(0);
        }
    }

    public void makeLeaf() {
        this.m_Test = null;
        this.cleanup();
        this.removeAllChildren();
    }

    public final void updateTree() throws ClusException {
        this.cleanup();
        this.computePrediction();
        int nb_c = this.getNbChildren();
        for (int i = 0; i < nb_c; ++i) {
            ClusNode info = (ClusNode)this.getChild(i);
            info.updateTree();
        }
    }

    public void setAlternatives(ArrayList<NodeTest> alt) {
        this.m_Alternatives = new NodeTest[alt.size()];
        for (int i = 0; i < alt.size(); ++i) {
            this.m_Alternatives[i] = alt.get(i);
        }
    }

    public void setOppositeAlternatives(ArrayList<NodeTest> alt) {
        this.m_OppositeAlternatives = new NodeTest[alt.size()];
        for (int i = 0; i < alt.size(); ++i) {
            this.m_OppositeAlternatives[i] = alt.get(i);
        }
    }

    public void setAlternativesString(String str) {
        this.m_AlternativesString = str;
    }

    public final boolean samePrediction(ClusNode other) {
        return this.m_TargetStat.samePrediction(other.m_TargetStat);
    }

    public final boolean allSameLeaves() {
        int nb_c = this.getNbChildren();
        if (nb_c == 0) {
            return false;
        }
        ClusNode cr = (ClusNode)this.getChild(0);
        if (!cr.atBottomLevel()) {
            return false;
        }
        for (int i = 1; i < nb_c; ++i) {
            ClusNode info = (ClusNode)this.getChild(i);
            if (!info.atBottomLevel()) {
                return false;
            }
            if (info.samePrediction(cr)) continue;
            return false;
        }
        return true;
    }

    public void pruneByTrainErr(ClusAttributeWeights scale) {
        if (!this.atBottomLevel()) {
            double errorsOfLeaf;
            double errorsOfSubtree = this.estimateErrorAbsolute(scale);
            if (errorsOfSubtree >= (errorsOfLeaf = this.getTargetStat().getError(scale)) - 0.001) {
                this.makeLeaf();
            } else {
                for (int i = 0; i < this.getNbChildren(); ++i) {
                    ClusNode child = (ClusNode)this.getChild(i);
                    child.pruneByTrainErr(scale);
                }
            }
        }
    }

    public final void safePrune() {
        int nb_c = this.getNbChildren();
        for (int i = 0; i < nb_c; ++i) {
            ClusNode info = (ClusNode)this.getChild(i);
            info.safePrune();
        }
        if (this.allSameLeaves()) {
            this.makeLeaf();
        }
    }

    public final boolean allInvalidLeaves() {
        int nb_c = this.getNbChildren();
        if (nb_c == 0) {
            return false;
        }
        for (int i = 0; i < nb_c; ++i) {
            ClusNode info = (ClusNode)this.getChild(i);
            if (!info.atBottomLevel()) {
                return false;
            }
            if (!info.getTargetStat().isValidPrediction()) continue;
            return false;
        }
        return true;
    }

    public final void pruneInvalid() {
        int nb_c = this.getNbChildren();
        for (int i = 0; i < nb_c; ++i) {
            ClusNode info = (ClusNode)this.getChild(i);
            info.pruneInvalid();
        }
        if (this.allInvalidLeaves()) {
            this.makeLeaf();
        }
    }

    @Override
    public ClusModel prune(int prunetype) throws ClusException {
        if (prunetype == 0) {
            ClusNode pruned = (ClusNode)this.cloneTree();
            pruned.pruneInvalid();
            return pruned;
        }
        return this;
    }

    @Override
    public final void attachModel(HashMap table) throws ClusException {
        int nb_c = this.getNbChildren();
        if (nb_c > 0) {
            this.m_Test.attachModel(table);
        }
        for (int i = 0; i < nb_c; ++i) {
            ClusNode info = (ClusNode)this.getChild(i);
            info.attachModel(table);
        }
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) throws ClusException {
        if (this.atBottomLevel()) {
            return this.getSmartTargetStat();
        }
        int n_idx = this.m_Test.predictWeighted(tuple);
        if (n_idx != -1) {
            ClusNode info = (ClusNode)this.getChild(n_idx);
            return info.predictWeighted(tuple);
        }
        int nb_c = this.getNbChildren();
        ClusNode ch_0 = (ClusNode)this.getChild(0);
        ClusStatistic ch_0s = ch_0.predictWeighted(tuple);
        ClusStatistic stat = ch_0s.cloneSimple();
        stat.addPrediction(ch_0s, this.m_Test.getProportion(0));
        for (int i = 1; i < nb_c; ++i) {
            ClusNode ch_i = (ClusNode)this.getChild(i);
            ClusStatistic ch_is = ch_i.predictWeighted(tuple);
            stat.addPrediction(ch_is, this.m_Test.getProportion(i));
        }
        stat.computePrediction();
        return stat;
    }

    public ClusStatistic clusterWeighted(DataTuple tuple) throws ClusException {
        if (this.atBottomLevel()) {
            return this.getClusteringStat();
        }
        int n_idx = this.m_Test.predictWeighted(tuple);
        if (n_idx != -1) {
            ClusNode info = (ClusNode)this.getChild(n_idx);
            return info.clusterWeighted(tuple);
        }
        int nb_c = this.getNbChildren();
        ClusStatistic stat = this.getClusteringStat().cloneSimple();
        for (int i = 0; i < nb_c; ++i) {
            ClusNode node = (ClusNode)this.getChild(i);
            ClusStatistic nodes = node.clusterWeighted(tuple);
            stat.addPrediction(nodes, this.m_Test.getProportion(i));
        }
        stat.computePrediction();
        return stat;
    }

    public void incrementProximities(DataTuple tuple) {
        if (this.atBottomLevel()) {
            if (this.m_LeafTuples == null) {
                this.m_LeafTuples = new LinkedList<Integer>();
            }
            if (!this.m_LeafTuples.contains(tuple.getIndex())) {
                this.m_LeafTuples.add(tuple.getIndex());
            }
        } else {
            int n_idx = this.m_Test.predictWeighted(tuple);
            if (n_idx != -1) {
                ClusNode info = (ClusNode)this.getChild(n_idx);
                info.incrementProximities(tuple);
            } else {
                int nb_c = this.getNbChildren();
                for (int i = 0; i < nb_c; ++i) {
                    ClusNode ch_i = (ClusNode)this.getChild(i);
                    ch_i.incrementProximities(tuple);
                }
            }
        }
    }

    public ClusStatistic predictWeightedAndGetLeafTuples(DataTuple tuple, List<Integer> leafTuples) throws ClusException {
        if (this.atBottomLevel()) {
            if (this.m_LeafTuples != null) {
                leafTuples.addAll(this.m_LeafTuples);
            }
            return this.getTargetStat();
        }
        int n_idx = this.m_Test.predictWeighted(tuple);
        if (n_idx != -1) {
            ClusNode info = (ClusNode)this.getChild(n_idx);
            return info.predictWeightedAndGetLeafTuples(tuple, leafTuples);
        }
        int nb_c = this.getNbChildren();
        ClusNode ch_0 = (ClusNode)this.getChild(0);
        ClusStatistic ch_0s = ch_0.predictWeightedAndGetLeafTuples(tuple, leafTuples);
        ClusStatistic stat = ch_0s.cloneSimple();
        stat.addPrediction(ch_0s, this.m_Test.getProportion(0));
        for (int i = 1; i < nb_c; ++i) {
            ClusNode ch_i = (ClusNode)this.getChild(i);
            ClusStatistic ch_is = ch_i.predictWeightedAndGetLeafTuples(tuple, leafTuples);
            stat.addPrediction(ch_is, this.m_Test.getProportion(i));
        }
        stat.computePrediction();
        return stat;
    }

    public final void applyModelProcessor(DataTuple tuple, ClusModelProcessor proc) throws IOException, ClusException {
        int nb_c = this.getNbChildren();
        if (nb_c == 0 || proc.needsInternalNodes()) {
            proc.modelUpdate(tuple, this);
        }
        if (nb_c != 0) {
            int n_idx = this.m_Test.predictWeighted(tuple);
            if (n_idx != -1) {
                ClusNode info = (ClusNode)this.getChild(n_idx);
                info.applyModelProcessor(tuple, proc);
            } else {
                for (int i = 0; i < nb_c; ++i) {
                    ClusNode node = (ClusNode)this.getChild(i);
                    double prop = this.m_Test.getProportion(i);
                    node.applyModelProcessor(tuple.multiplyWeight(prop), proc);
                }
            }
        }
    }

    @Override
    public final void applyModelProcessors(DataTuple tuple, MyArray mproc) throws IOException, ClusException {
        int nb_c = this.getNbChildren();
        for (int i = 0; i < mproc.size(); ++i) {
            ClusModelProcessor proc = (ClusModelProcessor)mproc.elementAt(i);
            if (nb_c != 0 && !proc.needsInternalNodes()) continue;
            proc.modelUpdate(tuple, this);
        }
        if (nb_c != 0) {
            int n_idx = this.m_Test.predictWeighted(tuple);
            if (n_idx != -1) {
                ClusNode info = (ClusNode)this.getChild(n_idx);
                info.applyModelProcessors(tuple, mproc);
            } else {
                for (int i = 0; i < nb_c; ++i) {
                    ClusNode node = (ClusNode)this.getChild(i);
                    double prop = this.m_Test.getProportion(i);
                    node.applyModelProcessors(tuple.multiplyWeight(prop), mproc);
                }
            }
        }
    }

    public final void initTargetStat(ClusStatManager smgr, RowData subset) throws ClusException {
        this.m_TargetStat = smgr.createTargetStat();
        subset.calcTotalStatBitVector(this.m_TargetStat);
    }

    public final void initClusteringStat(ClusStatManager smgr, RowData subset) throws ClusException {
        this.m_ClusteringStat = smgr.createClusteringStat();
        subset.calcTotalStatBitVector(this.m_ClusteringStat);
    }

    public final void initTargetStat(ClusStatManager smgr, ClusStatistic train, RowData subset) throws ClusException {
        this.m_TargetStat = smgr.createTargetStat();
        this.m_TargetStat.setTrainingStat(train);
        subset.calcTotalStatBitVector(this.m_TargetStat);
    }

    public final void initClusteringStat(ClusStatManager smgr, ClusStatistic train, RowData subset) throws ClusException {
        this.m_ClusteringStat = smgr.createClusteringStat();
        this.m_ClusteringStat.setTrainingStat(train);
        subset.calcTotalStatBitVector(this.m_ClusteringStat);
    }

    public final void reInitTargetStat(RowData subset) throws ClusException {
        if (this.m_TargetStat != null) {
            this.m_TargetStat.reset();
            subset.calcTotalStatBitVector(this.m_TargetStat);
        }
    }

    public final void reInitClusteringStat(RowData subset) throws ClusException {
        if (this.m_ClusteringStat != null) {
            this.m_ClusteringStat.reset();
            subset.calcTotalStatBitVector(this.m_ClusteringStat);
        }
    }

    public final void initTotStats(ClusStatistic stat) {
        this.m_ClusteringStat = stat.cloneStat();
        int nb_c = this.getNbChildren();
        for (int i = 0; i < nb_c; ++i) {
            ClusNode node = (ClusNode)this.getChild(i);
            node.initTotStats(stat);
        }
    }

    public final void numberTree() {
        this.numberTree(new IntObject(1, null));
    }

    public final void numberTree(IntObject count) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            this.m_ID = 0;
            for (int i = 0; i < arity; ++i) {
                ClusNode child = (ClusNode)this.getChild(i);
                child.numberTree(count);
            }
        } else {
            this.m_ID = count.getValue();
            count.incValue();
        }
    }

    public final void numberCompleteTree() {
        this.numberCompleteTree(new IntObject(1, null));
    }

    public final void numberCompleteTree(IntObject count) {
        this.m_ID = count.getValue();
        count.incValue();
        int arity = this.getNbChildren();
        for (int i = 0; i < arity; ++i) {
            ClusNode child = (ClusNode)this.getChild(i);
            child.numberCompleteTree(count);
        }
    }

    public final int getTotalTreeSize() {
        int childrensize = 0;
        int arity = this.getNbChildren();
        for (int i = 0; i < arity; ++i) {
            ClusNode child = (ClusNode)this.getChild(i);
            childrensize += child.getTotalTreeSize();
        }
        return childrensize + 1;
    }

    public final void addChildStats() throws ClusException {
        int nb_c = this.getNbChildren();
        if (nb_c > 0) {
            ClusNode ch0 = (ClusNode)this.getChild(0);
            ch0.addChildStats();
            ClusStatistic stat = ch0.getClusteringStat();
            ClusStatistic root = stat.cloneSimple();
            root.addPrediction(stat, 1.0);
            for (int i = 1; i < nb_c; ++i) {
                ClusNode node = (ClusNode)this.getChild(i);
                node.addChildStats();
                root.addPrediction(node.getClusteringStat(), 1.0);
            }
            root.calcMean();
            this.setClusteringStat(root);
        }
    }

    public double estimateErrorAbsolute(ClusAttributeWeights scale) {
        return ClusNode.estimateErrorRecursive(this, scale);
    }

    public double estimateError(ClusAttributeWeights scale) {
        return ClusNode.estimateErrorRecursive(this, scale) / this.getTargetStat().getTotalWeight();
    }

    public double estimateClusteringSS(ClusAttributeWeights scale) {
        return ClusNode.estimateClusteringSSRecursive(this, scale);
    }

    public double estimateTargetSS(ClusAttributeWeights scale) {
        return ClusNode.estimateTargetSSRecursive(this, scale);
    }

    public double estimateClusteringVariance(ClusAttributeWeights scale) {
        return ClusNode.estimateClusteringSSRecursive(this, scale) / this.getClusteringStat().getTotalWeight();
    }

    public static double estimateClusteringSSRecursive(ClusNode tree, ClusAttributeWeights scale) {
        if (tree.atBottomLevel()) {
            ClusStatistic total = tree.getClusteringStat();
            return total.getSVarS(scale);
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += ClusNode.estimateClusteringSSRecursive(child, scale);
        }
        return result;
    }

    public static double estimateTargetSSRecursive(ClusNode tree, ClusAttributeWeights scale) {
        if (tree.atBottomLevel()) {
            ClusStatistic total = tree.getTargetStat();
            return total.getSVarS(scale);
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += ClusNode.estimateTargetSSRecursive(child, scale);
        }
        return result;
    }

    public static double estimateErrorRecursive(ClusNode tree, ClusAttributeWeights scale) {
        if (tree.atBottomLevel()) {
            ClusStatistic total = tree.getTargetStat();
            return total.getError(scale);
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += ClusNode.estimateErrorRecursive(child, scale);
        }
        return result;
    }

    public static double estimateErrorRecursive(ClusNode tree) {
        if (tree.atBottomLevel()) {
            ClusStatistic total = tree.getTargetStat();
            return total.getError();
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += ClusNode.estimateErrorRecursive(child);
        }
        return result;
    }

    public int getNbLeaf() {
        int nbleaf = 0;
        if (this.atBottomLevel()) {
            ++nbleaf;
        } else {
            for (int i = 0; i < this.getNbChildren(); ++i) {
                ClusNode child = (ClusNode)this.getChild(i);
                nbleaf += child.getNbLeaf();
            }
        }
        return nbleaf;
    }

    @Override
    public void printModel(PrintWriter wrt) {
        this.printTree(wrt, StatisticPrintInfo.getInstance(), "");
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) {
        this.printTree(wrt, info, "");
    }

    @Override
    public void printModelAndExamples(PrintWriter wrt, StatisticPrintInfo info, RowData examples) {
        this.printTree(wrt, info, "", examples, true);
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> dict) {
        this.printTreeToPythonScriptIterative(wrt, "\t", dict);
        wrt.println();
        wrt.println();
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> dict, String name) {
        this.printTreeToPythonTreeObject(wrt, dict, name);
        wrt.println();
        wrt.println();
    }

    @Override
    public JsonObject getModelJSON() {
        return this.getModelJSON(null);
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info) {
        return this.getModelJSON(info, null);
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info, RowData examples) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            int delta;
            JsonObject node = new JsonObject();
            String testString = this.m_Test.getTestString();
            if (this.m_Alternatives != null) {
                for (int i = 0; i < this.m_Alternatives.length; ++i) {
                    testString = testString + " and " + this.m_Alternatives[i];
                }
            }
            node.addProperty("test_string", testString);
            JsonArray children = new JsonArray();
            node.add("children", children);
            StringWriter distributionStringWriter = new StringWriter();
            PrintWriter distributionWriter = new PrintWriter(distributionStringWriter);
            this.writeDistributionForInternalNode(distributionWriter, info);
            node.addProperty("distribution", distributionStringWriter.toString());
            if (examples != null) {
                node.add("summary", examples.getSummaryJSON());
            }
            if (this.m_TargetStat == null) {
                node.addProperty("target_stat", "?");
            } else {
                node.addProperty("target_stat", this.m_TargetStat.getString(info));
            }
            int n = delta = this.hasUnknownBranch() ? 1 : 0;
            if (arity - delta == 2) {
                RowData examples0 = null;
                RowData examples1 = null;
                if (examples != null) {
                    if (this.m_Alternatives != null || this.m_OppositeAlternatives != null) {
                        examples0 = examples.applyAllAlternativeTests(this.m_Test, this.m_Alternatives, this.m_OppositeAlternatives, 0);
                        examples1 = examples.applyAllAlternativeTests(this.m_Test, this.m_Alternatives, this.m_OppositeAlternatives, 1);
                    } else {
                        examples0 = examples.apply(this.m_Test, 0);
                        examples1 = examples.apply(this.m_Test, 1);
                    }
                }
                JsonObject yes_branch = ((ClusNode)this.getChild(0)).getModelJSON(info, examples0);
                yes_branch.addProperty("branch_label", "Yes");
                JsonObject no_branch = ((ClusNode)this.getChild(1)).getModelJSON(info, examples1);
                no_branch.addProperty("branch_label", "No");
                children.add(yes_branch);
                children.add(no_branch);
                if (this.hasUnknownBranch()) {
                    JsonObject unk_branch = ((ClusNode)this.getChild(2)).getModelJSON(info, examples0);
                    children.add(unk_branch);
                }
            } else {
                for (int i = 0; i < arity; ++i) {
                    ClusNode child = (ClusNode)this.getChild(i);
                    String branchlabel = this.m_Test.getBranchLabel(i);
                    RowData examplesi = null;
                    if (examples != null) {
                        examplesi = examples.apply(this.m_Test, i);
                    }
                    JsonObject ch = child.getModelJSON(info, examplesi);
                    ch.addProperty("branch_label", branchlabel);
                    children.add(ch);
                }
            }
            return node;
        }
        JsonObject leaf = new JsonObject();
        if (this.m_TargetStat == null) {
            leaf.addProperty("target_stat", "?");
        } else {
            leaf.addProperty("target_stat", this.m_TargetStat.getString(info));
        }
        if (this.getID() != 0 && info.SHOW_INDEX) {
            leaf.addProperty("id", this.getID());
        }
        if (info.SHOW_KEY && examples != null && examples.getNbRows() > 0) {
            leaf.addProperty("example_ids", examples.printIDs(""));
        }
        if (examples != null && examples.getNbRows() > 0) {
            leaf.add("summary", examples.getSummaryJSON());
        }
        return leaf;
    }

    @Override
    public void printModelToQuery(PrintWriter wrt, ClusRun cr, int starttree, int startitem, boolean exhaustive) {
        int lastmodel = cr.getNbModels() - 1;
        ClusLogger.info("The number of models to print is:" + lastmodel);
        String[][] tabitem = new String[lastmodel + 1][10000];
        int[][] tabexist = new int[lastmodel + 1][10000];
        Global.set_treecpt(starttree);
        Global.set_itemsetcpt(startitem);
        if (exhaustive) {
            for (int i = 0; i < cr.getNbModels(); ++i) {
                ClusModelInfo mod = cr.getModelInfo(i);
                ClusNode tree = (ClusNode)cr.getModel(i);
                if (tree.getNbChildren() != 0) {
                    tree.printTreeInDatabase(wrt, tabitem[i], tabexist[i], 0, "all_trees");
                }
                if (tree.getNbNodes() <= 1) {
                    double error_rate = tree.m_ClusteringStat.getErrorRel();
                    wrt.println("#" + tree.m_ClusteringStat.getPredictedClassName(0));
                    wrt.println(mod.getModelSize() + ", " + error_rate + ", " + (1.0 - error_rate));
                } else {
                    wrt.println(mod.getModelSize() + ", " + mod.m_TrainErr.getErrorClassif() + ", " + mod.m_TrainErr.getErrorAccuracy());
                }
                Global.inc_treecpt();
            }
        } else {
            ClusModelInfo mod = cr.getModelInfo(lastmodel);
            ClusNode tree = (ClusNode)cr.getModel(lastmodel);
            tabitem[lastmodel][0] = "null";
            tabexist[lastmodel][0] = 1;
            wrt.println("INSERT INTO trees_sets VALUES(" + Global.get_itemsetcpt() + ", '" + tabitem[lastmodel][0] + "', " + tabexist[lastmodel][0] + ")");
            wrt.println("INSERT INTO greedy_trees VALUES(" + Global.get_treecpt() + ", " + Global.get_itemsetcpt() + ",1)");
            Global.inc_itemsetcpt();
            if (tree.getNbChildren() != 0) {
                this.printTreeInDatabase(wrt, tabitem[lastmodel], tabexist[lastmodel], 1, "greedy_trees");
            }
            wrt.println("INSERT INTO trees_charac VALUES(" + Global.get_treecpt() + ", " + mod.getModelSize() + ", " + mod.m_TrainErr.getErrorClassif() + ", " + mod.m_TrainErr.getErrorAccuracy() + ", NULL)");
            Global.inc_treecpt();
        }
    }

    public final void printTree() {
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(System.out));
        this.printTree(wrt, StatisticPrintInfo.getInstance(), "");
        wrt.flush();
    }

    public void printMultiLabelThresholds(PrintWriter writer, int treeIndex) {
        double[] thresholds;
        if (this.m_TargetStat instanceof ClassificationStat) {
            thresholds = ((ClassificationStat)this.m_TargetStat).m_Thresholds;
        } else if (this.m_TargetStat instanceof WHTDStatistic) {
            thresholds = ((WHTDStatistic)this.m_TargetStat).getThresholds();
        } else {
            throw new RuntimeException("Wrong type of target statistics.");
        }
        if (treeIndex >= 0) {
            writer.print(String.format("Tree %s: ", treeIndex + 1));
        }
        if (thresholds != null) {
            writer.print("[");
            for (int i = 0; i < thresholds.length; ++i) {
                writer.print(ClusFormat.FOUR_AFTER_DOT.format(thresholds[i]) + (i == thresholds.length - 1 ? "]" + System.lineSeparator() : ", "));
            }
        } else {
            writer.print("null" + System.lineSeparator());
        }
    }

    public final void writeDistributionForInternalNode(PrintWriter writer, StatisticPrintInfo info) {
        if (info.INTERNAL_DISTR && this.m_TargetStat != null) {
            writer.print(": " + this.m_TargetStat.getString(info));
        }
        writer.println();
    }

    public final void printTree(PrintWriter writer, StatisticPrintInfo info, String prefix) {
        this.printTree(writer, info, prefix, null, true);
    }

    public final void printTree(PrintWriter writer, StatisticPrintInfo info, String prefix, RowData examples, boolean is_root) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            int delta;
            int n = delta = this.hasUnknownBranch() ? 1 : 0;
            if (arity - delta == 2) {
                writer.print(this.m_Test.getTestString());
                this.showAlternatives(writer);
                RowData examples0 = null;
                RowData examples1 = null;
                if (examples != null) {
                    if (this.m_Alternatives != null || this.m_OppositeAlternatives != null) {
                        examples0 = examples.applyAllAlternativeTests(this.m_Test, this.m_Alternatives, this.m_OppositeAlternatives, 0);
                        examples1 = examples.applyAllAlternativeTests(this.m_Test, this.m_Alternatives, this.m_OppositeAlternatives, 1);
                    } else {
                        examples0 = examples.apply(this.m_Test, 0);
                        examples1 = examples.apply(this.m_Test, 1);
                    }
                }
                this.writeDistributionForInternalNode(writer, info);
                writer.print(prefix + this.getHorizontalLineText() + "yes: ");
                ((ClusNode)this.getChild(0)).printTree(writer, info, prefix + this.getVerticalLineText() + this.getSpacesYes(), examples0, false);
                writer.print(prefix + this.getHorizontalLineText() + "no:  ");
                if (this.hasUnknownBranch()) {
                    ((ClusNode)this.getChild(1)).printTree(writer, info, prefix + this.getVerticalLineText() + this.getSpacesNo(), examples1, false);
                    writer.print(prefix + this.getHorizontalLineText() + "unk: ");
                    ((ClusNode)this.getChild(2)).printTree(writer, info, prefix + this.getSpacesUnk(), examples0, false);
                } else {
                    ((ClusNode)this.getChild(1)).printTree(writer, info, prefix + this.getSpacesNo(), examples1, false);
                }
            } else {
                writer.println(this.m_Test.getTestString());
                for (int i = 0; i < arity; ++i) {
                    ClusNode child = (ClusNode)this.getChild(i);
                    String branchlabel = this.m_Test.getBranchLabel(i);
                    RowData examplesi = null;
                    if (examples != null) {
                        examples.apply(this.m_Test, i);
                    }
                    writer.print(prefix + this.getHorizontalLineText() + branchlabel + ": ");
                    String suffix = StringUtils.makeString(' ', branchlabel.length() + 4);
                    if (i != arity - 1) {
                        child.printTree(writer, info, prefix + this.getVerticalLineText() + suffix, examplesi, false);
                        continue;
                    }
                    child.printTree(writer, info, prefix + " " + suffix, examplesi, false);
                }
            }
        } else {
            if (this.m_TargetStat == null) {
                writer.print("?");
            } else {
                writer.print(this.m_TargetStat.getString(info));
            }
            if (this.getID() != 0 && info.SHOW_INDEX) {
                writer.println(" (" + this.getID() + ")");
            } else {
                writer.println();
            }
            if (info.SHOW_KEY && examples != null && examples.getNbRows() > 0) {
                writer.println(prefix + "ExampleIDs: " + examples.printIDs(prefix));
            } else if (examples != null && examples.getNbRows() > 0) {
                writer.println(prefix + "Summary:");
                writer.println(examples.getSummary(prefix));
            }
        }
    }

    public final void printPaths(PrintWriter writer, String pathprefix, String numberprefix, RowData examples, OOBSelection oob_sel, boolean testset) {
        String newnumberprefix = numberprefix.equals("") ? "" + this.getID() : numberprefix + "_" + this.getID();
        int arity = this.getNbChildren();
        if (arity > 0) {
            if (arity == 2) {
                RowData examples0 = null;
                RowData examples1 = null;
                RowData examplesMin1 = null;
                if (examples != null) {
                    examples0 = examples.apply(this.m_Test, 0);
                    examples1 = examples.apply(this.m_Test, 1);
                    examplesMin1 = examples.apply(this.m_Test, -1);
                }
                examples0.add(examplesMin1);
                examples1.add(examplesMin1);
                ((ClusNode)this.getChild(0)).printPaths(writer, pathprefix + "0", newnumberprefix, examples0, oob_sel, testset);
                ((ClusNode)this.getChild(1)).printPaths(writer, pathprefix + "1", newnumberprefix, examples1, oob_sel, testset);
            } else {
                ClusLogger.info("PrintPaths error: only binary trees supported");
            }
        } else if (examples != null) {
            for (int i = 0; i < examples.getNbRows(); ++i) {
                int exampleindex = examples.getTuple(i).getIndex();
                if (testset) {
                    writer.println(exampleindex + "  " + pathprefix + " " + newnumberprefix + "  TEST");
                } else if (oob_sel != null) {
                    boolean oob = oob_sel.isSelected(exampleindex);
                    if (oob) {
                        writer.println(exampleindex + "  " + pathprefix + " " + newnumberprefix + "  OOB");
                    } else {
                        writer.println(exampleindex + "  " + pathprefix + " " + newnumberprefix);
                    }
                } else {
                    writer.println(exampleindex + "  " + pathprefix + " " + newnumberprefix);
                }
                writer.flush();
            }
        }
    }

    public final void printTreeInDatabase(PrintWriter writer, String[] tabitem, int[] tabexist, int cpt, String typetree) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            int delta;
            int n = delta = this.hasUnknownBranch() ? 1 : 0;
            if (arity - delta == 2) {
                tabitem[cpt] = this.m_Test.getTestString();
                tabexist[cpt] = 1;
                ((ClusNode)this.getChild(0)).printTreeInDatabase(writer, tabitem, tabexist, ++cpt, typetree);
                tabitem[--cpt] = this.m_Test.getTestString();
                tabexist[cpt] = 0;
                ++cpt;
                if (this.hasUnknownBranch()) {
                    ((ClusNode)this.getChild(1)).printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                    ((ClusNode)this.getChild(2)).printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                } else {
                    ((ClusNode)this.getChild(1)).printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                }
            } else {
                writer.println("arity-delta different 2");
                for (int i = 0; i < arity; ++i) {
                    ClusNode child = (ClusNode)this.getChild(i);
                    String branchlabel = this.m_Test.getBranchLabel(i);
                    writer.print("+--" + branchlabel + ": ");
                    if (i != arity - 1) {
                        child.printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                        continue;
                    }
                    child.printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                }
            }
        } else if (this.m_TargetStat == null) {
            writer.print("?");
        } else {
            tabitem[cpt] = this.m_TargetStat.getPredictedClassName(0);
            tabexist[cpt] = 1;
            writer.print("#");
            for (int i = 0; i <= cpt - 1; ++i) {
                writer.print(this.printTestNode(tabitem[i], tabexist[i]) + ", ");
            }
            writer.println(this.printTestNode(tabitem[cpt], tabexist[cpt]));
            ++cpt;
        }
    }

    public String printTestNode(String a, int pres) {
        if (pres == 1) {
            return a;
        }
        return "not(" + a + ")";
    }

    public final void printTreeToPythonScript(PrintWriter writer, String prefix, HashMap<String, Integer> dict) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            int delta;
            int n = delta = this.hasUnknownBranch() ? 1 : 0;
            if (arity - delta == 2) {
                int index = dict.get(this.m_Test.getType().getName());
                String atrNameReplacement = String.format("xs[%d]", index);
                String testString = "if " + this.m_Test.getPythonTestString(atrNameReplacement) + ":";
                writer.println(prefix + testString);
                ((ClusNode)this.getChild(0)).printTreeToPythonScript(writer, prefix + "\t", dict);
                writer.println(prefix + "else:");
                if (this.hasUnknownBranch()) {
                    System.err.println("has unknown branch");
                    writer.println(prefix + "Let there be syntax errors. This is unknown branch!");
                } else {
                    ((ClusNode)this.getChild(1)).printTreeToPythonScript(writer, prefix + "\t", dict);
                }
            } else {
                System.err.println("arity - delta != 2 becauese arity: " + arity + " and delta: " + delta);
                writer.println(prefix + "Let there be syntax errors. Situation: here arity - delta != 2");
            }
        } else if (this.m_TargetStat != null) {
            writer.println(prefix + "return " + this.m_TargetStat.getArrayOfStatistic());
        } else {
            System.err.println("m_TargetStat == null");
            writer.println(prefix + "return null, because m_TargetStat is null");
        }
    }

    public final void printTreeToPythonScriptIterative(PrintWriter writer, String prefix, HashMap<String, Integer> dict) {
        ClusNode current;
        HashMap<UniqueNodeIdentifier, Integer> tree_nodes = new HashMap<UniqueNodeIdentifier, Integer>();
        int identifier = 0;
        Stack<ClusNode> temp = new Stack<ClusNode>();
        temp.push(this);
        while (!temp.isEmpty()) {
            current = (ClusNode)temp.pop();
            current.setUniqueNodeIdentifier(identifier);
            ++identifier;
            if (tree_nodes.containsKey(current.getUniqueNodeIdentifier())) {
                ClusLogger.info(current + " exists");
            }
            tree_nodes.put(current.getUniqueNodeIdentifier(), 0);
            int children = current.getNbChildren();
            if (children != 0 && children != 2) {
                System.err.println("Warning: not a binary tree! Python code won't work properly with high probability.");
            }
            for (int i = 0; i < children; ++i) {
                temp.push((ClusNode)current.getChild(i));
            }
        }
        current = this;
        int current_indentation = prefix.length() - prefix.replace("\t", "").length();
        while (current != null) {
            int arity = current.getNbChildren();
            String current_prefix = StringUtils.makeString('\t', current_indentation);
            if (arity > 0) {
                int visits = (Integer)tree_nodes.get(current.getUniqueNodeIdentifier());
                tree_nodes.put(current.getUniqueNodeIdentifier(), visits + 1);
                if (visits == 0) {
                    String atrNameReplacement = String.format("xs[%d]", dict.get(current.m_Test.getType().getName()));
                    String testString = "if " + current.m_Test.getPythonTestString(atrNameReplacement) + ":";
                    writer.println(current_prefix + testString);
                    current = (ClusNode)current.getChild(0);
                    ++current_indentation;
                    continue;
                }
                if (visits == 1) {
                    writer.println(current_prefix + "else:");
                    current = (ClusNode)current.getChild(1);
                    ++current_indentation;
                    continue;
                }
                if (visits == 2) {
                    current = (ClusNode)current.m_Parent;
                    --current_indentation;
                    continue;
                }
                System.err.println("Warning: more than two visits of the node " + this.toString());
                continue;
            }
            if (this.m_TargetStat != null) {
                String s;
                if (current.m_TargetStat instanceof ClassificationStat) {
                    boolean isMLC = this.getClusteringStat().getSettings().getMLC().getSection().isEnabled();
                    s = ((ClassificationStat)current.m_TargetStat).getArrayOfStatisticExtended(isMLC);
                } else {
                    s = this.m_TargetStat instanceof WHTDStatistic ? ((WHTDStatistic)current.m_TargetStat).getArrayOfStatisticExtended() : current.m_TargetStat.getArrayOfStatistic();
                }
                writer.println(current_prefix + "return " + s);
            } else {
                System.err.println("m_TargetStat == null");
                writer.println(current_prefix + "return null, because m_TargetStat is null");
            }
            current = (ClusNode)current.m_Parent;
            --current_indentation;
        }
    }

    public final void printTreeToPythonTreeObject(PrintWriter writer, HashMap<String, Integer> dict, String modelIdentifier) {
        ClusNode current;
        HashMap<UniqueNodeIdentifier, Integer> children_left = new HashMap<UniqueNodeIdentifier, Integer>();
        int identifier = 0;
        Stack<ClusNode> temp = new Stack<ClusNode>();
        temp.push(this);
        while (!temp.isEmpty()) {
            int children;
            current = (ClusNode)temp.pop();
            current.setUniqueNodeIdentifier(identifier);
            ++identifier;
            if (children_left.containsKey(current.getUniqueNodeIdentifier())) {
                ClusLogger.info(current + " exists");
            }
            if ((children = current.getNbChildren()) != 0 && children != 2) {
                System.err.println("Warning: not a binary tree! Python code won't work properly with high probability.");
            }
            children_left.put(current.getUniqueNodeIdentifier(), children);
            for (int i = 0; i < children; ++i) {
                temp.push((ClusNode)current.getChild(i));
            }
        }
        temp = new Stack();
        temp.push(this);
        while (!temp.isEmpty()) {
            current = (ClusNode)temp.peek();
            UniqueNodeIdentifier currentID = current.getUniqueNodeIdentifier();
            boolean isProcessed = false;
            if (current.atBottomLevel()) {
                writer.println(this.pythonTreeLeafNodeLine(current, modelIdentifier));
                isProcessed = true;
            } else if ((Integer)children_left.get(currentID) == 0) {
                writer.println(ClusNode.pythonTreeInternalNodeLine(current, modelIdentifier, dict.get(current.m_Test.getType().getName())));
                isProcessed = true;
            } else if (((Integer)children_left.get(currentID)).intValue() == current.getNbChildren()) {
                for (int i = 0; i < current.getNbChildren(); ++i) {
                    temp.push((ClusNode)current.getChild(i));
                }
            } else {
                System.err.println("printTreeToPythonTree:\n    Probably something went wrong: the #processed children is neither #children nor 0!");
            }
            if (!isProcessed) continue;
            if (current.getParent() != null) {
                UniqueNodeIdentifier parentID = ((ClusNode)current.getParent()).getUniqueNodeIdentifier();
                int previous = (Integer)children_left.get(parentID);
                children_left.put(parentID, previous - 1);
            }
            temp.pop();
        }
        String targetNames = this.pythonTargetNames(this);
        writer.println(String.format("tree_%s = Tree(%s, target_names=%s)", modelIdentifier, ClusNode.pythonNodeName(this, modelIdentifier), targetNames));
    }

    private static String pythonNodeName(ClusNode node, String modelIdentifier) {
        return String.format("node_%s_%d", modelIdentifier, node.getUniqueNodeIdentifier().getID());
    }

    private static String pythonTreeInternalNodeLine(ClusNode node, String modelIdentifier, int inputAttrIndex) {
        Object[] children = new String[node.getNbChildren()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = ClusNode.pythonNodeName((ClusNode)node.getChild(i), modelIdentifier);
        }
        String childrenArg = String.format("children=%s", Arrays.toString(children));
        String frequenciesArg = String.format("branch_frequencies=%s", Arrays.toString(node.getTest().getProportions()));
        String testArg = String.format("test=BinaryNodeTest(%d, test_function=lambda t: t%s)", inputAttrIndex, node.m_Test.getPythonTestString(""));
        return String.format("%s = TreeNode(%s, %s, %s)", ClusNode.pythonNodeName(node, modelIdentifier), childrenArg, frequenciesArg, testArg);
    }

    private String pythonTreeLeafNodeLine(ClusNode leaf, String modelIdentifier) {
        String statArg;
        if (this.m_TargetStat instanceof RegressionStat) {
            statArg = String.format("prediction_statistics=RegressionStat(%s)", leaf.m_TargetStat.getArrayOfStatistic());
        } else if (this.m_TargetStat instanceof ClassificationStat) {
            boolean isMLC = this.getTargetStat().getSettings().getMLC().getSection().isEnabled();
            statArg = String.format("prediction_statistics=ClassificationStat(%s)", ((ClassificationStat)leaf.m_TargetStat).getArrayOfStatisticExtended(isMLC));
        } else if (this.m_TargetStat instanceof WHTDStatistic) {
            statArg = String.format("prediction_statistics=RegressionStat(%s)", ((WHTDStatistic)leaf.m_TargetStat).getArrayOfStatisticExtended());
        } else {
            throw new RuntimeException("Python code for your target-type statistics not implemented.");
        }
        return String.format("%s = TreeNode(%s)", ClusNode.pythonNodeName(leaf, modelIdentifier), statArg);
    }

    private String pythonTargetNames(ClusNode leaf) {
        if (this.m_TargetStat instanceof RegressionStat) {
            return "None";
        }
        if (this.m_TargetStat instanceof ClassificationStat) {
            boolean isMLC = this.getTargetStat().getSettings().getMLC().getSection().isEnabled();
            if (isMLC) {
                return ((ClassificationStat)leaf.m_TargetStat).getTargetNames();
            }
            return "None";
        }
        if (this.m_TargetStat instanceof WHTDStatistic) {
            return ((WHTDStatistic)leaf.m_TargetStat).getTargetNames();
        }
        throw new RuntimeException("Python code for your target-type statistics not implemented.");
    }

    public final void showAlternatives(PrintWriter writer) {
        if (this.m_AlternativesString != null) {
            writer.print(this.m_AlternativesString);
        }
    }

    public String toString() {
        try {
            if (this.hasBestTest()) {
                return this.getTestString();
            }
            return this.m_TargetStat.getSimpleString();
        }
        catch (Exception e) {
            return "null clusnode ";
        }
    }

    public ClusStatistic predictWeightedLeaf(DataTuple tuple) {
        return this.getTargetStat();
    }

    @Override
    public void retrieveStatistics(ArrayList<ClusStatistic> list) {
        if (this.m_ClusteringStat != null) {
            list.add(this.m_ClusteringStat);
        }
        if (this.m_TargetStat != null) {
            list.add(this.m_TargetStat);
        }
        int arity = this.getNbChildren();
        for (int i = 0; i < arity; ++i) {
            ClusNode child = (ClusNode)this.getChild(i);
            child.retrieveStatistics(list);
        }
    }

    public int getLargestBranchIndex() {
        double max = 0.0;
        int max_idx = -1;
        for (int i = 0; i < this.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)this.getChild(i);
            double child_w = child.getTotWeight();
            if (!ClusUtil.grOrEq(child_w, max)) continue;
            max = child_w;
            max_idx = i;
        }
        return max_idx;
    }

    public void adaptToData(RowData data) throws ClusException {
        NodeTest tst = this.getTest();
        for (int i = 0; i < this.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)this.getChild(i);
            RowData subset = data.applyWeighted(tst, i);
            child.adaptToData(subset);
        }
        this.reInitTargetStat(data);
        this.reInitClusteringStat(data);
    }

    public final int[] computeNodesLeavesDepth() {
        int nodes = 0;
        int leaves = 0;
        int depth = 0;
        Stack<Pair<ClusNode, Integer>> stack = new Stack<Pair<ClusNode, Integer>>();
        stack.add(new Pair<ClusNode, Integer>(this, 1));
        while (!stack.isEmpty()) {
            Pair currentPair = (Pair)stack.pop();
            ClusNode currentNode = (ClusNode)currentPair.getFirst();
            int currentDepth = (Integer)currentPair.getSecond();
            depth = Math.max(depth, currentDepth);
            ++nodes;
            if (!currentNode.hasBestTest()) {
                ++leaves;
                continue;
            }
            for (ClusNode child : currentNode.getChildren()) {
                stack.push(new Pair<ClusNode, Integer>(child, currentDepth + 1));
            }
        }
        return new int[]{nodes, leaves, depth};
    }

    public int getNbNodes() {
        return this.computeNodesLeavesDepth()[0];
    }

    private boolean shouldCut() {
        return Math.floorMod(this.m_AtDepth, 5) == 0 && this.hasBestTest();
    }

    public static ArrayList<ClusNode> cutTrees(ClusNode model) {
        ClusNode.computeDepthsAt(model);
        ArrayList<ClusNode> models = new ArrayList<ClusNode>();
        Stack<ClusNode> stack = new Stack<ClusNode>();
        stack.add(model);
        while (!stack.isEmpty()) {
            ClusNode currentNode = (ClusNode)stack.pop();
            if (!currentNode.hasBestTest()) continue;
            for (ClusNode child : currentNode.getChildren()) {
                stack.push(child);
            }
            if (!currentNode.shouldCut()) continue;
            currentNode.m_SerializationIndexChildren = new ArrayList();
            for (ClusNode child : currentNode.getChildren()) {
                int serializationIndex = models.size();
                models.add(child);
                child.m_SerializationIndex = serializationIndex;
                currentNode.m_SerializationIndexChildren.add(serializationIndex);
                child.m_Parent = null;
            }
            currentNode.m_Children = null;
        }
        model.m_NumSubmodels = models.size();
        return models;
    }

    public void joinWithSubmodels(ArrayList<ClusNode> models) {
        Stack<Object> stack = new Stack<Object>();
        stack.add(this);
        while (!stack.isEmpty()) {
            ClusNode currentNode = (ClusNode)stack.pop();
            if (currentNode.shouldCut()) {
                currentNode.m_Children = new MyArray();
                Iterator<Integer> iterator = currentNode.m_SerializationIndexChildren.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    ClusNode child = models.get(i);
                    currentNode.m_Children.addElement(child);
                    child.m_Parent = currentNode;
                }
            }
            for (ClusNode child : currentNode.getChildren()) {
                stack.push(child);
            }
        }
    }

    private static void computeDepthsAt(ClusNode model) {
        model.m_AtDepth = 1;
        Stack<ClusNode> stack = new Stack<ClusNode>();
        stack.add(model);
        while (!stack.isEmpty()) {
            ClusNode currentNode = (ClusNode)stack.pop();
            if (!currentNode.hasBestTest()) continue;
            for (ClusNode child : currentNode.getChildren()) {
                child.m_AtDepth = currentNode.m_AtDepth + 1;
                stack.push(child);
            }
        }
    }

    public static String getSubmodelName(int i) {
        return String.format("Submodel%d", i);
    }

    public int getNumberSubmodels() {
        return this.m_NumSubmodels;
    }
}

