/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.split;

import java.util.Random;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicDispersion;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.section.SettingsPhylogeny;
import si.ijs.kt.clus.model.test.SubsetTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.CombStat;
import si.ijs.kt.clus.util.exception.ClusException;

public class SubsetSplit
extends NominalSplit {
    ClusStatistic m_PStat;
    ClusStatistic m_CStat;
    ClusStatistic m_MStat;
    ClusStatManager m_StatManager;

    @Override
    public void initialize(ClusStatManager manager) {
        this.m_PStat = manager.createClusteringStat();
        this.m_CStat = this.m_PStat.cloneStat();
        this.m_MStat = this.m_PStat.cloneStat();
        this.m_StatManager = manager;
    }

    @Override
    public void setSDataSize(int size) {
        this.m_PStat.setSDataSize(size);
        this.m_CStat.setSDataSize(size);
        this.m_MStat.setSDataSize(size);
    }

    public ClusStatManager getStatManager() {
        return this.m_StatManager;
    }

    public void showTest(NominalAttrType type, boolean[] isin, int add, double mheur, ClusStatistic tot, ClusStatistic pos) throws ClusException {
        for (int i = 0; i < type.getNbValues(); ++i) {
            if (!isin[i] && i != add) continue;
        }
        tot.calcMean();
        pos.calcMean();
    }

    @Override
    public void findSplit(CurrentBestTestAndHeuristic node, NominalAttrType type) throws ClusException {
        double unk_freq = 0.0;
        int nbvalues = type.getNbValues();
        boolean[] isin = new boolean[nbvalues];
        if (type.hasMissing()) {
            ClusStatistic unknown = node.m_TestStat[nbvalues];
            this.m_MStat.copy(node.m_TotStat);
            this.m_MStat.subtractFromThis(unknown);
            unk_freq = unknown.getTotalWeight() / node.m_TotStat.getTotalWeight();
        } else {
            this.m_MStat.copy(node.m_TotStat);
        }
        int card = 0;
        double pos_freq = 0.0;
        double bheur = Double.NEGATIVE_INFINITY;
        if (nbvalues == 2 && (!this.getStatManager().isRuleInduceOnly() || this.getStatManager().getSettings().getRules().isConstrainedToFirstAttVal())) {
            card = 1;
            isin[0] = true;
            ClusStatistic CStat = node.m_TestStat[0];
            bheur = node.calcHeuristic(this.m_MStat, CStat);
            pos_freq = CStat.getTotalWeight() / this.m_MStat.getTotalWeight();
        } else if (this.getStatManager().getClusterMode() == ClusStatManager.Mode.PHYLO && this.getStatManager().getSettings().getPhylogeny().getPhylogenySequence().equals((Object)SettingsPhylogeny.PhylogenySequence.DNA)) {
            int j;
            boolean[] valid = new boolean[nbvalues];
            for (j = 0; j < nbvalues; ++j) {
                this.m_PStat.reset();
                this.m_PStat.add(node.m_TestStat[j]);
                double mheur = node.calcHeuristic(this.m_MStat, this.m_PStat);
                if (mheur > bheur) {
                    bheur = mheur;
                    isin = new boolean[nbvalues];
                    isin[j] = true;
                    card = 1;
                    pos_freq = this.m_PStat.getTotalWeight() / this.m_MStat.getTotalWeight();
                }
                if (!(mheur > Double.NEGATIVE_INFINITY)) continue;
                valid[j] = true;
            }
            for (j = 0; j < nbvalues; ++j) {
                if (!valid[j]) continue;
                for (int k = j + 1; k < nbvalues; ++k) {
                    if (!valid[k]) continue;
                    this.m_PStat.reset();
                    this.m_CStat.copy(this.m_PStat);
                    this.m_CStat.add(node.m_TestStat[j]);
                    this.m_PStat.add(node.m_TestStat[j]);
                    this.m_PStat.add(node.m_TestStat[k]);
                    ClusStatistic[] csarray = new ClusStatistic[]{this.m_PStat, this.m_CStat};
                    double mheur = node.calcHeuristic(this.m_MStat, csarray, 2);
                    if (!(mheur > bheur)) continue;
                    bheur = mheur;
                    isin = new boolean[nbvalues];
                    isin[j] = true;
                    isin[k] = true;
                    card = 2;
                    pos_freq = this.m_PStat.getTotalWeight() / this.m_MStat.getTotalWeight();
                }
            }
        } else {
            this.m_PStat.reset();
            int bvalue = 0;
            if (this.m_PStat instanceof CombStat && ((CombStat)this.m_PStat).getSettings().getRules().isHeurRuleDist()) {
                ((ClusRuleHeuristicDispersion)node.m_Heuristic).setDataIndexes(new int[0]);
            }
            boolean allowSubsetSplits = this.getStatManager().getSettings().getModel().isNominalSubsetTests();
            while (bvalue != -1 && card + 1 < nbvalues) {
                bvalue = -1;
                for (int j = 0; j < nbvalues; ++j) {
                    boolean[] isin_current;
                    if (isin[j]) continue;
                    this.m_CStat.copy(this.m_PStat);
                    this.m_CStat.add(node.m_TestStat[j]);
                    if (this.m_PStat instanceof CombStat && ((CombStat)this.m_PStat).getSettings().getRules().isHeurRuleDist()) {
                        isin_current = new boolean[nbvalues];
                        for (int k = 0; k < nbvalues; ++k) {
                            isin_current[k] = isin[k];
                        }
                        isin_current[j] = true;
                        ((ClusRuleHeuristicDispersion)node.m_Heuristic).setDataIndexes(isin_current);
                    }
                    isin_current = new boolean[nbvalues];
                    for (int k = 0; k < nbvalues; ++k) {
                        isin_current[k] = isin[k];
                    }
                    isin_current[j] = true;
                    double mheur = node.calcHeuristic(this.m_MStat, this.m_CStat);
                    if (!(mheur > bheur)) continue;
                    bheur = mheur;
                    bvalue = j;
                    pos_freq = this.m_CStat.getTotalWeight() / this.m_MStat.getTotalWeight();
                    node.checkAcceptable(this.m_MStat, this.m_CStat);
                }
                if (bvalue != -1) {
                    ++card;
                    isin[bvalue] = true;
                    this.m_PStat.add(node.m_TestStat[bvalue]);
                }
                if (allowSubsetSplits) continue;
            }
        }
        if (bheur > node.m_BestHeur + 1.0E-6) {
            node.m_UnknownFreq = unk_freq;
            node.m_BestHeur = bheur;
            node.m_TestType = 1;
            node.m_BestTest = new SubsetTest(type, card, isin, pos_freq);
            node.resetAlternativeBest();
        } else if (this.getStatManager().getSettings().getTree().showAlternativeSplits() && (bheur > node.m_BestHeur - 1.0E-6 && bheur < node.m_BestHeur + 1.0E-6 || bheur == Double.POSITIVE_INFINITY)) {
            node.addAlternativeBest(new SubsetTest(type, card, isin, pos_freq));
        }
    }

    @Override
    public void findRandomSplit(CurrentBestTestAndHeuristic node, NominalAttrType type, Random rn) throws ClusException {
        int sum;
        double unk_freq = 0.0;
        int nbvalues = type.getNbValues();
        boolean[] isin = new boolean[nbvalues];
        if (type.hasMissing()) {
            ClusStatistic unknown = node.m_TestStat[nbvalues];
            this.m_MStat.copy(node.m_TotStat);
            this.m_MStat.subtractFromThis(unknown);
            unk_freq = unknown.getTotalWeight() / node.m_TotStat.getTotalWeight();
        } else {
            this.m_MStat.copy(node.m_TotStat);
        }
        int card = 0;
        double pos_freq = 0.0;
        do {
            for (int i = 0; i < isin.length; ++i) {
                isin[i] = rn.nextBoolean();
            }
            sum = 0;
            for (int i = 0; i < isin.length; ++i) {
                if (!isin[i]) continue;
                ++sum;
            }
        } while (sum == 0 || sum == nbvalues);
        card = sum;
        this.m_PStat.reset();
        for (int j = 0; j < nbvalues; ++j) {
            if (!isin[j]) continue;
            this.m_PStat.add(node.m_TestStat[j]);
        }
        pos_freq = this.m_PStat.getTotalWeight() / this.m_MStat.getTotalWeight();
        node.m_UnknownFreq = unk_freq;
        node.m_BestHeur = node.calcHeuristic(this.m_MStat, this.m_PStat);
        node.m_TestType = 1;
        node.m_BestTest = new SubsetTest(type, card, isin, pos_freq);
    }

    @Override
    public void findExtraTreeSplit(CurrentBestTestAndHeuristic node, NominalAttrType type, Random rnd) throws ClusException {
        boolean valid_test;
        double minAllowedFrequency = 0.01;
        double unk_freq = 0.0;
        int nbvalues = type.getNbValues();
        boolean[] isin = new boolean[nbvalues];
        if (type.hasMissing()) {
            ClusStatistic unknown = node.m_TestStat[nbvalues];
            this.m_MStat.copy(node.m_TotStat);
            this.m_MStat.subtractFromThis(unknown);
            unk_freq = unknown.getTotalWeight() / node.m_TotStat.getTotalWeight();
        } else {
            this.m_MStat.copy(node.m_TotStat);
        }
        int card = 0;
        double pos_freq = 0.0;
        double bheur = Double.NEGATIVE_INFINITY;
        boolean found_test = false;
        if (nbvalues == 2 && (!this.getStatManager().isRuleInduceOnly() || this.getStatManager().getSettings().getRules().isConstrainedToFirstAttVal())) {
            boolean acc_test;
            card = 1;
            isin[0] = true;
            this.m_PStat.reset();
            for (int j = 0; j < nbvalues; ++j) {
                if (!isin[j]) continue;
                this.m_PStat.add(node.m_TestStat[j]);
            }
            bheur = node.calcHeuristic(this.m_MStat, this.m_PStat);
            pos_freq = this.m_PStat.getTotalWeight() / this.m_MStat.getTotalWeight();
            boolean bl = acc_test = node.m_IsAcceptable && this.m_MStat.getTotalWeight() >= 4.0 && this.m_PStat.getTotalWeight() >= 2.0 && this.m_MStat.getTotalWeight() - this.m_PStat.getTotalWeight() >= 2.0 && pos_freq > minAllowedFrequency && pos_freq < 1.0 - minAllowedFrequency;
            if (acc_test) {
                found_test = true;
            }
        } else {
            if (this.getStatManager().getClusterMode() == ClusStatManager.Mode.PHYLO && this.getStatManager().getSettings().getPhylogeny().getPhylogenySequence().equals((Object)SettingsPhylogeny.PhylogenySequence.DNA)) {
                System.err.println("Extra-Tree split selection not implemented for Phylogentic trees.");
                throw new ClusException("Error while searching for a random split in: " + this.getClass().getName());
            }
            int count = 0;
            int nbTries = 10;
            while (!found_test && count < nbTries) {
                ++count;
                int sum = 0;
                for (int i = 0; i < isin.length; ++i) {
                    isin[i] = rnd.nextBoolean();
                    if (!isin[i]) continue;
                    ++sum;
                }
                card = sum;
                if (sum == 0 || sum == nbvalues) continue;
                this.m_PStat.reset();
                for (int j = 0; j < nbvalues; ++j) {
                    if (!isin[j]) continue;
                    this.m_PStat.add(node.m_TestStat[j]);
                }
                pos_freq = this.m_PStat.getTotalWeight() / this.m_MStat.getTotalWeight();
                node.checkAcceptable(this.m_MStat, this.m_PStat);
                boolean acc_test = node.m_IsAcceptable && this.m_MStat.getTotalWeight() >= 4.0 && this.m_PStat.getTotalWeight() >= 2.0 && this.m_MStat.getTotalWeight() - this.m_PStat.getTotalWeight() >= 2.0 && pos_freq > minAllowedFrequency && pos_freq < 1.0 - minAllowedFrequency;
                if (!acc_test) continue;
                found_test = true;
            }
            if ((count == nbTries || card == nbvalues || card == 0) && this.getStatManager().getSettings().getGeneral().getVerbose() >= 2) {
                System.err.println("Due to the randomness in split search, a usefull split was not found in " + count + " tries:");
                System.err.println("   Cardinality = " + card);
                System.err.println("   nb values = " + nbvalues);
            }
            if (found_test) {
                bheur = node.calcHeuristic(this.m_MStat, node.m_TestStat[0]);
            }
        }
        boolean bl = valid_test = node.m_IsAcceptable && this.m_MStat.getTotalWeight() >= 4.0 && this.m_PStat.getTotalWeight() >= 2.0 && this.m_MStat.getTotalWeight() - this.m_PStat.getTotalWeight() >= 2.0 && pos_freq > minAllowedFrequency && pos_freq < 1.0 - minAllowedFrequency;
        if (found_test && valid_test) {
            node.m_UnknownFreq = unk_freq;
            node.m_BestHeur = bheur;
            node.m_TestType = 1;
            node.m_BestTest = new SubsetTest(type, card, isin, pos_freq);
            node.resetAlternativeBest();
        } else {
            node.m_BestHeur = Double.NEGATIVE_INFINITY;
        }
        node.checkAcceptable(this.m_MStat, this.m_PStat);
    }

    public void findRandomPertSplit(CurrentBestTestAndHeuristic node, NominalAttrType type, Random rn, int valueincl, int valueexcl) {
        int sum;
        int nbvalues = type.getNbValues();
        boolean[] isin = new boolean[nbvalues];
        int card = 0;
        double pos_freq = 0.0;
        do {
            for (int i = 0; i < isin.length; ++i) {
                isin[i] = rn.nextBoolean();
            }
            isin[valueincl] = true;
            isin[valueexcl] = false;
            sum = 0;
            for (int i = 0; i < isin.length; ++i) {
                if (!isin[i]) continue;
                ++sum;
            }
        } while (sum == 0 || sum == nbvalues);
        card = sum;
        this.m_PStat.reset();
        for (int j = 0; j < nbvalues; ++j) {
            if (!isin[j]) continue;
            this.m_PStat.add(node.m_TestStat[j]);
        }
        node.m_TestType = 1;
        node.m_BestTest = new SubsetTest(type, card, isin, pos_freq);
    }
}

