/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules.probabilistic;

public class ClusRuleProbabilisticRuleSetInduceWeights {
    public double WEIGHT_OBJECTIVE_SIZE = 1.0;
    public double WEIGHT_OBJECTIVE_CARDINALITY = 1.0;
    public double WEIGHT_OBJECTIVE_OVERLAP = 1.0;
    public double WEIGHT_OBJECTIVE_ACCURACY = 1.0;
    public double WEIGHT_OBJECTIVE_CORRECT_COVER = 1.0;
    public double WEIGHT_OBJECTIVE_INCORRECT_COVER = 1.0;
    public boolean objectiveSizeEnabled = true;
    public boolean objectiveCardinalityEnabled = false;
    public boolean objectiveOverlapEnabled = false;
    public boolean objectiveAccuracyEnabled = true;
    public boolean objectiveCorrectCoverEnabled = false;
    public boolean objectiveIncorrectCoverEnabled = false;

    public boolean isEnabledObjectiveSize() {
        return this.objectiveSizeEnabled;
    }

    public boolean isEnabledObjectiveCardinality() {
        return this.objectiveCardinalityEnabled;
    }

    public boolean isEnabledObjectiveOverlap() {
        return this.objectiveOverlapEnabled;
    }

    public boolean isEnabledObjectiveAccuracy() {
        return this.objectiveAccuracyEnabled;
    }

    public boolean isEnabledObjectiveCorrectCover() {
        return this.objectiveCorrectCoverEnabled;
    }

    public boolean isEnabledObjectiveIncorrectCover() {
        return this.objectiveIncorrectCoverEnabled;
    }

    public ClusRuleProbabilisticRuleSetInduceWeights() {
    }

    public ClusRuleProbabilisticRuleSetInduceWeights(double[] weights, boolean[] enabledObjectives) {
        if (weights == null || weights.length != 6) {
            throw new RuntimeException("Wrong weight vector size!");
        }
        if (enabledObjectives == null || enabledObjectives.length != 6) {
            throw new RuntimeException("Wrong enabled objectives vector size!");
        }
        this.WEIGHT_OBJECTIVE_SIZE = weights[0];
        this.WEIGHT_OBJECTIVE_CARDINALITY = weights[1];
        this.WEIGHT_OBJECTIVE_OVERLAP = weights[2];
        this.WEIGHT_OBJECTIVE_ACCURACY = weights[3];
        this.WEIGHT_OBJECTIVE_CORRECT_COVER = weights[4];
        this.WEIGHT_OBJECTIVE_INCORRECT_COVER = weights[5];
        this.objectiveSizeEnabled = enabledObjectives[0];
        this.objectiveCardinalityEnabled = enabledObjectives[1];
        this.objectiveOverlapEnabled = enabledObjectives[2];
        this.objectiveAccuracyEnabled = enabledObjectives[3];
        this.objectiveCorrectCoverEnabled = enabledObjectives[4];
        this.objectiveIncorrectCoverEnabled = enabledObjectives[5];
    }

    public String getWeightsString() {
        String s = "\n\tACCURACY: " + this.WEIGHT_OBJECTIVE_ACCURACY + "\n\tSIZE: " + this.WEIGHT_OBJECTIVE_SIZE + "\n\tCARDINALITY: " + this.WEIGHT_OBJECTIVE_CARDINALITY + "\n\tOVERLAP: " + this.WEIGHT_OBJECTIVE_OVERLAP + "\n\tCORRECT COVER: " + this.WEIGHT_OBJECTIVE_CORRECT_COVER + "\n\tINCORRECT COVER: " + this.WEIGHT_OBJECTIVE_CORRECT_COVER + "\n";
        return s;
    }

    public double[] getWeights() {
        return new double[]{this.WEIGHT_OBJECTIVE_SIZE, this.WEIGHT_OBJECTIVE_CARDINALITY, this.WEIGHT_OBJECTIVE_OVERLAP, this.WEIGHT_OBJECTIVE_ACCURACY, this.WEIGHT_OBJECTIVE_CORRECT_COVER, this.WEIGHT_OBJECTIVE_INCORRECT_COVER};
    }

    public void setWeights(double[] weights) {
        if (weights == null || weights.length != 6) {
            throw new RuntimeException("Wrong weight vector size!");
        }
        this.WEIGHT_OBJECTIVE_SIZE = weights[0];
        this.WEIGHT_OBJECTIVE_CARDINALITY = weights[1];
        this.WEIGHT_OBJECTIVE_OVERLAP = weights[2];
        this.WEIGHT_OBJECTIVE_ACCURACY = weights[3];
        this.WEIGHT_OBJECTIVE_CORRECT_COVER = weights[4];
        this.WEIGHT_OBJECTIVE_INCORRECT_COVER = weights[5];
    }
}

