/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.util.Random;
import si.ijs.kt.clus.algo.split.FindBestTest;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicDispersion;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.util.exception.ClusException;

public class FindBestTestRules
extends FindBestTest {
    public FindBestTestRules(ClusStatManager mgr) {
        super(mgr);
    }

    public FindBestTestRules(ClusStatManager mgr, NominalSplit split) {
        super(mgr, split);
    }

    public void findNominal(NominalAttrType at, RowData data) throws ClusException {
        int nbvalues = at.getNbValues();
        this.m_BestTest.reset(nbvalues + 1);
        int nb_rows = data.getNbRows();
        if (!this.getSettings().getRules().isHeurRuleDist()) {
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = data.getTuple(i);
                int value = at.getNominal(tuple);
                this.m_BestTest.m_TestStat[value].updateWeighted(tuple, i);
            }
        } else {
            int i;
            int[][] data_idx_per_val = new int[nbvalues][nb_rows];
            for (int j = 0; j < nbvalues; ++j) {
                for (i = 0; i < nb_rows; ++i) {
                    data_idx_per_val[j][i] = -1;
                }
            }
            int[] counts = new int[nbvalues];
            for (i = 0; i < nb_rows; ++i) {
                DataTuple tuple = data.getTuple(i);
                int value = at.getNominal(tuple);
                this.m_BestTest.m_TestStat[value].updateWeighted(tuple, i);
                if (value >= nbvalues) continue;
                data_idx_per_val[value][i] = tuple.getIndex();
                int n = value;
                counts[n] = counts[n] + 1;
            }
            int[][] data_ipv = new int[nbvalues][];
            for (int j = 0; j < nbvalues; ++j) {
                data_ipv[j] = new int[counts[j]];
                int k = 0;
                for (int i2 = 0; i2 < nb_rows; ++i2) {
                    if (data_idx_per_val[j][i2] == -1) continue;
                    data_ipv[j][k] = data_idx_per_val[j][i2];
                    ++k;
                }
            }
            ((ClusRuleHeuristicDispersion)this.m_BestTest.m_Heuristic).setDataIndexesPerVal(data_ipv);
        }
        this.m_Split.findSplit(this.m_BestTest, at);
    }

    public void findNominalRandom(NominalAttrType at, RowData data, Random rn) throws ClusException {
        int nbvalues = at.getNbValues();
        this.m_BestTest.reset(nbvalues + 1);
        int nb_rows = data.getNbRows();
        for (int i = 0; i < nb_rows; ++i) {
            DataTuple tuple = data.getTuple(i);
            int value = at.getNominal(tuple);
            this.m_BestTest.m_TestStat[value].updateWeighted(tuple, i);
        }
        this.m_Split.findRandomSplit(this.m_BestTest, at, rn);
    }

    public void findNumeric(NumericAttrType at, RowData data) throws ClusException {
        int i;
        DataTuple tuple;
        int first;
        if (at.isSparse()) {
            data.sortSparse(at, this.m_SortHelper);
        } else {
            data.sort(at);
        }
        this.m_BestTest.reset(2);
        int nb_rows = data.getNbRows();
        this.m_BestTest.copyTotal();
        if (at.hasMissing()) {
            for (first = 0; first < nb_rows && at.isMissing(tuple = data.getTuple(first)); ++first) {
                this.m_BestTest.m_MissingStat.updateWeighted(tuple, first);
            }
            this.m_BestTest.subtractMissing();
        }
        double prev = Double.NaN;
        int[] data_idx = new int[nb_rows];
        if (this.getSettings().getRules().isHeurRuleDist()) {
            for (i = first; i < nb_rows; ++i) {
                data_idx[i] = data.getTuple(i).getIndex();
            }
        }
        for (i = first; i < nb_rows; ++i) {
            tuple = data.getTuple(i);
            double value = at.getNumeric(tuple);
            if (value != prev) {
                if (!Double.isNaN(value)) {
                    if (this.getSettings().getRules().isHeurRuleDist()) {
                        int[] subset_idx = new int[i - first];
                        System.arraycopy(data_idx, first, subset_idx, 0, i - first);
                        ((ClusRuleHeuristicDispersion)this.m_BestTest.m_Heuristic).setDataIndexes(subset_idx);
                    }
                    this.m_BestTest.updateNumeric(value, at);
                }
                prev = value;
            }
            this.m_BestTest.m_PosStat.updateWeighted(tuple, i);
        }
        if (this.m_StatManager.isRuleInduceOnly()) {
            this.m_BestTest.reset();
            DataTuple next_tuple = data.getTuple(nb_rows - 1);
            double next = at.getNumeric(next_tuple);
            for (int i2 = nb_rows - 1; i2 > first; --i2) {
                tuple = next_tuple;
                next_tuple = data.getTuple(i2 - 1);
                double value = next;
                next = at.getNumeric(next_tuple);
                this.m_BestTest.m_PosStat.updateWeighted(tuple, i2);
                if (value == next || Double.isNaN(value)) continue;
                if (this.getSettings().getRules().isHeurRuleDist()) {
                    int[] subset_idx = new int[nb_rows - i2];
                    System.arraycopy(data_idx, i2, subset_idx, 0, nb_rows - i2);
                    ((ClusRuleHeuristicDispersion)this.m_BestTest.m_Heuristic).setDataIndexes(subset_idx);
                }
                this.m_BestTest.updateInverseNumeric(value, at);
            }
        }
    }

    public void findNumericRandom(NumericAttrType at, RowData data, RowData orig_data, Random rn) throws ClusException {
        int orig_first;
        DataTuple tuple;
        int idx = at.getArrayIndex();
        if (at.isSparse()) {
            data.sortSparse(at, this.m_SortHelper);
        } else {
            data.sort(at);
        }
        this.m_BestTest.reset(2);
        int nb_rows = data.getNbRows();
        this.m_BestTest.copyTotal();
        if (at.hasMissing()) {
            for (int first = 0; first < nb_rows && (tuple = data.getTuple(first)).hasNumMissing(idx); ++first) {
                this.m_BestTest.m_MissingStat.updateWeighted(tuple, first);
            }
            this.m_BestTest.subtractMissing();
        }
        if (at.isSparse()) {
            orig_data.sortSparse(at, this.m_SortHelper);
        } else {
            orig_data.sort(at);
        }
        int orig_nb_rows = orig_data.getNbRows();
        if (at.hasMissing()) {
            for (orig_first = 0; orig_first < orig_nb_rows && (tuple = orig_data.getTuple(orig_first)).hasNumMissing(idx); ++orig_first) {
            }
        }
        double min_value = orig_data.getTuple(orig_nb_rows - 1).getDoubleVal(idx);
        double max_value = orig_data.getTuple(orig_first).getDoubleVal(idx);
        double split_value = (max_value - min_value) * rn.nextDouble() + min_value;
        for (int i = first; i < nb_rows && !((tuple = data.getTuple(i)).getDoubleVal(idx) <= split_value); ++i) {
            this.m_BestTest.m_PosStat.updateWeighted(tuple, i);
        }
        this.m_BestTest.updateNumeric(split_value, at);
        System.err.println("Inverse splits not yet included!");
    }
}

