/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.io.PrintWriter;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.RuleNormalization;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.tools.optimization.ImplicitLinearTerms;

public class ClusRuleLinearTerm
extends ClusRule {
    public static final long serialVersionUID = 1L;
    private static double[] C_maxValues = null;
    private static double[] C_minValues = null;
    private static ClusStatManager C_statManager = null;
    private static ImplicitLinearTerms C_implicitTerms = null;
    private int m_descriptiveDimForLinearTerm = 0;
    private int m_targetDimForLinearTerm = 0;
    private boolean m_scaleLinearTerm = false;

    public static void initializeClass(RowData data, ClusStatManager statMgr) {
        C_statManager = statMgr;
        double[][] linearTermsMinAndMaxes = ClusRuleLinearTerm.calcMinAndMaxForTheSet(data, C_statManager.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive));
        C_minValues = linearTermsMinAndMaxes[0];
        C_maxValues = linearTermsMinAndMaxes[1];
        C_implicitTerms = null;
    }

    private static double getOffSetValue(int iDescAttr) {
        return RuleNormalization.getDescMean(iDescAttr);
    }

    private static double getDescStdDev(int iDescAttr) {
        return RuleNormalization.getDescStdDev(iDescAttr);
    }

    private static double getTargStdDev(int iTargAttr) {
        return RuleNormalization.getTargStdDev(iTargAttr);
    }

    private static double getMaxValue(int iDescAttr) {
        return C_maxValues[iDescAttr];
    }

    private static double getMinValue(int iDescAttr) {
        return C_minValues[iDescAttr];
    }

    public static ClusRule createLinTerm(int iDescriptDim, int iTargetDim, double weight) {
        ClusRuleLinearTerm newTerm = new ClusRuleLinearTerm(C_statManager, iDescriptDim, iTargetDim);
        newTerm.setOptWeight(weight);
        return newTerm;
    }

    protected static ImplicitLinearTerms returnImplicitLinearTermsIfNeeded(RowData data) {
        if (!data.getSchema().getSettings().getRules().getOptAddLinearTerms().equals((Object)SettingsRules.OptimizationGDAddLinearTerms.YesSaveMemory)) {
            return null;
        }
        double[][] values = new double[][]{C_maxValues, C_minValues};
        C_implicitTerms = new ImplicitLinearTerms(data, C_statManager);
        return C_implicitTerms;
    }

    protected static void DeleteImplicitLinearTerms() {
        C_implicitTerms.DeleteImplicitLinearTerms();
        C_implicitTerms = null;
    }

    public ClusRuleLinearTerm(ClusStatManager statManager, int iDescriptDim, int iTargetDim) {
        super(statManager);
        this.m_descriptiveDimForLinearTerm = iDescriptDim;
        this.m_targetDimForLinearTerm = iTargetDim;
        this.m_scaleLinearTerm = statManager.getSettings().getRules().isOptNormalizeLinearTerms();
        this.m_TargetStat = statManager.createTargetStat();
        int nbTargets = statManager.getStatistic(ClusAttrType.AttributeUseType.Target).getNbAttributes();
        if (!(this.m_TargetStat instanceof RegressionStat)) {
            System.err.println("Error: Using linear terms is implemented for regression only.");
        }
        RegressionStat stat = (RegressionStat)this.m_TargetStat;
        stat.m_Means = new double[nbTargets];
        stat.m_Means[iTargetDim] = 1.0;
        stat.setNbAttributes(nbTargets);
        stat.resetSumValues(nbTargets);
        stat.resetSumWeights(nbTargets);
        stat.m_SumValues[iTargetDim] = 1.0;
        stat.m_SumWeights[iTargetDim] = 1.0;
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) {
        if (!(this.m_TargetStat instanceof RegressionStat)) {
            System.err.println("Error: Using linear terms for optimization is implemented for regression only.");
        }
        RegressionStat stat = (RegressionStat)this.m_TargetStat;
        double pred = ClusRuleLinearTerm.attributeToLinTermPrediction(this.getSettings(), tuple, this.m_descriptiveDimForLinearTerm, this.m_targetDimForLinearTerm, stat.getNbAttributes(), this.m_scaleLinearTerm);
        if (Double.isNaN(pred)) {
            for (int i = 0; i < stat.getNbAttributes(); ++i) {
                stat.m_Means[i] = Double.NaN;
                stat.m_SumValues[i] = Double.NaN;
                stat.m_SumWeights[i] = 1.0;
            }
        } else {
            for (int i = 0; i < stat.getNbAttributes(); ++i) {
                stat.m_Means[i] = 0.0;
                stat.m_SumValues[i] = stat.m_Means[i];
                stat.m_SumWeights[i] = 1.0;
            }
            stat.m_Means[this.m_targetDimForLinearTerm] = pred;
            stat.m_SumValues[this.m_targetDimForLinearTerm] = stat.m_Means[this.m_targetDimForLinearTerm];
        }
        return this.m_TargetStat;
    }

    public static double attributeToLinTermPrediction(Settings sett, DataTuple tuple, int iDescrDim, int iTarDim, int nbOfTargets, boolean scaleLinearTerm) {
        double descrValue = C_statManager.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive)[iDescrDim].getNumeric(tuple);
        if (Double.isNaN(descrValue) || Double.isInfinite(descrValue)) {
            descrValue = sett.getRules().getOptNormalizeLinearTerms().equals((Object)SettingsRules.OptimizationLinearTermNormalizeValues.YesAndConvert) ? ClusRuleLinearTerm.getOffSetValue(iDescrDim) : Double.NaN;
        }
        if (sett.getRules().isOptLinearTermsTruncate() && !Double.isNaN(ClusRuleLinearTerm.getMaxValue(iDescrDim)) && !Double.isNaN(ClusRuleLinearTerm.getMinValue(iDescrDim))) {
            descrValue = Math.max(Math.min(descrValue, ClusRuleLinearTerm.getMaxValue(iDescrDim)), ClusRuleLinearTerm.getMinValue(iDescrDim));
        }
        if (sett.getRules().isOptNormalizeLinearTerms() && scaleLinearTerm) {
            descrValue -= ClusRuleLinearTerm.getOffSetValue(iDescrDim);
            descrValue /= 2.0 * ClusRuleLinearTerm.getDescStdDev(iDescrDim);
            descrValue *= 2.0 * ClusRuleLinearTerm.getTargStdDev(iTarDim);
        }
        return descrValue;
    }

    @Override
    public boolean covers(DataTuple tuple) {
        if (this.getSettings().getRules().getOptNormalizeLinearTerms().equals((Object)SettingsRules.OptimizationLinearTermNormalizeValues.YesAndConvert)) {
            return true;
        }
        double value = C_statManager.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive)[this.m_descriptiveDimForLinearTerm].getNumeric(tuple);
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) {
        wrt.println("Linear term for the numerical attribute with index " + this.m_descriptiveDimForLinearTerm + " predicting target index " + this.m_targetDimForLinearTerm);
        if (this.getSettings().getRules().isOptLinearTermsTruncate()) {
            wrt.println("The prediction is truncated on the interval [" + C_minValues[this.m_descriptiveDimForLinearTerm] + "," + C_maxValues[this.m_descriptiveDimForLinearTerm] + "].");
        }
        if (this.getSettings().getRules().getOptNormalizeLinearTerms().equals((Object)SettingsRules.OptimizationLinearTermNormalizeValues.YesAndConvert)) {
            wrt.println("Linear term prediction was scaled and shifted by (x-average)*(standard deviation of target)/(standard deviation of descriptive) during normalization.");
        } else if (this.getSettings().getRules().getOptNormalizeLinearTerms().equals((Object)SettingsRules.OptimizationLinearTermNormalizeValues.YesAndConvert)) {
            wrt.println("Linear term prediction is scaled and shifted by (x-average)*(standard deviation of target)/(standard deviation of descriptive)");
        }
        if (this.getSettings().getRules().isOptNormalizeLinearTerms()) {
            wrt.println("      Standard deviation (targ) : " + ClusRuleLinearTerm.getTargStdDev(this.m_targetDimForLinearTerm));
            wrt.println("      Standard deviation (descr): " + ClusRuleLinearTerm.getDescStdDev(this.m_descriptiveDimForLinearTerm));
            wrt.println("      Average                   : " + ClusRuleLinearTerm.getOffSetValue(this.m_descriptiveDimForLinearTerm));
        }
        this.commonPrintForRuleTypes(wrt, info);
    }

    @Override
    public boolean isRegularRule() {
        return false;
    }

    private static double[][] calcMinAndMaxForTheSet(RowData data, NumericAttrType[] numTypes) {
        int iDim;
        double[] mins = new double[numTypes.length];
        double[] maxs = new double[numTypes.length];
        double[] nbOfValidValues = new double[numTypes.length];
        for (iDim = 0; iDim < numTypes.length; ++iDim) {
            mins[iDim] = Double.POSITIVE_INFINITY;
            maxs[iDim] = Double.NEGATIVE_INFINITY;
        }
        for (int iRow = 0; iRow < data.getNbRows(); ++iRow) {
            DataTuple tuple = data.getTuple(iRow);
            for (int jNumAttrib = 0; jNumAttrib < numTypes.length; ++jNumAttrib) {
                double value = numTypes[jNumAttrib].getNumeric(tuple);
                if (Double.isNaN(value) || Double.isInfinite(value)) continue;
                if (value > maxs[jNumAttrib]) {
                    maxs[jNumAttrib] = value;
                }
                if (value < mins[jNumAttrib]) {
                    mins[jNumAttrib] = value;
                }
                int n = jNumAttrib;
                nbOfValidValues[n] = nbOfValidValues[n] + 1.0;
            }
        }
        for (iDim = 0; iDim < numTypes.length; ++iDim) {
            if (mins[iDim] != Double.POSITIVE_INFINITY || maxs[iDim] != Double.NEGATIVE_INFINITY) continue;
            maxs[iDim] = Double.NaN;
            mins[iDim] = Double.NaN;
        }
        double[][] minAndMax = new double[][]{mins, maxs};
        return minAndMax;
    }

    public double[] convertToPlainTerm(double[] addToDefaultPred, double defaultWeight) {
        int n = this.m_targetDimForLinearTerm;
        addToDefaultPred[n] = addToDefaultPred[n] - this.getOptWeight() * ClusRuleLinearTerm.getOffSetValue(this.m_descriptiveDimForLinearTerm) * 2.0 * ClusRuleLinearTerm.getTargStdDev(this.m_targetDimForLinearTerm) / (defaultWeight * 2.0 * ClusRuleLinearTerm.getDescStdDev(this.m_descriptiveDimForLinearTerm));
        this.setOptWeight(this.getOptWeight() * 2.0 * ClusRuleLinearTerm.getTargStdDev(this.m_targetDimForLinearTerm) / (2.0 * ClusRuleLinearTerm.getDescStdDev(this.m_descriptiveDimForLinearTerm)));
        this.m_scaleLinearTerm = false;
        return addToDefaultPred;
    }
}

