/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.io.IOException;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.rules.ClusRuleInduce;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.ClusRulesFromTree;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusRuleFromTreeInduce
extends ClusRuleInduce {
    protected Clus m_Clus;

    public ClusRuleFromTreeInduce(ClusSchema schema, Settings sett, Clus clus) throws ClusException, IOException {
        super(schema, sett);
        this.m_Clus = clus;
        sett.getEnsemble().setSectionEnsembleEnabled(true);
        this.getSettings().getEnsemble().setEnsembleMode(true);
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws Exception {
        this.getSettings().getRules().disableRuleInduceParams();
        ClusEnsembleInduce ensemble = new ClusEnsembleInduce((ClusInductionAlgorithm)this, this.m_Clus);
        ensemble.induceAll(cr);
        this.getSettings().getRules().returnRuleInduceParams();
        ClusForest forestModel = (ClusForest)cr.getModel(1);
        ClusRulesFromTree treeTransform = new ClusRulesFromTree(true, this.getSettings().getTree().rulesFromTree());
        ClusRuleSet ruleSet = new ClusRuleSet(this.getStatManager());
        int numberOfUniqueRules = 0;
        ClusStatManager sm = this.getStatManager();
        ClusROSForestInfo rosForestInfo = forestModel.getEnsembleROSForestInfo();
        ClusROSModelInfo info = null;
        for (int tree = 0; tree < forestModel.getNbModels(); ++tree) {
            ClusNode treeRootNode = (ClusNode)forestModel.getModel(tree);
            switch (this.getSettings().getEnsemble().getEnsembleROSAlgorithmType()) {
                case FixedSubspaces: 
                case DynamicSubspaces: {
                    info = rosForestInfo.getROSModelInfo(tree);
                    treeRootNode.setROSModelInfo(info);
                    break;
                }
            }
            ClusRuleSet rs = treeTransform.constructRules(treeRootNode, sm);
            numberOfUniqueRules += ruleSet.addRuleSet(rs);
        }
        ClusLogger.info("Transformed " + forestModel.getNbModels() + " trees in ensemble into rules. Created " + ruleSet.getModelSize() + " rules. (" + numberOfUniqueRules + " of them are unique.)");
        RowData trainingData = (RowData)cr.getTrainingSet();
        ClusLogger.info("Calculating the default rule predictions");
        ClusStatistic left_over = this.createTotalTargetStat(trainingData);
        ruleSet.setTargetStat(left_over);
        ruleSet.postProc();
        if (this.getSettings().getRules().isRulePredictionOptimized()) {
            ruleSet = this.optimizeRuleSet(ruleSet, (RowData)cr.getTrainingSet());
        }
        if (this.getSettings().getRules().computeDispersion()) {
            ruleSet.computeDispersion(0);
            ruleSet.removeDataFromRules();
            if (cr.getTestIter() != null) {
                RowData testdata = cr.getTestSet();
                ruleSet.addDataToRules(testdata);
                ruleSet.computeDispersion(1);
                ruleSet.removeDataFromRules();
            }
        }
        ruleSet.numberRules();
        return ruleSet;
    }

    @Override
    public void induceAll(ClusRun cr) throws Exception {
        RowData trainData = (RowData)cr.getTrainingSet();
        this.getStatManager().getHeuristic().setTrainData(trainData);
        ClusModel model = this.induceSingleUnpruned(cr);
        ClusModelInfo rules_model = cr.addModelInfo(2);
        rules_model.setModel(model);
        rules_model.setName("Rules");
    }
}

