/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.io.IOException;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusCalcRuleErrorProc
extends ClusModelProcessor {
    protected int m_Subset;
    protected ClusErrorList m_Global;

    public ClusCalcRuleErrorProc(int subset, ClusErrorList global) {
        this.m_Subset = subset;
        this.m_Global = global;
    }

    @Override
    public void modelUpdate(DataTuple tuple, ClusModel model) throws IOException, ClusException {
        ClusRule rule = (ClusRule)model;
        ClusErrorList error = rule.getError(this.m_Subset);
        error.addExample(tuple, rule.getTargetStat());
    }

    @Override
    public void terminate(ClusModel model) throws IOException {
        ClusRuleSet set = (ClusRuleSet)model;
        for (int i = 0; i < set.getModelSize(); ++i) {
            ClusRule rule = set.getRule(i);
            rule.getError(this.m_Subset).updateFromGlobalMeasure(this.m_Global);
        }
    }

    @Override
    public boolean needsModelUpdate() {
        return true;
    }
}

