/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN.methods.kdTree;

import java.util.LinkedList;
import si.ijs.kt.clus.algo.kNN.methods.SearchAlgorithm;
import si.ijs.kt.clus.algo.kNN.methods.kdTree.KDTree;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class KDNode {
    public KDNode m_LeftSubTree;
    public KDNode m_RightSubTree;
    private KDTree m_Tree;
    protected int m_Level = 0;
    private ClusAttrType m_Attr;
    private static DataTuple m_Tuple = null;
    private double m_Median;
    protected LinkedList<DataTuple> m_Tuples;

    public KDNode(KDTree tree, int level) {
        throw new RuntimeException("KD-trees should not be used. We have at least one bug: in calcMedian,  the average is computed");
    }

    public void setTuples(LinkedList<DataTuple> tuples) {
        this.m_Tuples = tuples;
    }

    protected void build(int limitRepetitions) {
        try {
            if (this.m_Tuples.size() > this.m_Tree.getMaxTuples() && limitRepetitions < this.m_Tree.getRun().getDataSet((int)0).m_Schema.getNbDescriptiveAttributes()) {
                this.m_Median = this.calcMedian(this.m_Tuples, this.m_Attr);
                LinkedList<DataTuple> leftTuples = new LinkedList<DataTuple>();
                LinkedList<DataTuple> rightTuples = new LinkedList<DataTuple>();
                for (DataTuple t : this.m_Tuples) {
                    if (this.m_Tree.getDistance().getValue(t, this.m_Attr) < this.m_Median) {
                        leftTuples.add(t);
                        continue;
                    }
                    rightTuples.add(t);
                }
                if (leftTuples.size() == 0 || rightTuples.size() == 0) {
                    ++limitRepetitions;
                }
                this.m_LeftSubTree = new KDNode(this.m_Tree, this.m_Level + 1);
                this.m_LeftSubTree.setTuples(leftTuples);
                this.m_LeftSubTree.build(limitRepetitions);
                this.m_RightSubTree = new KDNode(this.m_Tree, this.m_Level + 1);
                this.m_RightSubTree.setTuples(rightTuples);
                this.m_RightSubTree.build(limitRepetitions);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isLeaf() {
        return this.m_LeftSubTree == null && this.m_RightSubTree == null;
    }

    public void find(DataTuple tuple) throws ClusException {
        m_Tuple = tuple;
        this.find();
    }

    private void find() throws ClusException {
        SearchAlgorithm.operationsCount[0] = SearchAlgorithm.operationsCount[0] + 1;
        if (this.isLeaf()) {
            for (DataTuple t : this.m_Tuples) {
                this.m_Tree.getStack().addToStack(t, this.m_Tree.getDistance().calcDistance(t, m_Tuple));
            }
        } else {
            KDNode neighbour;
            boolean rightSubspace;
            boolean bl = rightSubspace = this.m_Tree.getDistance().getValue(m_Tuple, this.m_Attr) > this.m_Median;
            if (rightSubspace) {
                this.m_RightSubTree.find();
            } else {
                this.m_LeftSubTree.find();
            }
            KDNode kDNode = neighbour = rightSubspace ? this.m_LeftSubTree : this.m_RightSubTree;
            if (neighbour.m_Tuples.size() > 0) {
                if (!this.m_Tree.getStack().enoughNeighbours()) {
                    neighbour.find();
                } else {
                    double compDistance = this.m_Tree.getStack().getWorstNearestDistance();
                    if (rightSubspace) {
                        if (this.m_Tree.getDistance().getValue(m_Tuple, this.m_Attr) - compDistance < this.m_Median) {
                            neighbour.find();
                        }
                    } else if (this.m_Tree.getDistance().getValue(m_Tuple, this.m_Attr) + compDistance > this.m_Median) {
                        neighbour.find();
                    }
                }
            }
        }
    }

    private double calcMedian(LinkedList<DataTuple> list, ClusAttrType attr) {
        double median = 0.0;
        for (DataTuple t : list) {
            median += this.m_Tree.getDistance().getValue(t, attr);
        }
        return median / (double)list.size();
    }

    public LinkedList<DataTuple> getTuples() {
        return this.m_Tuples;
    }

    public int getLevel() {
        return this.m_Level;
    }

    public void output() {
        for (int i = 0; i < this.m_Level; ++i) {
            System.out.print("\t");
        }
        for (DataTuple tuple : this.m_Tuples) {
            System.out.print(tuple.hashCode() + "; ");
        }
        ClusLogger.info("");
        if (!this.isLeaf()) {
            this.m_LeftSubTree.output();
            this.m_RightSubTree.output();
        }
    }
}

