/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN.distance.valentin;

import si.ijs.kt.clus.algo.kNN.distance.valentin.BasicDistance;
import si.ijs.kt.clus.algo.kNN.distance.valentin.NumericStatistic;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.settings.Settings;

public class NumericBasicDistance
extends BasicDistance {
    public NumericBasicDistance(Settings sett) {
        super(sett);
    }

    @Override
    public double getDistance(ClusAttrType type, DataTuple t1, DataTuple t2) {
        double y;
        NumericAttrType at = (NumericAttrType)type;
        double x = at.getNumeric(t1);
        if (Double.isNaN(x)) {
            x = at.getStatistic().mean();
        }
        if (Double.isNaN(y = at.getNumeric(t2))) {
            y = at.getStatistic().mean();
        }
        if (this.getSettings().getKNNTree().getKNNTNormalized()) {
            NumericStatistic numStat = at.getStatistic();
            double min = numStat.min();
            double max = numStat.max();
            double dif = max - min;
            x = (x - min) / dif;
            y = (y - min) / dif;
        }
        return Math.abs(x - y);
    }
}

