/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN.distance.attributeWeighting;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.kNN.distance.attributeWeighting.AttributeWeighting;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleClassifier;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.ext.featureRanking.ClusFeatureRanking;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;

public class RandomForestWeighting
extends AttributeWeighting {
    private static final long serialVersionUID = 1L;
    private double[] m_Weights;

    public RandomForestWeighting(ClusRun run, int nbBags) {
        this.generateFeatureRanking(run, nbBags);
    }

    @Override
    public double getWeight(ClusAttrType attr) {
        return this.m_Weights[attr.getIndex()];
    }

    private void generateFeatureRanking(ClusRun run, int nbBags) {
        try {
            int i;
            PrintStream oldOut = System.out;
            PrintStream ps = new PrintStream(new OutputStream(){

                @Override
                public void write(int arg0) throws IOException {
                }
            });
            ClusLogger.info("Ignoring RandomForest output.");
            System.setOut(ps);
            Settings orig_sett = run.getStatManager().getSettings();
            Clus new_clus = new Clus();
            Settings new_sett = new_clus.getSettings();
            new_sett.getGeneric().setDate(orig_sett.getGeneric().getDate());
            new_sett.getGeneric().setAppName(orig_sett.getGeneric().getAppName());
            new_sett.initialize(null, false);
            new_sett.getEnsemble().setEnsembleMode(true);
            new_sett.getAttribute().setTarget(orig_sett.getAttribute().getTarget());
            new_sett.getEnsemble().setEnsembleMethod("RForest");
            new_sett.getEnsemble().setNbBags(nbBags);
            new_sett.getEnsemble().setNbRandomAttrSelected(0);
            new_sett.getEnsemble().setOOBestimate(true);
            new_sett.getEnsemble().setFeatureRankingMethod(SettingsEnsemble.EnsembleRanking.Genie3.toString());
            ClusRandom.initialize(new_sett);
            RowData trainData = (RowData)run.getTrainingSet().cloneData();
            ClusSchema schema = run.getStatManager().getSchema().cloneSchema();
            new_sett.updateTarget(schema);
            schema.initializeSettings(new_sett);
            new_sett.getAttribute().setTarget(schema.getTarget().toString());
            new_sett.getAttribute().setDisabled(schema.getDisabled().toString());
            new_sett.getAttribute().setClustering(schema.getClustering().toString());
            new_sett.getAttribute().setDescriptive(schema.getDescriptive().toString());
            new_clus.recreateInduce(null, new ClusEnsembleClassifier(new_clus), schema, trainData);
            ClusEnsembleInduce ensemble = (ClusEnsembleInduce)new_clus.getInduce();
            new_sett.update(schema);
            new_sett.getRules().disableRuleInduceParams();
            new_clus.preprocess();
            ensemble.induceBagging(run);
            int forestIndex = 0;
            ClusFeatureRanking franking = ensemble.getEnsembleFeatureRanking(forestIndex, SettingsEnsemble.EnsembleRanking.Genie3);
            franking.computeFinalScores(ensemble.getNbTrees(forestIndex));
            System.setOut(oldOut);
            this.m_Weights = new double[schema.getDescriptiveAttributes().length];
            double dsum = 0.0;
            int rankingIndex = 0;
            for (ClusAttrType attr : schema.getDescriptiveAttributes()) {
                double d;
                this.m_Weights[attr.getIndex()] = d = franking.getAttributeRelevance(attr.getName(), rankingIndex);
                dsum += d;
            }
            for (i = 0; i < this.m_Weights.length; ++i) {
                ClusLogger.info(this.m_Weights[i]);
            }
            for (i = 0; i < this.m_Weights.length; ++i) {
                this.m_Weights[i] = 1.0 - this.m_Weights[i] / dsum;
            }
        }
        catch (Exception e) {
            ClusLogger.info("RandomForest weighting failed.");
            e.printStackTrace();
        }
    }
}

