/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo;

import java.io.IOException;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.tdidt.ClusDecisionTree;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ResourceInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;

public abstract class ClusInductionAlgorithmType {
    public static final int REGULAR_TREE = 0;
    protected Clus m_Clus;

    public ClusInductionAlgorithmType(Clus clus) {
        this.m_Clus = clus;
    }

    public Clus getClus() {
        return this.m_Clus;
    }

    public ClusInductionAlgorithm getInduce() {
        return this.getClus().getInduce();
    }

    public ClusStatManager getStatManager() {
        return this.getInduce().getStatManager();
    }

    public Settings getSettings() {
        return this.getClus().getSettings();
    }

    public abstract ClusInductionAlgorithm createInduce(ClusSchema var1, Settings var2, CMDLineArgs var3) throws ClusException, IOException;

    public void printInfo() {
        ClusLogger.info("Classifier: " + this.getClass().getName());
    }

    public abstract void pruneAll(ClusRun var1) throws ClusException, IOException, InterruptedException;

    public abstract ClusModel pruneSingle(ClusModel var1, ClusRun var2) throws ClusException, IOException, InterruptedException;

    public abstract void postProcess(ClusRun var1) throws ClusException, IOException, InterruptedException;

    public void induceAll(ClusRun cr) throws Exception {
        ClusModelInfo def_info = cr.addModelInfo(0);
        def_info.setModel(ClusDecisionTree.induceDefault(cr));
        long start_time = ResourceInfo.getTime();
        this.getInduce().induceAll(cr);
        long done_time = ResourceInfo.getTime();
        cr.setInductionTime(done_time - start_time);
        this.pruneAll(cr);
        cr.setPruneTime(ResourceInfo.getTime() - done_time);
        this.postProcess(cr);
    }

    public ClusModel induceSingle(ClusRun cr) throws Exception {
        ClusModel unpruned = this.induceSingleUnpruned(cr);
        return this.pruneSingle(unpruned, cr);
    }

    public ClusModel induceSingleUnpruned(ClusRun cr) throws Exception {
        return this.getInduce().induceSingleUnpruned(cr);
    }

    public void saveInformation(String fname) {
    }
}

