/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit.searchAlgorithm;

import java.util.ArrayList;
import org.jgap.Chromosome;
import org.jgap.FitnessFunction;
import org.jgap.IChromosome;
import si.ijs.kt.clus.addon.sit.Evaluator;
import si.ijs.kt.clus.addon.sit.TargetSet;
import si.ijs.kt.clus.addon.sit.mtLearner.MTLearner;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.GeneticSearch;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.exception.ClusException;

public class SITFitnessFunction
extends FitnessFunction {
    private static final long serialVersionUID = -3735192199503306134L;
    protected ClusAttrType mainTarget;
    protected TargetSet candidates;
    protected MTLearner learner;

    public SITFitnessFunction(ClusAttrType mainTarget, MTLearner learner, TargetSet candidates) {
        this.mainTarget = mainTarget;
        this.learner = learner;
        this.candidates = candidates;
    }

    @Override
    protected double evaluate(IChromosome chromyTheChromoson) {
        TargetSet tset = GeneticSearch.getTargetSet(this.candidates, (Chromosome)chromyTheChromoson);
        int errorIdx = tset.getIndex(this.mainTarget);
        if (errorIdx == -1) {
            return 0.0;
        }
        int nbFolds = 25;
        this.learner.initXVal(25);
        ArrayList<RowData[]> folds = new ArrayList<RowData[]>();
        for (int f = 0; f < nbFolds; ++f) {
            folds.add(this.learner.LearnModel(tset, f));
        }
        try {
            double error = 10.0 - Evaluator.getRelativeError(folds, this.mainTarget.getIndex());
            return error;
        }
        catch (ClusException e) {
            e.printStackTrace();
            return Double.POSITIVE_INFINITY;
        }
    }
}

