/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit.searchAlgorithm;

import java.util.Date;
import java.util.List;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.GeneticOperator;
import org.jgap.Genotype;
import org.jgap.InvalidConfigurationException;
import org.jgap.impl.BooleanGene;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.MutationOperator;
import si.ijs.kt.clus.addon.sit.TargetSet;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.SITFitnessFunction;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.SearchAlgorithmImpl;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.util.ClusLogger;

public class GeneticSearch
extends SearchAlgorithmImpl {
    protected final int MAX_ALLOWED_EVOLUTIONS = 50;

    @Override
    public TargetSet search(ClusAttrType mainTarget, TargetSet candidates) {
        Configuration.reset();
        DefaultConfiguration conf = new DefaultConfiguration();
        SITFitnessFunction SITFitness = new SITFitnessFunction(mainTarget, this.learner, candidates);
        Genotype population = null;
        try {
            Chromosome sampleChromosome = new Chromosome((Configuration)conf, new BooleanGene(conf), candidates.size());
            conf.setSampleChromosome(sampleChromosome);
            conf.setPopulationSize(20);
            conf.setFitnessFunction(SITFitness);
            conf.setPreservFittestIndividual(true);
            conf.setKeepPopulationSizeConstant(false);
            List l = conf.getGeneticOperators();
            for (GeneticOperator o : l) {
                if (!(o instanceof MutationOperator)) continue;
                ((MutationOperator)o).setMutationRate(1);
            }
            population = Genotype.randomInitialGenotype(conf);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        Chromosome bestSolutionSoFar = null;
        Long d = new Date().getTime();
        for (int i = 0; i < 50; ++i) {
            population.evolve();
            bestSolutionSoFar = (Chromosome)population.getFittestChromosome();
            Long new_d = new Date().getTime();
            Long dif = new_d - d;
            d = new_d;
            ClusLogger.info("Evolution " + (i + 1) + " completed in " + dif / 1000L + " sec.");
            System.out.print("Best fitness so far:" + (10.0 - bestSolutionSoFar.getFitnessValue()));
            ClusLogger.info("Best support set:" + GeneticSearch.getTargetSet(candidates, bestSolutionSoFar));
        }
        return GeneticSearch.getTargetSet(candidates, bestSolutionSoFar);
    }

    protected static final TargetSet getTargetSet(TargetSet t, Chromosome c) {
        Object[] targets = t.toArray();
        TargetSet result = new TargetSet();
        Gene[] genes = c.getGenes();
        for (int i = 0; i < t.size(); ++i) {
            if (!((BooleanGene)genes[i]).booleanValue()) continue;
            result.add(targets[i]);
        }
        return result;
    }

    @Override
    public String getName() {
        return "GeneticSearch";
    }
}

