/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit.mtLearner;

import si.ijs.kt.clus.addon.sit.TargetSet;
import si.ijs.kt.clus.addon.sit.mtLearner.MTLearner;
import si.ijs.kt.clus.addon.sit.mtLearner.ResultsCache;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.selection.XValMainSelection;
import si.ijs.kt.clus.selection.XValRandomSelection;
import si.ijs.kt.clus.selection.XValSelection;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class MTLearnerImpl
implements MTLearner {
    protected RowData m_Data;
    protected RowData m_Test = null;
    protected Settings m_Sett;
    protected XValMainSelection m_XValSel;
    protected ResultsCache m_Cache;
    protected ClusAttrType m_MainTarget;

    @Override
    public void init(RowData data, Settings sett) {
        this.m_Data = data;
        this.m_Sett = sett;
        this.m_Cache = new ResultsCache();
    }

    @Override
    public RowData[] LearnModel(TargetSet targets) throws Exception {
        if (this.m_Test == null) {
            throw new Exception();
        }
        RowData[] result = this.m_Cache.getResult(targets, this.m_Test);
        if (result != null) {
            return result;
        }
        result = this.LearnModel(targets, this.m_Data, this.m_Test);
        this.m_Cache.addResult(targets, result);
        return result;
    }

    public void setData(RowData data) {
        this.m_Data = data;
    }

    @Override
    public void initXVal(int nrFolds) {
        try {
            ClusRandom.initialize(this.m_Sett);
            this.m_XValSel = new XValRandomSelection(this.m_Data.getNbRows(), nrFolds);
        }
        catch (ClusException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int initLOOXVal() {
        try {
            ClusRandom.initialize(this.m_Sett);
            this.m_XValSel = new XValRandomSelection(this.m_Data.getNbRows(), this.m_Data.getNbRows());
        }
        catch (ClusException e) {
            e.printStackTrace();
        }
        return this.m_Data.getNbRows();
    }

    @Override
    public RowData[] LearnModel(TargetSet targets, int foldNr) {
        XValSelection msel = new XValSelection(this.m_XValSel, foldNr);
        RowData train = (RowData)this.m_Data.cloneData();
        RowData test = (RowData)train.select(msel);
        RowData[] result = this.m_Cache.getResult(targets, test);
        if (result != null) {
            return result;
        }
        result = this.LearnModel(targets, train, test);
        this.m_Cache.addResult(targets, result);
        return result;
    }

    @Override
    public void setTestData(RowData test) {
        this.m_Test = test;
    }

    @Override
    public void setMainTarget(ClusAttrType target) {
        this.m_MainTarget = target;
    }

    protected abstract RowData[] LearnModel(TargetSet var1, RowData var2, RowData var3);
}

