/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit.mtLearner;

import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.addon.sit.TargetSet;
import si.ijs.kt.clus.addon.sit.mtLearner.MTLearnerImpl;
import si.ijs.kt.clus.algo.tdidt.ClusDecisionTree;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelPredictor;

public class ClusLearner
extends MTLearnerImpl {
    protected Clus m_Clus;
    protected ClusSchema m_Schema;

    @Override
    public void init(RowData data, Settings sett) {
        this.m_Schema = data.getSchema().cloneSchema();
        RowData mydata = new RowData(data);
        mydata.setSchema(this.m_Schema);
        super.init(mydata, sett);
        this.m_Clus = new Clus();
        ClusDecisionTree clss = new ClusDecisionTree(this.m_Clus);
        try {
            this.m_Clus.initialize(mydata, this.m_Schema, sett, clss);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    protected RowData[] LearnModel(TargetSet targets, RowData train, RowData test) {
        try {
            ClusSchema schema = this.m_Clus.getSchema();
            schema.clearAttributeStatusClusteringAndTarget();
            for (ClusAttrType attr : targets) {
                ClusAttrType clusAttr = schema.getAttrType(attr.getIndex());
                clusAttr.setStatus(ClusAttrType.Status.Target);
                clusAttr.setClustering(true);
            }
            schema.addIndices(0);
            for (int i = 0; i < train.getNbRows(); ++i) {
                DataTuple tr = train.getTuple(i);
                tr.setWeight(0.0);
                for (int j = 0; j < test.getNbRows(); ++j) {
                    DataTuple te = test.getTuple(j);
                    tr.setWeight(tr.getWeight() + 1.0 / (1.0 + Math.pow(te.euclDistance(tr), 1.0)));
                }
                tr.setWeight(tr.getWeight() / (double)test.getNbRows());
            }
            ClusRun cr = this.m_Clus.train(train);
            ClusModel pruned = cr.getModel(2);
            RowData predictions = ClusModelPredictor.predict(pruned, test);
            RowData[] final_result = new RowData[]{test, predictions};
            return final_result;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @Override
    public String getName() {
        return "ClusLearner";
    }
}

