/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import si.ijs.kt.clus.addon.sit.ErrorOutput;
import si.ijs.kt.clus.addon.sit.Evaluator;
import si.ijs.kt.clus.addon.sit.TargetSet;
import si.ijs.kt.clus.addon.sit.mtLearner.ClusLearner;
import si.ijs.kt.clus.addon.sit.mtLearner.KNNLearner;
import si.ijs.kt.clus.addon.sit.mtLearner.MTLearner;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.AllTargets;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.GeneticSearch;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.GreedySIT;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.NoStopSearch;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.OneTarget;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.SearchAlgorithm;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.TC;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ARFFFile;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.io.ClusView;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.ClusStat;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsExperimental;
import si.ijs.kt.clus.selection.XValRandomSelection;
import si.ijs.kt.clus.selection.XValSelection;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.ResourceInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.IntervalCollection;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgsProvider;

public class Sit
implements CMDLineArgsProvider {
    protected Settings m_Sett = new Settings();
    protected ClusSchema m_Schema;
    protected RowData m_Data;
    protected MTLearner m_Learner;
    protected SearchAlgorithm m_Search;
    protected int m_SearchSelection;
    private static Sit singleton = null;
    public static final String[] OPTION_ARGS = new String[]{"xval"};
    public static final int[] OPTION_ARITIES = new int[]{0};

    private Sit() {
    }

    public static Sit getInstance() {
        if (singleton == null) {
            singleton = new Sit();
        }
        return singleton;
    }

    public void initialize() throws IOException, ClusException {
        ARFFFile arff = null;
        ClusLogger.info("Loading '" + this.m_Sett.getGeneric().getAppName() + "'");
        ClusRandom.initialize(this.m_Sett);
        ClusReader reader = new ClusReader(this.m_Sett.getData().getDataFile(), this.m_Sett);
        ClusLogger.info();
        ClusLogger.info("Reading ARFF Header");
        arff = new ARFFFile(reader);
        this.m_Schema = arff.read(this.m_Sett);
        ClusLogger.info("Reading CSV Data");
        this.m_Sett.updateTarget(this.m_Schema);
        this.m_Schema.initializeSettings(this.m_Sett);
        this.m_Sett.getAttribute().setTarget(this.m_Schema.getTarget().toString());
        this.m_Sett.getAttribute().setDisabled(this.m_Schema.getDisabled().toString());
        this.m_Sett.getAttribute().setClustering(this.m_Schema.getClustering().toString());
        this.m_Sett.getAttribute().setDescriptive(this.m_Schema.getDescriptive().toString());
        if (ResourceInfo.isLibLoaded()) {
            ClusStat.m_InitialMemory = ResourceInfo.getMemory();
        }
        ClusView view = this.m_Schema.createNormalView();
        this.m_Data = view.readData(reader, this.m_Schema);
        reader.close();
        this.m_Sett.update(this.m_Schema);
        this.getSettings().getExperimental();
        SettingsExperimental.IS_XVAL = true;
        ClusLogger.info("Has missing values: " + this.m_Schema.hasMissing());
    }

    public final Settings getSettings() {
        return this.m_Sett;
    }

    public final void initSettings(CMDLineArgs cargs) throws IOException {
        this.m_Sett.initialize(cargs, true);
    }

    private void InitLearner() {
        if (this.m_Sett.getSIT().getLearnerName().equals("KNN")) {
            ClusLogger.info("Using KNN Learner");
            this.m_Learner = new KNNLearner();
        } else {
            ClusLogger.info("Using Clus Learner");
            this.m_Learner = new ClusLearner();
        }
        this.m_Learner.init(this.m_Data, this.m_Sett);
        int mt = new Integer(this.m_Sett.getSIT().getMainTarget()) - 1;
        ClusAttrType mainTarget = this.m_Schema.getAttrType(mt);
        this.m_Learner.setMainTarget(mainTarget);
    }

    private void InitLearner(RowData data) {
        if (this.m_Sett.getSIT().getLearnerName().equals("KNN")) {
            ClusLogger.info("Using KNN Learner");
            this.m_Learner = new KNNLearner();
        } else {
            ClusLogger.info("Using Clus Learner");
            this.m_Learner = new ClusLearner();
        }
        this.m_Learner.init(data, this.m_Sett);
        int mt = new Integer(this.m_Sett.getSIT().getMainTarget()) - 1;
        ClusAttrType mainTarget = this.m_Schema.getAttrType(mt);
        this.m_Learner.setMainTarget(mainTarget);
    }

    private void InitSearchAlgorithm() {
        String search = this.m_Sett.getSIT().getSearchName();
        if (search.equals("OneTarget")) {
            this.m_Search = new OneTarget();
            ClusLogger.info("Search = single target");
        } else if (search.equals("AllTargets")) {
            this.m_Search = new AllTargets();
            ClusLogger.info("Search = full multi target");
        } else if (search.equals("GeneticSearch")) {
            this.m_Search = new GeneticSearch();
            ClusLogger.info("Search = Genetic search strategy");
        } else if (search.equals("SIT")) {
            this.m_Search = new GreedySIT();
            ClusLogger.info("Search = SIT, with stop criterion");
        } else if (search.equals("NoStop")) {
            this.m_Search = new NoStopSearch();
            ClusLogger.info("Search = SIT, no stop criterion");
        } else if (search.equals("TC")) {
            this.m_Search = new TC();
            ClusLogger.info("Search = TC");
        } else {
            System.err.println("Search strategy unknown!");
        }
        this.m_Search.setMTLearner(this.m_Learner);
        this.m_Search.setSettings(this.m_Sett);
    }

    public TargetSet search() throws ClusException {
        int mt = new Integer(this.m_Sett.getSIT().getMainTarget()) - 1;
        ClusAttrType mainTarget = this.m_Schema.getAttrType(mt);
        IntervalCollection candidates = new IntervalCollection(this.m_Sett.getAttribute().getTarget());
        TargetSet candidateSet = new TargetSet(this.m_Schema, candidates);
        return this.m_Search.search(mainTarget, candidateSet);
    }

    @Override
    public int getNbMainArgs() {
        return 1;
    }

    @Override
    public int[] getOptionArgArities() {
        return OPTION_ARITIES;
    }

    @Override
    public String[] getOptionArgs() {
        return OPTION_ARGS;
    }

    @Override
    public void showHelp() {
    }

    public void singleRun() throws ClusException {
        ClusLogger.info("Starting single run");
        this.InitLearner();
        this.InitSearchAlgorithm();
        ErrorOutput errOut = new ErrorOutput(this.m_Sett);
        try {
            errOut.writeHeader();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TargetSet trgset = this.search();
        int mt = new Integer(this.m_Sett.getSIT().getMainTarget()) - 1;
        ClusAttrType mainTarget = this.m_Schema.getAttrType(mt);
        int errorIdx = mainTarget.getArrayIndex();
        int nbFolds = 20;
        this.m_Learner.initXVal(nbFolds);
        ArrayList<RowData[]> folds = new ArrayList<RowData[]>();
        for (int f = 0; f < nbFolds; ++f) {
            folds.add(this.m_Learner.LearnModel(trgset, f));
        }
        Evaluator.getPearsonCorrelation(folds, errorIdx);
    }

    public void XValRun() throws Exception {
        ErrorOutput errOut = new ErrorOutput(this.m_Sett);
        errOut.writeHeader();
        ClusLogger.info("Starting XVal run");
        XValRandomSelection m_XValSel = null;
        int nrFolds = 26;
        try {
            m_XValSel = new XValRandomSelection(this.m_Data.getNbRows(), nrFolds);
        }
        catch (ClusException e) {
            e.printStackTrace();
        }
        int mt = new Integer(this.m_Sett.getSIT().getMainTarget()) - 1;
        ClusAttrType mainTarget = this.m_Schema.getAttrType(mt);
        int errorIdx = mainTarget.getArrayIndex();
        for (int i = 0; i < nrFolds; ++i) {
            ClusLogger.info("Outer XVAL fold " + (i + 1));
            XValSelection msel = new XValSelection(m_XValSel, i);
            RowData train = (RowData)this.m_Data.cloneData();
            RowData test = (RowData)train.select(msel);
            ClusLogger.info(test.getNbRows());
            this.InitLearner(train);
            this.InitSearchAlgorithm();
            Long d = new Date().getTime();
            TargetSet searchResult = this.search();
            this.m_Learner.setTestData(test);
            RowData[] predictions = this.m_Learner.LearnModel(searchResult);
            Long new_d = new Date().getTime();
            Long dif = new_d - d;
            double error = 0.0;
            String errorName = this.m_Sett.getSIT().getError();
            error = errorName.equals("MSE") ? Evaluator.getMSE(predictions, errorIdx) : (errorName.equals("MisclassificationError") ? Evaluator.getMisclassificationError(predictions, errorIdx) : Evaluator.getPearsonCorrelation(predictions, errorIdx));
            errOut.addFold(0, i, this.m_Learner.getName(), this.m_Search.getName(), Integer.toString(mt + 1), error, "\"" + searchResult.toString() + " \"", dif);
        }
    }

    public void YATSXValRun() throws Exception {
        ErrorOutput errOut = new ErrorOutput(this.m_Sett);
        errOut.writeHeader();
        ClusLogger.info("Starting XVal run");
        XValRandomSelection m_XValSel = null;
        int nrFolds = 500;
        try {
            m_XValSel = new XValRandomSelection(this.m_Data.getNbRows(), nrFolds);
        }
        catch (ClusException e) {
            e.printStackTrace();
        }
        int mt = new Integer(this.m_Sett.getSIT().getMainTarget()) - 1;
        ClusAttrType mainTarget = this.m_Schema.getAttrType(mt);
        int errorIdx = mainTarget.getArrayIndex();
        for (int i = 0; i < nrFolds; ++i) {
            int j;
            ClusLogger.info("Outer XVAL fold " + (i + 1));
            XValSelection msel = new XValSelection(m_XValSel, i);
            RowData train = (RowData)this.m_Data.cloneData();
            RowData test = (RowData)train.select(msel);
            this.InitLearner(train);
            this.InitSearchAlgorithm();
            Long d = new Date().getTime();
            TargetSet searchResult = this.search();
            this.m_Learner.setTestData(test);
            RowData[] predictions = this.m_Learner.LearnModel(searchResult);
            RowData pred = predictions[1];
            RowData xtr_train = test.deepCloneData();
            for (int t = 0; t < pred.getNbRows(); ++t) {
                DataTuple tp = pred.getTuple(t);
                double dp = mainTarget.getNumeric(tp);
                DataTuple clone = xtr_train.getTuple(t);
                ((NumericAttrType)mainTarget).setNumeric(clone, dp);
            }
            RowData new_train = new RowData(train.getSchema(), train.getNbRows() + xtr_train.getNbRows());
            for (j = 0; j < train.getNbRows(); ++j) {
                new_train.setTuple(train.getTuple(j), j);
            }
            for (j = train.getNbRows(); j < train.getNbRows() + xtr_train.getNbRows(); ++j) {
                new_train.setTuple(xtr_train.getTuple(j - train.getNbRows()), j);
            }
            this.InitLearner(xtr_train);
            this.m_Learner.setTestData(test);
            Long new_d = new Date().getTime();
            Long dif = new_d - d;
            double error = 0.0;
            String errorName = this.m_Sett.getSIT().getError();
            if (errorName.equals("RME")) {
                error = Evaluator.getRelativeError(predictions, errorIdx);
                ClusLogger.info(error);
            } else {
                error = errorName.equals("MSE") ? Evaluator.getMSE(predictions, errorIdx) : (errorName.equals("MisclassificationError") ? Evaluator.getMisclassificationError(predictions, errorIdx) : Evaluator.getPearsonCorrelation(predictions, errorIdx));
            }
            errOut.addFold(0, i, this.m_Learner.getName(), this.m_Search.getName(), Integer.toString(mt + 1), error, "\"" + searchResult.toString() + " \"", dif);
        }
    }

    public static void main(String[] args) throws Exception {
        Sit sit = Sit.getInstance();
        Settings sett = sit.getSettings();
        CMDLineArgs cargs = new CMDLineArgs(sit);
        cargs.process(args);
        if (cargs.getNbMainArgs() == 0) {
            sit.showHelp();
            ClusLogger.info();
            ClusLogger.info("Expected main argument");
            System.exit(0);
        }
        if (cargs.allOK()) {
            sett.getGeneric().setDate(new Date());
            sett.getGeneric().setAppName(cargs.getMainArg(0));
            sit.initSettings(cargs);
        } else {
            System.err.println("Arguments not ok?!");
        }
        sit.initialize();
        sit.m_SearchSelection = 1;
        sit.XValRun();
        ClusLogger.info("Finished");
    }
}

