/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import si.ijs.kt.clus.error.MSError;
import si.ijs.kt.clus.main.settings.Settings;

public class ErrorOutput {
    protected PrintWriter m_Writer;
    protected Settings m_Sett;

    public ErrorOutput(Settings sett) {
        this.m_Sett = sett;
        try {
            this.m_Writer = this.m_Sett.getGeneric().getFileAbsoluteWriter(this.m_Sett.getGeneric().getAppName() + ".err");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void writeHeader() throws IOException {
        this.m_Writer.println("@relation experiment");
        this.m_Writer.println("@attribute Dataset {" + this.m_Sett.getData().getDataFile() + "}");
        this.m_Writer.println("@attribute Run numeric");
        this.m_Writer.println("@attribute Fold numeric");
        this.m_Writer.println("@attribute Learner string");
        this.m_Writer.println("@attribute Search string");
        this.m_Writer.println("@attribute MainTarget numeric");
        this.m_Writer.print("@attribute ");
        String errName = this.m_Sett.getSIT().getError();
        this.m_Writer.print(errName + " numeric\n");
        this.m_Writer.println("@attribute SupportTargets string");
        this.m_Writer.println("@attribute Runtime numeric");
        this.m_Writer.println("@data");
        this.m_Writer.flush();
    }

    public void addFold(int run, int fold, String learner, String search, String mt, double error, String sts, Long dif) {
        this.m_Writer.println(this.m_Sett.getData().getDataFile() + "," + run + "," + fold + "," + learner + "," + search + "," + mt + "," + error + "," + sts + "," + (double)dif.longValue() / 1000.0);
        this.m_Writer.flush();
    }

    public void addFoldAllErrors(int run, int fold, String learner, String search, String mt, MSError error, String sts, Long dif) {
        this.m_Writer.print(this.m_Sett.getData().getDataFile() + "," + run + "," + fold + "," + learner + "," + search + "," + mt + ",");
        for (int i = 0; i < error.getDimension(); ++i) {
        }
        this.m_Writer.print(error.getModelError() + ",");
        this.m_Writer.print(sts + "," + (double)dif.longValue() / 1000.0);
        this.m_Writer.println();
        this.m_Writer.flush();
    }
}

