/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.jgap.ICloneHandler;
import org.jgap.ICompareToHandler;
import org.jgap.IGeneticOperatorConstraint;
import org.jgap.IHandler;
import org.jgap.IInitializer;
import org.jgap.IJGAPFactory;
import org.jgap.RandomGenerator;
import org.jgap.impl.DefaultCloneHandler;
import org.jgap.impl.DefaultCompareToHandler;
import org.jgap.impl.DefaultInitializer;
import org.jgap.impl.StockRandomGenerator;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;
import org.jgap.util.LRUCache;

public class JGAPFactory
implements IJGAPFactory,
Serializable,
ICloneable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.18 $";
    private List m_parameters;
    private List m_cloneHandlers;
    private List m_initer = new Vector();
    private List m_compareHandlers;
    private ICloneHandler m_defaultCloneHandler;
    private IInitializer m_defaultIniter;
    private ICompareToHandler m_defaultComparer;
    private IGeneticOperatorConstraint m_geneticOpConstraint;
    private transient LRUCache m_cache = new LRUCache(50);
    private boolean m_useCaching;

    public JGAPFactory(boolean a_useCaching) {
        this.m_useCaching = a_useCaching;
        this.m_cloneHandlers = new Vector();
        this.m_compareHandlers = new Vector();
        this.m_defaultCloneHandler = new DefaultCloneHandler();
        this.m_defaultIniter = new DefaultInitializer();
        this.m_defaultComparer = new DefaultCompareToHandler();
    }

    public void setParameters(Collection a_parameters) {
        this.m_parameters = new Vector(a_parameters);
    }

    public Collection getParameters() {
        return this.m_parameters;
    }

    public RandomGenerator createRandomGenerator() {
        return new StockRandomGenerator();
    }

    public int registerCloneHandler(ICloneHandler a_cloneHandler) {
        this.m_cloneHandlers.add(a_cloneHandler);
        return this.m_cloneHandlers.size() - 1;
    }

    public ICloneHandler removeCloneHandler(int a_index) {
        return (ICloneHandler)this.m_cloneHandlers.remove(a_index);
    }

    public ICloneHandler getCloneHandlerFor(Object a_obj, Class a_classToClone) {
        return (ICloneHandler)this.findHandlerFor(a_obj, a_classToClone, this.m_cloneHandlers, this.m_defaultCloneHandler, "clone");
    }

    public int registerInitializer(IInitializer a_chromIniter) {
        this.m_initer.add(a_chromIniter);
        return this.m_initer.size() - 1;
    }

    public IInitializer removeInitializer(int a_index) {
        return (IInitializer)this.m_initer.remove(a_index);
    }

    public IInitializer getInitializerFor(Object a_obj, Class a_class) {
        return (IInitializer)this.findHandlerFor(a_obj, a_class, this.m_initer, this.m_defaultIniter, "init");
    }

    public void setGeneticOperatorConstraint(IGeneticOperatorConstraint a_constraint) {
        this.m_geneticOpConstraint = a_constraint;
    }

    public IGeneticOperatorConstraint getGeneticOperatorConstraint() {
        return this.m_geneticOpConstraint;
    }

    public ICompareToHandler getCompareToHandlerFor(Object a_obj, Class a_classToCompareTo) {
        return (ICompareToHandler)this.findHandlerFor(a_obj, a_classToCompareTo, this.m_compareHandlers, this.m_defaultComparer, "compare");
    }

    public int registerCompareToHandler(ICompareToHandler a_compareToHandler) {
        this.m_compareHandlers.add(a_compareToHandler);
        return this.m_compareHandlers.size() - 1;
    }

    public ICompareToHandler removeCompareToHandler(int a_index) {
        return (ICompareToHandler)this.m_compareHandlers.remove(a_index);
    }

    protected IHandler findHandlerFor(Object a_obj, Class a_class, List a_list, IHandler a_default, String a_listID) {
        String key = null;
        if (this.m_useCaching) {
            String key1 = a_class == null ? "null" : a_class.getName();
            String key2 = a_obj == null ? "null" : a_obj.getClass().getName();
            key = a_listID + "/" + key1 + "/" + key2;
            Object handler = this.m_cache.get(key);
            if (handler != null) {
                return (IHandler)handler;
            }
        }
        IHandler result = null;
        for (IHandler initer : a_list) {
            if (!initer.isHandlerFor(a_obj, a_class)) continue;
            result = initer;
            break;
        }
        if (result == null && a_default != null && a_default.isHandlerFor(a_obj, a_class)) {
            result = a_default;
        }
        if (this.m_useCaching && result != null) {
            this.m_cache.put(key, result);
        }
        return result;
    }

    public boolean isUseCaching() {
        return this.m_useCaching;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cex) {
            throw new CloneException(cex);
        }
    }

    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        JGAPFactory other = (JGAPFactory)a_other;
        return new CompareToBuilder().append(this.m_cloneHandlers.toArray(), other.m_cloneHandlers.toArray()).append(this.m_initer.toArray(), other.m_initer.toArray()).append(this.m_compareHandlers.toArray(), other.m_compareHandlers.toArray()).append(this.m_defaultCloneHandler, other.m_defaultCloneHandler).append(this.m_defaultComparer, other.m_defaultComparer).append(this.m_geneticOpConstraint, other.m_geneticOpConstraint).toComparison();
    }
}

