/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jgap.IApplicationData;
import org.jgap.ICloneHandler;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class DefaultCloneHandler
implements ICloneHandler,
ICloneable,
Serializable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.14 $";

    public boolean isHandlerFor(Object a_obj, Class a_clazz) {
        Class<?> clazz;
        if (a_clazz == null) {
            if (a_obj == null) {
                return false;
            }
            clazz = a_obj.getClass();
        } else {
            clazz = a_clazz;
        }
        if (IApplicationData.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (ICloneable.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Cloneable.class.isAssignableFrom(clazz)) {
            boolean result;
            try {
                Method m = clazz.getMethod("clone", new Class[0]);
                boolean modified = false;
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                    modified = true;
                }
                result = m.isAccessible();
                if (modified) {
                    m.setAccessible(false);
                }
            }
            catch (Exception ex) {
                return false;
            }
            return result;
        }
        return false;
    }

    public Object perform(Object a_objToClone, Class a_class, Object a_params) {
        Class<?> clazz;
        if (a_class == null) {
            if (a_objToClone == null) {
                return null;
            }
            clazz = a_objToClone.getClass();
        } else {
            clazz = a_class;
        }
        if (ICloneable.class.isAssignableFrom(clazz)) {
            try {
                return ((ICloneable)a_objToClone).clone();
            }
            catch (CloneException cex) {
                throw new IllegalStateException(cex);
            }
        }
        if (IApplicationData.class.isAssignableFrom(a_objToClone.getClass())) {
            try {
                return ((IApplicationData)a_objToClone).clone();
            }
            catch (CloneNotSupportedException cex) {
                throw new IllegalStateException(cex);
            }
        }
        try {
            Method cloneMethod = a_objToClone.getClass().getMethod("clone", new Class[0]);
            cloneMethod.setAccessible(true);
            return cloneMethod.invoke(a_objToClone, new Object[0]);
        }
        catch (InvocationTargetException iex) {
            throw new IllegalStateException(iex.getTargetException());
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Object clone() {
        return new DefaultCloneHandler();
    }

    public int compareTo(Object a_other) {
        if (a_other.getClass().equals(this.getClass())) {
            return 0;
        }
        return this.getClass().getName().compareTo(a_other.getClass().getName());
    }
}

