/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.data.config;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jgap.data.config.ConfigException;

public class ConfigFileReader {
    private static final String CVS_REVISION = "$Revision: 1.6 $";
    private String m_fileName;
    private Properties m_props = new Properties();
    private String m_ns;
    private static ConfigFileReader m_cfReader;

    public static ConfigFileReader instance() {
        if (m_cfReader == null) {
            m_cfReader = new ConfigFileReader();
        }
        return m_cfReader;
    }

    private ConfigFileReader() {
    }

    public String getValue(String a_name) {
        String tmpName = this.m_ns + "." + a_name;
        String val = this.m_props.getProperty(tmpName);
        return val;
    }

    public List getValues(String a_name) {
        String val = "";
        boolean done = false;
        String tmpName = "";
        int idx = 0;
        List<String> values = Collections.synchronizedList(new ArrayList());
        while (!done) {
            tmpName = this.m_ns + "." + a_name + "[" + idx + "]";
            val = this.m_props.getProperty(tmpName);
            if (val == null) {
                done = true;
                continue;
            }
            values.add(val);
            ++idx;
        }
        if (idx == 0) {
            return null;
        }
        return values;
    }

    public void setNS(String a_ns) {
        this.m_ns = a_ns;
    }

    public void setFileName(String a_fileName) throws ConfigException {
        this.m_fileName = a_fileName;
        this.load();
    }

    private void load() throws ConfigException {
        try {
            this.m_props.load(new FileInputStream(this.m_fileName));
        }
        catch (Exception ex) {
            String dir = new File(".").getAbsolutePath();
            throw new ConfigException("Error reading Config file " + this.m_fileName + " in directory " + dir);
        }
    }
}

