/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.Comparator;
import org.jgap.Configuration;
import org.jgap.IChromosome;
import org.jgap.INaturalSelector;
import org.jgap.data.config.Configurable;

public abstract class NaturalSelector
implements INaturalSelector,
Configurable {
    private static final String CVS_REVISION = "$Revision: 1.29 $";
    protected Configuration m_config;

    public NaturalSelector() {
    }

    public NaturalSelector(Configuration a_config) {
        this.m_config = a_config;
    }

    public Configuration getConfiguration() {
        return this.m_config;
    }

    protected abstract void add(IChromosome var1);

    public class FitnessAgeValueComparator
    implements Comparator,
    Serializable {
        public int compare(Object first, Object second) {
            IChromosome chrom1 = (IChromosome)first;
            IChromosome chrom2 = (IChromosome)second;
            if (NaturalSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom2, chrom1)) {
                return 1;
            }
            if (NaturalSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom1, chrom2)) {
                return -1;
            }
            if (chrom1.getAge() < chrom2.getAge()) {
                return -1;
            }
            if (chrom1.getAge() > chrom2.getAge()) {
                return 1;
            }
            return 0;
        }
    }

    public class AgeFitnessValueComparator
    implements Comparator,
    Serializable {
        public int compare(Object first, Object second) {
            IChromosome chrom1 = (IChromosome)first;
            IChromosome chrom2 = (IChromosome)second;
            if (chrom1.getAge() > chrom2.getAge()) {
                return -1;
            }
            if (chrom1.getAge() < chrom2.getAge()) {
                return 1;
            }
            if (NaturalSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom2, chrom1)) {
                return 1;
            }
            if (NaturalSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom1, chrom2)) {
                return -1;
            }
            return 0;
        }
    }

    public class FitnessValueComparator
    implements Comparator,
    Serializable {
        public int compare(Object first, Object second) {
            IChromosome chrom1 = (IChromosome)first;
            IChromosome chrom2 = (IChromosome)second;
            if (NaturalSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom2, chrom1)) {
                return 1;
            }
            if (NaturalSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom1, chrom2)) {
                return -1;
            }
            return 0;
        }
    }
}

