/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.List;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.IBreeder;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.Population;

public abstract class BreederBase
implements IBreeder {
    private static final String CVS_REVISION = "$Revision: 1.7 $";

    protected Population applyNaturalSelectors(Configuration a_config, Population a_pop, boolean a_processBeforeGeneticOperators) {
        try {
            int selectorSize = a_config.getNaturalSelectorsSize(a_processBeforeGeneticOperators);
            if (selectorSize > 0) {
                int population_size = a_config.getPopulationSize();
                population_size = (int)Math.round((double)population_size * a_config.getSelectFromPrevGen());
                Population new_population = new Population(a_config, population_size);
                for (int i = 0; i < selectorSize; ++i) {
                    NaturalSelector selector = a_config.getNaturalSelector(a_processBeforeGeneticOperators, i);
                    int single_selection_size = i == selectorSize - 1 && i > 0 ? population_size - new_population.size() : population_size / selectorSize;
                    selector.select(single_selection_size, a_pop, new_population);
                    selector.empty();
                }
                return new_population;
            }
            return a_pop;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex);
        }
    }

    protected void applyGeneticOperators(Configuration a_config, Population a_pop) {
        List geneticOperators = a_config.getGeneticOperators();
        for (GeneticOperator operator : geneticOperators) {
            operator.operate(a_pop, a_pop.getChromosomes());
        }
    }

    public abstract Object clone();

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        return this.getClass().getName().compareTo(a_other.getClass().getName());
    }
}

