/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.IBusinessKey;
import org.jgap.ICompareToHandler;
import org.jgap.IGeneConstraintChecker;
import org.jgap.InvalidConfigurationException;
import org.jgap.util.StringKit;

public abstract class BaseGene
implements Gene,
IBusinessKey {
    private static final String CVS_REVISION = "$Revision: 1.27 $";
    public static final double DELTA = 1.0E-7;
    private double m_energy;
    private Object m_applicationData;
    private boolean m_compareAppData;
    private Configuration m_configuration;
    public static final String S_APPLICATION_DATA = "Application data";
    private IGeneConstraintChecker m_geneAlleleChecker;

    public BaseGene(Configuration a_configuration) throws InvalidConfigurationException {
        if (a_configuration == null) {
            throw new InvalidConfigurationException("Configuration must not be null!");
        }
        this.m_configuration = a_configuration;
    }

    public Object getAllele() {
        return this.getInternalValue();
    }

    public int hashCode() {
        if (this.getInternalValue() == null) {
            return -79;
        }
        return this.getInternalValue().hashCode();
    }

    public void cleanup() {
    }

    public String toString() {
        String representation = this.getInternalValue() == null ? "null" : this.getInternalValue().toString();
        String appData = this.getApplicationData() != null ? this.getApplicationData().toString() : "null";
        representation = representation + ", Application data:" + appData;
        return representation;
    }

    public int size() {
        return 1;
    }

    public boolean equals(Object a_other) {
        try {
            int result = this.compareTo(a_other);
            if (result == 0) {
                if (this.isCompareApplicationData()) {
                    Gene otherGene = (Gene)a_other;
                    int resultAppData = this.compareApplicationData(this.getApplicationData(), otherGene.getApplicationData());
                    return resultAppData == 0;
                }
                return true;
            }
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected abstract Object getInternalValue();

    public double getEnergy() {
        return this.m_energy;
    }

    public void setEnergy(double a_energy) {
        this.m_energy = a_energy;
    }

    public void setApplicationData(Object a_newData) {
        this.m_applicationData = a_newData;
    }

    public Object getApplicationData() {
        return this.m_applicationData;
    }

    public void setCompareApplicationData(boolean a_doCompare) {
        this.m_compareAppData = a_doCompare;
    }

    public boolean isCompareApplicationData() {
        return this.m_compareAppData;
    }

    protected int compareApplicationData(Object a_appdata1, Object a_appdata2) {
        if (a_appdata1 == null) {
            if (a_appdata2 != null) {
                return -1;
            }
            return 0;
        }
        if (a_appdata2 == null) {
            return 1;
        }
        ICompareToHandler handler = this.getConfiguration().getJGAPFactory().getCompareToHandlerFor(a_appdata1, a_appdata2.getClass());
        if (handler != null) {
            try {
                return (Integer)handler.perform(a_appdata1, null, a_appdata2);
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
        return 0;
    }

    public void setConstraintChecker(IGeneConstraintChecker a_constraintChecker) {
        this.m_geneAlleleChecker = a_constraintChecker;
    }

    public IGeneConstraintChecker getConstraintChecker() {
        return this.m_geneAlleleChecker;
    }

    public Gene newGene() {
        Gene result = this.newGeneInternal();
        result.setConstraintChecker(this.getConstraintChecker());
        result.setEnergy(this.getEnergy());
        result.setApplicationData(this.getApplicationData());
        return result;
    }

    protected abstract Gene newGeneInternal();

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public String getBusinessKey() {
        Object allele = this.getAllele();
        String result = this.getClass().getName() + ":";
        if (allele == null) {
            return result;
        }
        return result + allele.toString();
    }

    protected String encode(String a_string) {
        return StringKit.encode(a_string);
    }

    protected String decode(String a_string) {
        return StringKit.decode(a_string);
    }
}

