/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.SimpleBlas;

public class Solve {
    public static DoubleMatrix solve(DoubleMatrix A, DoubleMatrix B) {
        A.assertSquare();
        DoubleMatrix X = B.dup();
        int[] ipiv = new int[B.rows];
        SimpleBlas.gesv(A.dup(), ipiv, X);
        return X;
    }

    public static DoubleMatrix solveSymmetric(DoubleMatrix A, DoubleMatrix B) {
        A.assertSquare();
        DoubleMatrix X = B.dup();
        int[] ipiv = new int[B.rows];
        SimpleBlas.sysv('U', A.dup(), ipiv, X);
        return X;
    }

    public static DoubleMatrix solvePositive(DoubleMatrix A, DoubleMatrix B) {
        A.assertSquare();
        DoubleMatrix X = B.dup();
        SimpleBlas.posv('U', A.dup(), X);
        return X;
    }

    public static DoubleMatrix solveLeastSquares(DoubleMatrix A, DoubleMatrix B) {
        if (B.rows < A.columns) {
            DoubleMatrix X = DoubleMatrix.concatVertically(B, new DoubleMatrix(A.columns - B.rows, B.columns));
            SimpleBlas.gelsd(A.dup(), X);
            return X;
        }
        DoubleMatrix X = B.dup();
        SimpleBlas.gelsd(A.dup(), X);
        return X.getRange(0, A.columns, 0, B.columns);
    }

    public static DoubleMatrix pinv(DoubleMatrix A) {
        return Solve.solveLeastSquares(A, DoubleMatrix.eye(A.rows));
    }

    public static FloatMatrix solve(FloatMatrix A, FloatMatrix B) {
        A.assertSquare();
        FloatMatrix X = B.dup();
        int[] ipiv = new int[B.rows];
        SimpleBlas.gesv(A.dup(), ipiv, X);
        return X;
    }

    public static FloatMatrix solveSymmetric(FloatMatrix A, FloatMatrix B) {
        A.assertSquare();
        FloatMatrix X = B.dup();
        int[] ipiv = new int[B.rows];
        SimpleBlas.sysv('U', A.dup(), ipiv, X);
        return X;
    }

    public static FloatMatrix solvePositive(FloatMatrix A, FloatMatrix B) {
        A.assertSquare();
        FloatMatrix X = B.dup();
        SimpleBlas.posv('U', A.dup(), X);
        return X;
    }

    public static FloatMatrix solveLeastSquares(FloatMatrix A, FloatMatrix B) {
        if (B.rows < A.columns) {
            FloatMatrix X = FloatMatrix.concatVertically(B, new FloatMatrix(A.columns - B.rows, B.columns));
            SimpleBlas.gelsd(A.dup(), X);
            return X;
        }
        FloatMatrix X = B.dup();
        SimpleBlas.gelsd(A.dup(), X);
        return X.getRange(0, A.columns, 0, B.columns);
    }

    public static FloatMatrix pinv(FloatMatrix A) {
        return Solve.solveLeastSquares(A, FloatMatrix.eye(A.rows));
    }
}

