import { CustomResource, Duration, aws_iam as iam, aws_lambda as lambda } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface BashExecFunctionProps {
    /**
     * The path of the shell script to be executed.
     *
     * @stability stable
     */
    readonly script: string;
    /**
     * The path of your custom dockerfile.
     *
     * @stability stable
     */
    readonly dockerfile?: string;
    /**
     * Lambda environment variables.
     *
     * @stability stable
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     *
     * Because the execution time affects cost, set this value based on the function's expected execution time.
     *
     * @default - Duration.seconds(60)
     * @stability stable
     */
    readonly timeout?: Duration;
    /**
     * Custom lambda execution role.
     *
     * @default - auto generated role.
     * @stability stable
     */
    readonly role?: iam.IRole;
}
/**
 * @stability stable
 */
export interface RunOps {
    /**
     * whether to run the lambda function again on the provider update.
     *
     * @default false;
     * @stability stable
     */
    readonly runOnUpdate?: boolean;
}
/**
 * @stability stable
 */
export declare class BashExecFunction extends Construct {
    /**
     * @stability stable
     */
    readonly handler: lambda.DockerImageFunction;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: BashExecFunctionProps);
    /**
     * @stability stable
     */
    run(ops?: RunOps): CustomResource;
}
