/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
/**
 * Options for python sample code generation
 */
export interface PythonSampleCodeOptions {
    /**
     * The package name which exports the OpenApiGatewayLambdaApi construct (ie this pdk package!)
     */
    readonly openApiGatewayPackageName: string;
    /**
     * The name of the generated python client package
     */
    readonly pythonClientPackageName: string;
    /**
     * Whether or not to generate sample code
     */
    readonly sampleCode?: boolean;
    /**
     * Directory where the parsed spec is output
     */
    readonly specDir: string;
    /**
     * Name of the parsed spec file
     */
    readonly parsedSpecFileName: string;
    /**
     * Name of the module
     */
    readonly moduleName: string;
}
/**
 * Return a map of file name to contents for the sample python source code
 */
export declare const getPythonSampleSource: (options: PythonSampleCodeOptions) => {
    [fileName: string]: string;
};
