# ShellcodeFormatter
Transforms a binary file into a specified shellcode format
## Help
```
usage: ShellcodeFormatter.py [-h] -f {csharp,powershell,python,vba,java,c,bash,ruby,perl,go,rust} [-o OUTFILE] [infile]

positional arguments:
  infile

optional arguments:
  -h, --help            show this help message and exit
  -f {csharp,powershell,python,vba,java,c,bash,ruby,perl,go,rust}
                        Output format
  -o OUTFILE, --outfile OUTFILE
                        Output file
```

## Supported Output Formats
- C# (csharp)
- Powershell
- Python
- VBA
- Java
- C
- Bash
- Ruby
- Perl
- Go
- Rust

## Examples

### C#
```
byte[] buf = new byte[ 115 ] {
0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
0x11,0x12,0x13
};
```
### Powershell
```
[Byte[]] $buf = 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13
```
### Python
```
buf = b''
buf += b'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'
buf += b'\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20'
buf += b'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'
buf += b'\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20'
buf += b'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'
buf += b'\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20'
buf += b'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'
buf += b'\x11\x12\x13'
```
### VBA
```
Dim buf as Variant
buf = Array(001, 002, 003, 004, 005, 006, 007, 008, 009, 010, 011, 012, 013, 014, 015, 016)
buf = Split(Join(buf, ",") & "," & Join(Array(017, 018, 019, 020, 021, 022, 023, 024, 025, 026, 027, 028, 029, 030, 031, 032), ","), ",")
buf = Split(Join(buf, ",") & "," & Join(Array(001, 002, 003, 004, 005, 006, 007, 008, 009, 010, 011, 012, 013, 014, 015, 016), ","), ",")
buf = Split(Join(buf, ",") & "," & Join(Array(017, 018, 019, 020, 021, 022, 023, 024, 025, 026, 027, 028, 029, 030, 031, 032), ","), ",")
buf = Split(Join(buf, ",") & "," & Join(Array(001, 002, 003, 004, 005, 006, 007, 008, 009, 010, 011, 012, 013, 014, 015, 016), ","), ",")
buf = Split(Join(buf, ",") & "," & Join(Array(017, 018, 019, 020, 021, 022, 023, 024, 025, 026, 027, 028, 029, 030, 031, 032), ","), ",")
buf = Split(Join(buf, ",") & "," & Join(Array(001, 002, 003, 004, 005, 006, 007, 008, 009, 010, 011, 012, 013, 014, 015, 016), ","), ",")
buf = Split(Join(buf, ",") & "," & Join(Array(017, 018, 019), ","), ",")
```
### Java
```
byte[] buf = new byte[]
{
        (byte) 0x01,(byte) 0x02,(byte) 0x03,(byte) 0x04,(byte) 0x05,(byte) 0x06,(byte) 0x07,(byte) 0x08,
        (byte) 0x09,(byte) 0x0a,(byte) 0x0b,(byte) 0x0c,(byte) 0x0d,(byte) 0x0e,(byte) 0x0f,(byte) 0x10,
        (byte) 0x11,(byte) 0x12,(byte) 0x13,(byte) 0x14,(byte) 0x15,(byte) 0x16,(byte) 0x17,(byte) 0x18,
        (byte) 0x19,(byte) 0x1a,(byte) 0x1b,(byte) 0x1c,(byte) 0x1d,(byte) 0x1e,(byte) 0x1f,(byte) 0x20,
        (byte) 0x01,(byte) 0x02,(byte) 0x03,(byte) 0x04,(byte) 0x05,(byte) 0x06,(byte) 0x07,(byte) 0x08,
        (byte) 0x09,(byte) 0x0a,(byte) 0x0b,(byte) 0x0c,(byte) 0x0d,(byte) 0x0e,(byte) 0x0f,(byte) 0x10,
        (byte) 0x11,(byte) 0x12,(byte) 0x13,(byte) 0x14,(byte) 0x15,(byte) 0x16,(byte) 0x17,(byte) 0x18,
        (byte) 0x19,(byte) 0x1a,(byte) 0x1b,(byte) 0x1c,(byte) 0x1d,(byte) 0x1e,(byte) 0x1f,(byte) 0x20,
        (byte) 0x01,(byte) 0x02,(byte) 0x03,(byte) 0x04,(byte) 0x05,(byte) 0x06,(byte) 0x07,(byte) 0x08,
        (byte) 0x09,(byte) 0x0a,(byte) 0x0b,(byte) 0x0c,(byte) 0x0d,(byte) 0x0e,(byte) 0x0f,(byte) 0x10,
        (byte) 0x11,(byte) 0x12,(byte) 0x13,(byte) 0x14,(byte) 0x15,(byte) 0x16,(byte) 0x17,(byte) 0x18,
        (byte) 0x19,(byte) 0x1a,(byte) 0x1b,(byte) 0x1c,(byte) 0x1d,(byte) 0x1e,(byte) 0x1f,(byte) 0x20,
        (byte) 0x01,(byte) 0x02,(byte) 0x03,(byte) 0x04,(byte) 0x05,(byte) 0x06,(byte) 0x07,(byte) 0x08,
        (byte) 0x09,(byte) 0x0a,(byte) 0x0b,(byte) 0x0c,(byte) 0x0d,(byte) 0x0e,(byte) 0x0f,(byte) 0x10,
        (byte) 0x11,(byte) 0x12,(byte) 0x13
};
```
### C
```
unsigned char buf[] = 
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20"
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20"
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20"
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10"
"\x11\x12\x13";
```
### Bash
```
export buf=\
$'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'\
$'\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20'\
$'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'\
$'\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20'\
$'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'\
$'\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20'\
$'\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10'\
$'\x11\x12\x13'
```
### Ruby
```
buf = 
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" +
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20" +
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" +
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20" +
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" +
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20" +
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" +
"\x11\x12\x13"
```
### Perl
```
my $buf = 
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" .
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20" .
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" .
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20" .
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" .
"\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20" .
"\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10" .
"\x11\x12\x13"
```
### Go
```
buf := []byte{
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13}
```
### Rust
```
let buf = [
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
        0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
        0x11,0x12,0x13];
```

## Custom Formats
The `definitions.py` file contains the existing definitions, this can be added to in the following format:

### C# Example:
```
    "csharp": ShellcodeDefinition(
        name="csharp",
        byte_format="0xff",
        byte_separator=",",
        bytes_per_line=16,
        line_format="~~BYTES~~,\n",
        last_line_format="~~BYTES~~\n"
        output_format="byte[] buf = new byte[ ~~BYTE_COUNT~~ ] { \n~~LINES~~};",
    ),
```

- name: Simply the name to be used as a reference and command line parameter
- byte_format: How the raw binary should be represented. Any prefix or suffix characters will be left as-is
    - `ff` (Lowercase hex) - This is used in the C# definition, the `0x` prefix is preserved
    - `FF` (Uppercase hex)
    - `255` (Decimal)
    - `377` (Octal)
- byte_separator: The character(s) to be used as a separator between formatted bytes. This can be an empty string, whitespace is preserved
- bytes_per_line: Simple an integer number of bytes to be allowed on a particular line. Mostly to aid readability.
- line_format: Once the bytes have been combined with their `byte_format` and `byte_separator`, they are combined into a single string and used to replace the `~~BYTES~~` string
    - `~~BYTES~~` All the bytes associated with a single line, and their separator combined into a string
- last_line_format and first_line_format are the same as the line_format, but only trigger on the first or last line. This can be useful for avoiding trailing commas.
- output_format: This is where everything comes together, all the lines are combined into a single string and used to replace the `~~LINES~~` string.
    - `~~LINES~~` All the lines of bytes, formatted with the `line_format` and combined into a single string
    - `~~BYTE_COUNT~~` The count of raw bytes of the input shellcode. Required by some languages when creating an array of a specific size


## Using ShellcodeFormatter as a Library Example
```
from ShellcodeFormatter import ShellcodeTransformer, ShellcodeDefinitions

input_bytes = b'\x01\x02\x03\x04\x05'

definition = ShellcodeDefinitions.get_definition('csharp')

output = ShellcodeTransformer(definition).transform_shellcode(input_bytes)

print(output)
```