/**
 * Django Image Uploader Widget - An image uploader widget for django.
 * @version v0.1.0
 * @author Eduardo Oliveira (EduardoJM) <eduardo_y05@outlook.com>.
 * @link https://github.com/inventare/django-image-uploader-widget
 * 
 * Licensed under the MIT License (https://github.com/inventare/django-image-uploader-widget/blob/main/LICENSE).
 */

"use strict";function _createForOfIteratorHelper(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=_unsupportedIterableToArray(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,t=function(){};return{s:t,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:t}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,a=!0,l=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return a=e.done,e},e:function(e){l=!0,i=e},f:function(){try{a||null==n.return||n.return()}finally{if(l)throw i}}}}function _unsupportedIterableToArray(e,t){if(e){if("string"==typeof e)return _arrayLikeToArray(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Map"===(n="Object"===n&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?_arrayLikeToArray(e,t):void 0}}function _arrayLikeToArray(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function _defineProperties(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function _createClass(e,t,n){return t&&_defineProperties(e.prototype,t),n&&_defineProperties(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function _defineProperty(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var ImageUploaderInline=function(){function t(e){var i=this;_classCallCheck(this,t),_defineProperty(this,"element",void 0),_defineProperty(this,"inlineGroup",void 0),_defineProperty(this,"inlineFormset",void 0),_defineProperty(this,"tempFileInput",null),_defineProperty(this,"next",0),_defineProperty(this,"dragging",!1),_defineProperty(this,"onDrop",function(e){if(e.preventDefault(),i.dragging=!1,i.element.classList.remove("drop-zone"),e.dataTransfer.files.length){var t,n=_createForOfIteratorHelper(e.dataTransfer.files);try{for(n.s();!(t=n.n()).done;){var r=t.value;i.addFile(r)}}catch(e){n.e(e)}finally{n.f()}}}),_defineProperty(this,"onDragEnter",function(){i.dragging=!0,i.element.classList.add("drop-zone")}),_defineProperty(this,"onDragOver",function(e){e&&e.preventDefault()}),_defineProperty(this,"onDragLeave",function(e){e.relatedTarget&&e.relatedTarget.closest(".iuw-inline-root")===i.element||(i.dragging=!1,i.element.classList.remove("drop-zone"))}),_defineProperty(this,"onRelatedItemClick",function(e){if(e&&e.target){var t=e.target,n=t.closest(".inline-related");if(t.closest(".iuw-delete-icon"))return n.getAttribute("data-raw")?(n.classList.add("deleted"),n.querySelector("input[type=checkbox]").checked=!0):n.parentElement.removeChild(n),void i.updateEmpty();n=n.querySelector("input[type=file]");e.target!==n&&n.click()}}),_defineProperty(this,"onFileInputChange",function(e){var t=e.target;"INPUT"===t.tagName&&((e=t.files).length<=0||(t=t.closest(".inline-related").querySelector("img"))&&(t.src=URL.createObjectURL(e[0])))}),_defineProperty(this,"onTempFileChange",function(){var e=i.tempFileInput.files;e.length<=0||(i.tempFileInput.removeEventListener("change",i.onTempFileChange),i.tempFileInput.parentElement.removeChild(i.tempFileInput),i.tempFileInput=null,i.addFile(e[0]))}),_defineProperty(this,"onChooseAddImageAreaClick",function(){i.tempFileInput||(i.tempFileInput=document.createElement("input"),i.tempFileInput.setAttribute("type","file"),i.tempFileInput.classList.add("temp_file"),i.tempFileInput.setAttribute("accept","image/*"),i.tempFileInput.style.display="none",i.tempFileInput.addEventListener("change",i.onTempFileChange),i.element.appendChild(i.tempFileInput)),i.tempFileInput.click()}),this.element=e,this.inlineGroup=e.closest(".inline-group"),this.inlineFormset=JSON.parse(this.inlineGroup.getAttribute("data-inline-formset")),this.updateEmpty(),this.updateAllIndexes(),Array.from(this.element.querySelectorAll(".inline-related")).forEach(function(e){return i.adjustInlineRelated(e)}),Array.from(this.element.querySelectorAll(".iuw-add-image-btn, .iuw-empty")).forEach(function(e){return e.addEventListener("click",i.onChooseAddImageAreaClick)}),this.element.addEventListener("dragenter",this.onDragEnter),this.element.addEventListener("dragover",this.onDragOver),this.element.addEventListener("dragleave",this.onDragLeave),this.element.addEventListener("dragend",this.onDragLeave),this.element.addEventListener("drop",this.onDrop)}return _createClass(t,[{key:"updateEmpty",value:function(){0<this.element.querySelectorAll(".inline-related:not(.empty-form):not(.deleted)").length?this.element.classList.add("non-empty"):this.element.classList.remove("non-empty")}},{key:"updateElementIndex",value:function(e,t,n){var r=new RegExp("(".concat(t,"-(\\d+|__prefix__))")),n="".concat(t,"-").concat(n);e.getAttribute("for")&&e.setAttribute("for",e.getAttribute("for").replace(r,n)),e.id&&(e.id=e.id.replace(r,n)),e.getAttribute("name")&&e.setAttribute("name",e.getAttribute("name").replace(r,n))}},{key:"updateAllIndexes",value:function(){var n=this,r=this.inlineFormset.options.prefix,e=Array.from(this.element.querySelectorAll(".inline-related:not(.empty-form)")).map(function(e){return e}).map(function(e,t){return n.updateElementIndex(e,r,t),Array.from(e.querySelectorAll("*")).map(function(e){return e}).forEach(function(e){n.updateElementIndex(e,r,t)}),e}).length;this.next=e,document.getElementById("id_".concat(r,"-TOTAL_FORMS")).value=String(this.next);var t=document.getElementById("id_".concat(r,"-MAX_NUM_FORMS")),e=parseInt(t.value,10);Number.isNaN(e)&&(e=0),""===t.value||0<e-this.next?this.element.querySelector(".iuw-add-image-btn").classList.add("visible-by-number"):this.element.querySelector(".iuw-add-image-btn").classList.remove("visible-by-number")}},{key:"adjustInlineRelated",value:function(t){var e=Array.from(t.querySelectorAll("input[type=hidden], input[type=checkbox], input[type=file]")).map(function(e){return e.parentElement.removeChild(e),e}),n=document.querySelector("p.file-upload a");(n=t.classList.contains("empty-form")?null:n)&&t.setAttribute("data-raw",n.getAttribute("href")),t.innerHTML="",e.forEach(function(e){return t.appendChild(e)}),n&&this.appendItem(t,n.getAttribute("href"))}},{key:"appendItem",value:function(e,t){var n=null,r=e.closest(".inline-related");"true"===r.getAttribute("data-candelete")&&((n=document.createElement("span")).classList.add("iuw-delete-icon"),n.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" width="100%" height="100%"><path xmlns="http://www.w3.org/2000/svg" d="m289.94 256 95-95A24 24 0 0 0 351 127l-95 95-95-95a24 24 0 0 0-34 34l95 95-95 95a24 24 0 1 0 34 34l95-95 95 95a24 24 0 0 0 34-34z"></path></svg>');var i=document.createElement("img");i.src=t,e.appendChild(i),n&&e.appendChild(n),r.removeEventListener("click",this.onRelatedItemClick),r.addEventListener("click",this.onRelatedItemClick);r=r.querySelector("input[type=file]");r.removeEventListener("change",this.onFileInputChange),r.addEventListener("change",this.onFileInputChange)}},{key:"addFile",value:function(e){var t,n=this.element.querySelector(".inline-related.empty-form");n&&((t=n.cloneNode(!0)).classList.remove("empty-form"),t.classList.remove("last-related"),t.setAttribute("data-candelete","true"),t.id="".concat(this.inlineFormset.options.prefix,"-").concat(this.next),n.parentElement.insertBefore(t,n),(n=new DataTransfer).items.add(e),t.querySelector("input[type=file]").files=n.files,this.appendItem(t,URL.createObjectURL(e)),this.updateEmpty(),this.updateAllIndexes())}}]),t}();document.addEventListener("DOMContentLoaded",function(){Array.from(document.querySelectorAll(".iuw-inline-root")).map(function(e){return new ImageUploaderInline(e)})});