"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalAction = void 0;
const codepipeline = require("@aws-cdk/aws-codepipeline");
const sns = require("@aws-cdk/aws-sns");
const subs = require("@aws-cdk/aws-sns-subscriptions");
const action_1 = require("./action");
/**
 * Manual approval action.
 */
class ManualApprovalAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        this.props = props;
    }
    get notificationTopic() {
        return this._notificationTopic;
    }
    bound(scope, _stage, options) {
        var _a;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_a = this._notificationTopic) === null || _a === void 0 ? void 0 : _a.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFudWFsLWFwcHJvdmFsLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1hbnVhbC1hcHByb3ZhbC1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMERBQTBEO0FBQzFELHdDQUF3QztBQUN4Qyx1REFBdUQ7QUFFdkQscUNBQWtDO0FBK0JsQzs7R0FFRztBQUNILE1BQWEsb0JBQXFCLFNBQVEsZUFBTTtJQVM5QyxZQUFZLEtBQWdDO1FBQzFDLEtBQUssQ0FBQztZQUNKLEdBQUcsS0FBSztZQUNSLFFBQVEsRUFBRSxZQUFZLENBQUMsY0FBYyxDQUFDLFFBQVE7WUFDOUMsUUFBUSxFQUFFLFFBQVE7WUFDbEIsY0FBYyxFQUFFLEVBQUUsU0FBUyxFQUFFLENBQUMsRUFBRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLFVBQVUsRUFBRSxDQUFDLEVBQUUsVUFBVSxFQUFFLENBQUMsRUFBRTtTQUM3RSxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBRUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVTLEtBQUssQ0FBQyxLQUFvQixFQUFFLE1BQTJCLEVBQUUsT0FBdUM7O1FBRXhHLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRTtZQUNoQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztTQUN4RDthQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksSUFBSSxFQUFFLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQ3JELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLGVBQWUsQ0FBQyxDQUFDO1NBQ2pFO1FBRUQsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEVBQUU7WUFDM0IsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDbkQsS0FBSyxNQUFNLFdBQVcsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksSUFBSSxFQUFFLEVBQUU7Z0JBQ3ZELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsSUFBSSxJQUFJLENBQUMsaUJBQWlCLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQzthQUNsRjtTQUNGO1FBRUQsT0FBTztZQUNMLGFBQWEsRUFBRSw0QkFBNEIsQ0FBQztnQkFDMUMsZUFBZSxRQUFFLElBQUksQ0FBQyxrQkFBa0IsMENBQUUsUUFBUTtnQkFDbEQsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCO2dCQUM1QyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQjthQUNsRCxDQUFDO1NBQ0gsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQS9DRCxvREErQ0M7QUFFRCxTQUFTLDRCQUE0QixDQUFDLE1BQWM7SUFDbEQsT0FBTyxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7QUFDL0UsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVwaXBlbGluZSBmcm9tICdAYXdzLWNkay9hd3MtY29kZXBpcGVsaW5lJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdAYXdzLWNkay9hd3Mtc25zJztcbmltcG9ydCAqIGFzIHN1YnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucy1zdWJzY3JpcHRpb25zJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEFjdGlvbiB9IGZyb20gJy4vYWN0aW9uJztcblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBvZiB0aGUge0BsaW5rIE1hbnVhbEFwcHJvdmFsQWN0aW9ufS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNYW51YWxBcHByb3ZhbEFjdGlvblByb3BzIGV4dGVuZHMgY29kZXBpcGVsaW5lLkNvbW1vbkF3c0FjdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIE9wdGlvbmFsIFNOUyB0b3BpYyB0byBzZW5kIG5vdGlmaWNhdGlvbnMgdG8gd2hlbiBhbiBhcHByb3ZhbCBpcyBwZW5kaW5nLlxuICAgKi9cbiAgcmVhZG9ubHkgbm90aWZpY2F0aW9uVG9waWM/OiBzbnMuSVRvcGljO1xuXG4gIC8qKlxuICAgKiBBIGxpc3Qgb2YgZW1haWwgYWRkcmVzc2VzIHRvIHN1YnNjcmliZSB0byBub3RpZmljYXRpb25zIHdoZW4gdGhpcyBBY3Rpb24gaXMgcGVuZGluZyBhcHByb3ZhbC5cbiAgICogSWYgdGhpcyBoYXMgYmVlbiBwcm92aWRlZCwgYnV0IG5vdCBgbm90aWZpY2F0aW9uVG9waWNgLFxuICAgKiBhIG5ldyBUb3BpYyB3aWxsIGJlIGNyZWF0ZWQuXG4gICAqL1xuICByZWFkb25seSBub3RpZnlFbWFpbHM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogQW55IGFkZGl0aW9uYWwgaW5mb3JtYXRpb24gdGhhdCB5b3Ugd2FudCB0byBpbmNsdWRlIGluIHRoZSBub3RpZmljYXRpb24gZW1haWwgbWVzc2FnZS5cbiAgICovXG4gIHJlYWRvbmx5IGFkZGl0aW9uYWxJbmZvcm1hdGlvbj86IHN0cmluZztcblxuICAvKipcbiAgICogVVJMIHlvdSB3YW50IHRvIHByb3ZpZGUgdG8gdGhlIHJldmlld2VyIGFzIHBhcnQgb2YgdGhlIGFwcHJvdmFsIHJlcXVlc3QuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIGFwcHJvdmFsIHJlcXVlc3Qgd2lsbCBub3QgaGF2ZSBhbiBleHRlcm5hbCBsaW5rXG4gICAqL1xuICByZWFkb25seSBleHRlcm5hbEVudGl0eUxpbms/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogTWFudWFsIGFwcHJvdmFsIGFjdGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIE1hbnVhbEFwcHJvdmFsQWN0aW9uIGV4dGVuZHMgQWN0aW9uIHtcbiAgLyoqXG4gICAqIFRoZSBTTlMgVG9waWMgcGFzc2VkIHdoZW4gY29uc3RydWN0aW5nIHRoZSBBY3Rpb24uXG4gICAqIElmIG5vIFRvcGljIHdhcyBwYXNzZWQsIGJ1dCBgbm90aWZ5RW1haWxzYCB3ZXJlIHByb3ZpZGVkLFxuICAgKiBhIG5ldyBUb3BpYyB3aWxsIGJlIGNyZWF0ZWQuXG4gICAqL1xuICBwcml2YXRlIF9ub3RpZmljYXRpb25Ub3BpYz86IHNucy5JVG9waWM7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IE1hbnVhbEFwcHJvdmFsQWN0aW9uUHJvcHM7XG5cbiAgY29uc3RydWN0b3IocHJvcHM6IE1hbnVhbEFwcHJvdmFsQWN0aW9uUHJvcHMpIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGNhdGVnb3J5OiBjb2RlcGlwZWxpbmUuQWN0aW9uQ2F0ZWdvcnkuQVBQUk9WQUwsXG4gICAgICBwcm92aWRlcjogJ01hbnVhbCcsXG4gICAgICBhcnRpZmFjdEJvdW5kczogeyBtaW5JbnB1dHM6IDAsIG1heElucHV0czogMCwgbWluT3V0cHV0czogMCwgbWF4T3V0cHV0czogMCB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICB9XG5cbiAgcHVibGljIGdldCBub3RpZmljYXRpb25Ub3BpYygpOiBzbnMuSVRvcGljIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5fbm90aWZpY2F0aW9uVG9waWM7XG4gIH1cblxuICBwcm90ZWN0ZWQgYm91bmQoc2NvcGU6IGNkay5Db25zdHJ1Y3QsIF9zdGFnZTogY29kZXBpcGVsaW5lLklTdGFnZSwgb3B0aW9uczogY29kZXBpcGVsaW5lLkFjdGlvbkJpbmRPcHRpb25zKTpcbiAgY29kZXBpcGVsaW5lLkFjdGlvbkNvbmZpZyB7XG4gICAgaWYgKHRoaXMucHJvcHMubm90aWZpY2F0aW9uVG9waWMpIHtcbiAgICAgIHRoaXMuX25vdGlmaWNhdGlvblRvcGljID0gdGhpcy5wcm9wcy5ub3RpZmljYXRpb25Ub3BpYztcbiAgICB9IGVsc2UgaWYgKCh0aGlzLnByb3BzLm5vdGlmeUVtYWlscyB8fCBbXSkubGVuZ3RoID4gMCkge1xuICAgICAgdGhpcy5fbm90aWZpY2F0aW9uVG9waWMgPSBuZXcgc25zLlRvcGljKHNjb3BlLCAnVG9waWNSZXNvdXJjZScpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLl9ub3RpZmljYXRpb25Ub3BpYykge1xuICAgICAgdGhpcy5fbm90aWZpY2F0aW9uVG9waWMuZ3JhbnRQdWJsaXNoKG9wdGlvbnMucm9sZSk7XG4gICAgICBmb3IgKGNvbnN0IG5vdGlmeUVtYWlsIG9mIHRoaXMucHJvcHMubm90aWZ5RW1haWxzIHx8IFtdKSB7XG4gICAgICAgIHRoaXMuX25vdGlmaWNhdGlvblRvcGljLmFkZFN1YnNjcmlwdGlvbihuZXcgc3Vicy5FbWFpbFN1YnNjcmlwdGlvbihub3RpZnlFbWFpbCkpO1xuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBjb25maWd1cmF0aW9uOiB1bmRlZmluZWRJZkFsbFZhbHVlc0FyZUVtcHR5KHtcbiAgICAgICAgTm90aWZpY2F0aW9uQXJuOiB0aGlzLl9ub3RpZmljYXRpb25Ub3BpYz8udG9waWNBcm4sXG4gICAgICAgIEN1c3RvbURhdGE6IHRoaXMucHJvcHMuYWRkaXRpb25hbEluZm9ybWF0aW9uLFxuICAgICAgICBFeHRlcm5hbEVudGl0eUxpbms6IHRoaXMucHJvcHMuZXh0ZXJuYWxFbnRpdHlMaW5rLFxuICAgICAgfSksXG4gICAgfTtcbiAgfVxufVxuXG5mdW5jdGlvbiB1bmRlZmluZWRJZkFsbFZhbHVlc0FyZUVtcHR5KG9iamVjdDogb2JqZWN0KTogb2JqZWN0IHwgdW5kZWZpbmVkIHtcbiAgcmV0dXJuIE9iamVjdC52YWx1ZXMob2JqZWN0KS5zb21lKHYgPT4gdiAhPT0gdW5kZWZpbmVkKSA/IG9iamVjdCA6IHVuZGVmaW5lZDtcbn1cbiJdfQ==