"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .verificationaddress import VerificationAddress, VerificationAddressTypedDict
from .verificationparameterinput import (
    VerificationParameterInput,
    VerificationParameterInputTypedDict,
)
from .verificationresponsedetail import (
    VerificationResponseDetail,
    VerificationResponseDetailTypedDict,
)
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class ProfileGender(str, Enum, metaclass=utils.OpenEnumMeta):
    MALE = "MALE"
    FEMALE = "FEMALE"
    INTERSEX = "INTERSEX"
    TRANS = "TRANS"
    NON_BINARY = "NON_BINARY"


class ResponseStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    COMPLETED = "COMPLETED"
    FAILED = "FAILED"
    PASSED = "PASSED"
    PENDING = "PENDING"


class VerificationRequestTypedDict(TypedDict):
    candidate_id: NotRequired[str]
    created_at: NotRequired[datetime]
    id: NotRequired[str]
    package_id: NotRequired[str]
    parameters: NotRequired[List[VerificationParameterInputTypedDict]]
    profile_addresses: NotRequired[List[VerificationAddressTypedDict]]
    profile_date_of_birth: NotRequired[str]
    profile_emails: NotRequired[List[str]]
    profile_gender: NotRequired[ProfileGender]
    profile_ip_address: NotRequired[str]
    profile_name: NotRequired[str]
    profile_national_identifier: NotRequired[str]
    profile_telephones: NotRequired[List[str]]
    raw: NotRequired[Dict[str, Any]]
    response_completed_at: NotRequired[datetime]
    response_details: NotRequired[List[VerificationResponseDetailTypedDict]]
    response_download_urls: NotRequired[List[str]]
    r"""report download"""
    response_expires_at: NotRequired[datetime]
    response_issued_at: NotRequired[datetime]
    response_redirect_url: NotRequired[str]
    response_score: NotRequired[float]
    response_source: NotRequired[str]
    response_status: NotRequired[ResponseStatus]
    target_url: NotRequired[str]
    updated_at: NotRequired[datetime]


class VerificationRequest(BaseModel):
    candidate_id: Optional[str] = None

    created_at: Optional[datetime] = None

    id: Optional[str] = None

    package_id: Optional[str] = None

    parameters: Optional[List[VerificationParameterInput]] = None

    profile_addresses: Optional[List[VerificationAddress]] = None

    profile_date_of_birth: Optional[str] = None

    profile_emails: Optional[List[str]] = None

    profile_gender: Annotated[
        Optional[ProfileGender], PlainValidator(validate_open_enum(False))
    ] = None

    profile_ip_address: Optional[str] = None

    profile_name: Optional[str] = None

    profile_national_identifier: Optional[str] = None

    profile_telephones: Optional[List[str]] = None

    raw: Optional[Dict[str, Any]] = None

    response_completed_at: Optional[datetime] = None

    response_details: Optional[List[VerificationResponseDetail]] = None

    response_download_urls: Optional[List[str]] = None
    r"""report download"""

    response_expires_at: Optional[datetime] = None

    response_issued_at: Optional[datetime] = None

    response_redirect_url: Optional[str] = None

    response_score: Optional[float] = None

    response_source: Optional[str] = None

    response_status: Annotated[
        Optional[ResponseStatus], PlainValidator(validate_open_enum(False))
    ] = None

    target_url: Optional[str] = None

    updated_at: Optional[datetime] = None
