"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class VerificationParameterType(str, Enum, metaclass=utils.OpenEnumMeta):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    MULTIPLE_CHOICE = "MULTIPLE_CHOICE"
    MULTIPLE_SELECT = "MULTIPLE_SELECT"
    DATE = "DATE"
    FILE = "FILE"


class VerificationParameterTypedDict(TypedDict):
    name: str
    file_types: NotRequired[List[str]]
    r"""valid file mime types"""
    id: NotRequired[str]
    is_required: NotRequired[bool]
    options: NotRequired[List[str]]
    r"""options for MULTIPLE_CHOICE and MULTIPLE_SELECT"""
    public_question: NotRequired[str]
    type: NotRequired[VerificationParameterType]
    valid_regions: NotRequired[List[str]]
    r"""{country}-{stateprovince/territory} or just {country} 2-digit ISO codes"""


class VerificationParameter(BaseModel):
    name: str

    file_types: Optional[List[str]] = None
    r"""valid file mime types"""

    id: Optional[str] = None

    is_required: Optional[bool] = None

    options: Optional[List[str]] = None
    r"""options for MULTIPLE_CHOICE and MULTIPLE_SELECT"""

    public_question: Optional[str] = None

    type: Annotated[
        Optional[VerificationParameterType], PlainValidator(validate_open_enum(False))
    ] = None

    valid_regions: Optional[List[str]] = None
    r"""{country}-{stateprovince/territory} or just {country} 2-digit ISO codes"""
