"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class HrisGroupType(str, Enum, metaclass=utils.OpenEnumMeta):
    TEAM = "TEAM"
    GROUP = "GROUP"
    DEPARTMENT = "DEPARTMENT"
    DIVISION = "DIVISION"
    BUSINESS_UNIT = "BUSINESS_UNIT"
    BRANCH = "BRANCH"
    SUB_DEPARTMENT = "SUB_DEPARTMENT"


class HrisGroupTypedDict(TypedDict):
    company_id: NotRequired[str]
    created_at: NotRequired[datetime]
    description: NotRequired[str]
    id: NotRequired[str]
    is_active: NotRequired[bool]
    manager_ids: NotRequired[List[str]]
    name: NotRequired[str]
    parent_id: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    type: NotRequired[HrisGroupType]
    updated_at: NotRequired[datetime]
    user_ids: NotRequired[List[str]]


class HrisGroup(BaseModel):
    company_id: Optional[str] = None

    created_at: Optional[datetime] = None

    description: Optional[str] = None

    id: Optional[str] = None

    is_active: Optional[bool] = None

    manager_ids: Optional[List[str]] = None

    name: Optional[str] = None

    parent_id: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    type: Annotated[
        Optional[HrisGroupType], PlainValidator(validate_open_enum(False))
    ] = None

    updated_at: Optional[datetime] = None

    user_ids: Optional[List[str]] = None
