"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .atsaddress import AtsAddress, AtsAddressTypedDict
from .atscompensation import AtsCompensation, AtsCompensationTypedDict
from .atsgroup import AtsGroup, AtsGroupTypedDict
from .atsjobopening import AtsJobOpening, AtsJobOpeningTypedDict
from .atsjobposting import AtsJobPosting, AtsJobPostingTypedDict
from .atsjobquestion import AtsJobQuestion, AtsJobQuestionTypedDict
from .atsmetadata import AtsMetadata, AtsMetadataTypedDict
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class EmploymentType(str, Enum, metaclass=utils.OpenEnumMeta):
    FULL_TIME = "FULL_TIME"
    PART_TIME = "PART_TIME"
    CONTRACTOR = "CONTRACTOR"
    INTERN = "INTERN"
    CONSULTANT = "CONSULTANT"
    VOLUNTEER = "VOLUNTEER"
    CASUAL = "CASUAL"
    SEASONAL = "SEASONAL"
    FREELANCE = "FREELANCE"
    OTHER = "OTHER"


class AtsJobStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    ARCHIVED = "ARCHIVED"
    PENDING = "PENDING"
    DRAFT = "DRAFT"
    OPEN = "OPEN"
    CLOSED = "CLOSED"


class AtsJobTypedDict(TypedDict):
    addresses: NotRequired[List[AtsAddressTypedDict]]
    closed_at: NotRequired[datetime]
    company_id: NotRequired[str]
    compensation: NotRequired[List[AtsCompensationTypedDict]]
    created_at: NotRequired[datetime]
    departments: NotRequired[List[str]]
    r"""@deprecated Use `groups` instead"""
    description: NotRequired[str]
    employment_type: NotRequired[EmploymentType]
    groups: NotRequired[List[AtsGroupTypedDict]]
    r"""The departments/divisions/teams that this job belongs to"""
    hiring_manager_ids: NotRequired[List[str]]
    id: NotRequired[str]
    language_locale: NotRequired[str]
    metadata: NotRequired[List[AtsMetadataTypedDict]]
    name: NotRequired[str]
    number_of_openings: NotRequired[float]
    openings: NotRequired[List[AtsJobOpeningTypedDict]]
    postings: NotRequired[List[AtsJobPostingTypedDict]]
    r"""Public job postings"""
    public_job_urls: NotRequired[List[str]]
    r"""URLs for pages containing public listings for the job"""
    questions: NotRequired[List[AtsJobQuestionTypedDict]]
    raw: NotRequired[Dict[str, Any]]
    recruiter_ids: NotRequired[List[str]]
    remote: NotRequired[bool]
    status: NotRequired[AtsJobStatus]
    updated_at: NotRequired[datetime]


class AtsJob(BaseModel):
    addresses: Optional[List[AtsAddress]] = None

    closed_at: Optional[datetime] = None

    company_id: Optional[str] = None

    compensation: Optional[List[AtsCompensation]] = None

    created_at: Optional[datetime] = None

    departments: Optional[List[str]] = None
    r"""@deprecated Use `groups` instead"""

    description: Optional[str] = None

    employment_type: Annotated[
        Optional[EmploymentType], PlainValidator(validate_open_enum(False))
    ] = None

    groups: Optional[List[AtsGroup]] = None
    r"""The departments/divisions/teams that this job belongs to"""

    hiring_manager_ids: Optional[List[str]] = None

    id: Optional[str] = None

    language_locale: Optional[str] = None

    metadata: Optional[List[AtsMetadata]] = None

    name: Optional[str] = None

    number_of_openings: Optional[float] = None

    openings: Optional[List[AtsJobOpening]] = None

    postings: Optional[List[AtsJobPosting]] = None
    r"""Public job postings"""

    public_job_urls: Optional[List[str]] = None
    r"""URLs for pages containing public listings for the job"""

    questions: Optional[List[AtsJobQuestion]] = None

    raw: Optional[Dict[str, Any]] = None

    recruiter_ids: Optional[List[str]] = None

    remote: Optional[bool] = None

    status: Annotated[
        Optional[AtsJobStatus], PlainValidator(validate_open_enum(False))
    ] = None

    updated_at: Optional[datetime] = None
