"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import issue as shared_issue
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import FieldMetadata, PathParamMetadata


class GetUnifiedIssueRequestTypedDict(TypedDict):
    id: str
    r"""ID of the Issue"""


class GetUnifiedIssueRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Issue"""


class GetUnifiedIssueResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    issue: NotRequired[shared_issue.IssueTypedDict]
    r"""Successful"""


class GetUnifiedIssueResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    issue: Optional[shared_issue.Issue] = None
    r"""Successful"""
