from datetime import date
from os.path import join, dirname
from app.domain.epp.models import Document
from app.domain.epp.parser import Parser


with open(join(dirname(__file__), "test.epp"), "r") as f:
    TEST_STRING = f.read()

parser = Parser()


def test_parse_returns_instance_of_document():
    r = parser.parse(TEST_STRING)
    assert isinstance(r, Document), "Expected result to be a Document instance"


def test_parse_returns_expected_number_of_items():
    r = parser.parse(TEST_STRING)
    assert len(r.products) == 2


def test_parse_returns_expected_number_of_price_list_items():
    r = parser.parse(TEST_STRING)
    assert len(r.price_list_items) == 2


# noinspection DuplicatedCode
def test_parse_returns_document_header_with_expected_some_values():
    r = parser.parse(TEST_STRING)
    assert len(r.document_headers) >= 1, "Expected at least one document header"
    header = r.document_headers[0].get_header()
    assert header.doc_type == "FS"
    assert header.status == 1
    assert header.fiscal_registration_status == 0
    assert header.document_number == 2369
    assert header.full_document_number == "2369/MAG/10/2025"
    assert header.place_of_issue == "Katowice"
    assert header.issue_date == date(2025, 10, 23)
    assert header.sale_date == date(2025, 10, 23)
