from app.domain.epp.models import Header

# noinspection SpellCheckingInspection
TEST_ROW = """"1.11",3,1250,"Nexo","sender_code","ENERGOTYTAN Sp. z o.o.","ENERGOTYTAN Sp. z o.o.","Katowice","40-287","1 Maja 38","9542827640","MAG","Magazyn podstawowy",,,0,,,,20251023000000,"Polska","PL","PL9542827640",1"""


def get_row():
    import csv

    reader = csv.reader([TEST_ROW], delimiter=",")
    return list(reader)[0]


def test_returns_instance_of_epp_header():
    r = Header.from_csv(get_row())
    assert isinstance(r, Header), "Expected result to be an instance of Header"


def test_returns_expected_values():
    header = Header.from_csv(get_row())
    assert header.edi_file_version == "1.11"
    assert header.communication_purpose == 3
    assert header.encoding_page == "1250"
    assert header.program_info == "Nexo"
    assert header.sender_code == "sender_code"
    # noinspection SpellCheckingInspection
    assert header.sender_short_name == "ENERGOTYTAN Sp. z o.o."
    # noinspection SpellCheckingInspection
    assert header.sender_long_name == "ENERGOTYTAN Sp. z o.o."
    assert header.sender_city == "Katowice"
    assert header.sender_postal_code == "40-287"
    assert header.sender_address == "1 Maja 38"
    assert header.sender_nip == "9542827640"
    assert header.warehouse_code == "MAG"
    assert header.warehouse_name == "Magazyn podstawowy"
    assert header.warehouse_description == ""
    assert header.warehouse_analytics == ""
    assert header.data_period == "0"
    assert header.period_start == ""
    assert header.period_end == ""
    assert header.communication_author == ""
    assert header.communication_date == "20251023000000"
    assert header.country == "Polska"
    assert header.eu_country_prefix == "PL"
    assert header.eu_sender_nip == "PL9542827640"
    assert header.is_eu_sender == 1
