from app.domain.epp.models import Document, PriceListItem

# noinspection DuplicatedCode
item_kwargs = {
    "profit": "",
    "net_price": 1,
    "price_name": "test",
    "markup_percent": "1",
    "gross_price": 1,
    "margin_percent": 100,
}

price_list_1, price_list_2 = (
    PriceListItem(item_id="1", **item_kwargs),
    PriceListItem(item_id="2", **item_kwargs),
)

# noinspection PyArgumentList,PyTypeChecker
document = Document(
    price_list_items=[price_list_1, price_list_2],
    document_headers=[],
    products=[],
    file_header=None,
    contractors=[],
    delivery_completion_date=[],
)


def test_document_get_price_returns_none_if_expected():
    assert document.get_price("does not exist") is None


def test_document_get_price_returns_expected():
    assert (
        document.get_price(price_list_1.item_id) == price_list_1
    ), "Expected price_list_1"
    assert (
        document.get_price(price_list_2.item_id) == price_list_2
    ), "Expected price_list_2"
